/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.service;

import me.prettyprint.cassandra.model.BasicColumnFamilyDefinition;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hom.openjpa.EntityFacade;
import me.prettyprint.hom.service.EntitySchemaStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySchemaManager {
    private static Logger log = LoggerFactory.getLogger(EntitySchemaManager.class);
    private Cluster cluster;
    private Keyspace keyspace;

    public EntitySchemaManager(Cluster cluster, Keyspace keyspace) {
        this.cluster = cluster;
        this.keyspace = keyspace;
    }

    public EntitySchemaStatus createSchema(EntityFacade entityFacade) {
        EntitySchemaStatus entitySchemaStatus;
        if (log.isDebugEnabled()) {
            log.debug("EntitySchemaManager creating schema for: {}", (Object)entityFacade);
        }
        BasicColumnFamilyDefinition columnFamilyDefinition = new BasicColumnFamilyDefinition();
        columnFamilyDefinition.setKeyspaceName(this.keyspace.getKeyspaceName());
        columnFamilyDefinition.setName(entityFacade.getColumnFamilyName());
        ThriftCfDef cfDef = new ThriftCfDef((ColumnFamilyDefinition)columnFamilyDefinition);
        try {
            this.cluster.addColumnFamily((ColumnFamilyDefinition)cfDef);
            entitySchemaStatus = new EntitySchemaStatus(EntitySchemaStatus.SchemaResult.CREATED);
        }
        catch (HInvalidRequestException ire) {
            if (log.isDebugEnabled()) {
                log.debug("Caught HInvalidRequestException on createSchema. Details {}", (Object)ire.getMessage());
            }
            entitySchemaStatus = new EntitySchemaStatus(EntitySchemaStatus.SchemaResult.NOT_MODIFIED);
        }
        return entitySchemaStatus;
    }
}

