package me.proton.core.contact.data.local.db.dao;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.entity.ContactCardEntity;
import me.proton.core.contact.domain.entity.ContactId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContactCardDao_Impl extends ContactCardDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContactCardEntity> __insertionAdapterOfContactCardEntity;

  private final ContactConverters __contactConverters = new ContactConverters();

  private final EntityDeletionOrUpdateAdapter<ContactCardEntity> __deletionAdapterOfContactCardEntity;

  private final EntityDeletionOrUpdateAdapter<ContactCardEntity> __updateAdapterOfContactCardEntity;

  public ContactCardDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContactCardEntity = new EntityInsertionAdapter<ContactCardEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `ContactCardEntity` (`contactId`,`type`,`data`,`signature`,`cardId`) VALUES (?,?,?,?,nullif(?, 0))";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactCardEntity entity) {
        final String _tmp = __contactConverters.fromContactIdToString(entity.getContactId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        statement.bindLong(2, entity.getType());
        if (entity.getData() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getData());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getSignature());
        }
        statement.bindLong(5, entity.getCardId());
      }
    };
    this.__deletionAdapterOfContactCardEntity = new EntityDeletionOrUpdateAdapter<ContactCardEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `ContactCardEntity` WHERE `cardId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactCardEntity entity) {
        statement.bindLong(1, entity.getCardId());
      }
    };
    this.__updateAdapterOfContactCardEntity = new EntityDeletionOrUpdateAdapter<ContactCardEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContactCardEntity` SET `contactId` = ?,`type` = ?,`data` = ?,`signature` = ?,`cardId` = ? WHERE `cardId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactCardEntity entity) {
        final String _tmp = __contactConverters.fromContactIdToString(entity.getContactId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        statement.bindLong(2, entity.getType());
        if (entity.getData() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getData());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getSignature());
        }
        statement.bindLong(5, entity.getCardId());
        statement.bindLong(6, entity.getCardId());
      }
    };
  }

  @Override
  public Object insertOrIgnore(final ContactCardEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContactCardEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final ContactCardEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfContactCardEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final ContactCardEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfContactCardEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final ContactCardEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactCardDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAllContactCards(final ContactId[] contactIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactCardDao_Impl.super.deleteAllContactCards(contactIds, __cont), $completion);
  }

  @Override
  protected Object deleteAllContactCardsSingleBatch(final ContactId[] contactIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactCardEntity WHERE contactId IN (");
        final int _inputSize = contactIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (ContactId _item : contactIds) {
          final String _tmp = __contactConverters.fromContactIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
