package me.proton.core.eventmanager.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.eventmanager.data.db.EventManagerConverters;
import me.proton.core.eventmanager.data.entity.EventMetadataEntity;
import me.proton.core.eventmanager.domain.EventManagerConfig;
import me.proton.core.eventmanager.domain.entity.RefreshType;
import me.proton.core.eventmanager.domain.entity.State;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class EventMetadataDao_Impl extends EventMetadataDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<EventMetadataEntity> __insertionAdapterOfEventMetadataEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EventManagerConverters __eventManagerConverters = new EventManagerConverters();

  private final EntityDeletionOrUpdateAdapter<EventMetadataEntity> __deletionAdapterOfEventMetadataEntity;

  private final EntityDeletionOrUpdateAdapter<EventMetadataEntity> __updateAdapterOfEventMetadataEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfUpdateEventId;

  private final SharedSQLiteStatement __preparedStmtOfUpdateNextEventId;

  private final SharedSQLiteStatement __preparedStmtOfUpdateState;

  private final SharedSQLiteStatement __preparedStmtOfUpdateState_1;

  private final SharedSQLiteStatement __preparedStmtOfUpdateRetry;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public EventMetadataDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfEventMetadataEntity = new EntityInsertionAdapter<EventMetadataEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `EventMetadataEntity` (`userId`,`config`,`eventId`,`nextEventId`,`refresh`,`more`,`retry`,`state`,`createdAt`,`updatedAt`,`fetchedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final EventMetadataEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __eventManagerConverters.fromEventManagerConfigToString(entity.getConfig());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getEventId() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getEventId());
        }
        if (entity.getNextEventId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getNextEventId());
        }
        final String _tmp_2 = __eventManagerConverters.fromRefreshTypeToString(entity.getRefresh());
        if (_tmp_2 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_2);
        }
        final Integer _tmp_3 = entity.getMore() == null ? null : (entity.getMore() ? 1 : 0);
        if (_tmp_3 == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, _tmp_3);
        }
        statement.bindLong(7, entity.getRetry());
        final String _tmp_4 = __eventManagerConverters.fromStateToString(entity.getState());
        if (_tmp_4 == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, _tmp_4);
        }
        statement.bindLong(9, entity.getCreatedAt());
        if (entity.getUpdatedAt() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getUpdatedAt());
        }
        if (entity.getFetchedAt() == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, entity.getFetchedAt());
        }
      }
    };
    this.__deletionAdapterOfEventMetadataEntity = new EntityDeletionOrUpdateAdapter<EventMetadataEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `EventMetadataEntity` WHERE `userId` = ? AND `config` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final EventMetadataEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __eventManagerConverters.fromEventManagerConfigToString(entity.getConfig());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
      }
    };
    this.__updateAdapterOfEventMetadataEntity = new EntityDeletionOrUpdateAdapter<EventMetadataEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `EventMetadataEntity` SET `userId` = ?,`config` = ?,`eventId` = ?,`nextEventId` = ?,`refresh` = ?,`more` = ?,`retry` = ?,`state` = ?,`createdAt` = ?,`updatedAt` = ?,`fetchedAt` = ? WHERE `userId` = ? AND `config` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final EventMetadataEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __eventManagerConverters.fromEventManagerConfigToString(entity.getConfig());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getEventId() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getEventId());
        }
        if (entity.getNextEventId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getNextEventId());
        }
        final String _tmp_2 = __eventManagerConverters.fromRefreshTypeToString(entity.getRefresh());
        if (_tmp_2 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_2);
        }
        final Integer _tmp_3 = entity.getMore() == null ? null : (entity.getMore() ? 1 : 0);
        if (_tmp_3 == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, _tmp_3);
        }
        statement.bindLong(7, entity.getRetry());
        final String _tmp_4 = __eventManagerConverters.fromStateToString(entity.getState());
        if (_tmp_4 == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, _tmp_4);
        }
        statement.bindLong(9, entity.getCreatedAt());
        if (entity.getUpdatedAt() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getUpdatedAt());
        }
        if (entity.getFetchedAt() == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, entity.getFetchedAt());
        }
        final String _tmp_5 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_5 == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, _tmp_5);
        }
        final String _tmp_6 = __eventManagerConverters.fromEventManagerConfigToString(entity.getConfig());
        if (_tmp_6 == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, _tmp_6);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateEventId = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE OR REPLACE EventMetadataEntity SET eventId = ? WHERE config = ? AND userId = ? AND eventId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateNextEventId = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE OR REPLACE EventMetadataEntity SET nextEventId = ? WHERE config = ? AND userId = ? AND eventId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateState = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE EventMetadataEntity SET state = ?, updatedAt = ? WHERE config = ? AND userId = ? AND eventId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateState_1 = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE EventMetadataEntity SET state = ?, updatedAt = ? WHERE config = ? AND userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateRetry = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE EventMetadataEntity SET retry = ?, updatedAt = ? WHERE config = ? AND userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM EventMetadataEntity WHERE config = ? AND userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final EventMetadataEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfEventMetadataEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final EventMetadataEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfEventMetadataEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final EventMetadataEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfEventMetadataEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final EventMetadataEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> EventMetadataDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object delete(final UserId userId, final EventManagerConfig config, final String eventId,
      final Continuation<? super Unit> arg3) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 3;
        if (eventId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, eventId);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg3);
  }

  @Override
  public Object updateEventId(final UserId userId, final EventManagerConfig config,
      final String oldEventId, final String newEventId, final Continuation<? super Unit> arg4) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateEventId.acquire();
        int _argIndex = 1;
        if (newEventId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, newEventId);
        }
        _argIndex = 2;
        final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 3;
        final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 4;
        if (oldEventId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, oldEventId);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateEventId.release(_stmt);
        }
      }
    }, arg4);
  }

  @Override
  public Object updateNextEventId(final UserId userId, final EventManagerConfig config,
      final String eventId, final String nextEventId, final Continuation<? super Unit> arg4) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateNextEventId.acquire();
        int _argIndex = 1;
        if (nextEventId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, nextEventId);
        }
        _argIndex = 2;
        final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 3;
        final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 4;
        if (eventId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, eventId);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateNextEventId.release(_stmt);
        }
      }
    }, arg4);
  }

  @Override
  public Object updateState(final UserId userId, final EventManagerConfig config,
      final String eventId, final State state, final long updatedAt,
      final Continuation<? super Unit> arg5) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateState.acquire();
        int _argIndex = 1;
        final String _tmp = __eventManagerConverters.fromStateToString(state);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updatedAt);
        _argIndex = 3;
        final String _tmp_1 = __eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 4;
        final String _tmp_2 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_2 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 5;
        if (eventId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, eventId);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateState.release(_stmt);
        }
      }
    }, arg5);
  }

  @Override
  public Object updateState(final UserId userId, final EventManagerConfig config, final State state,
      final long updatedAt, final Continuation<? super Unit> arg4) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateState_1.acquire();
        int _argIndex = 1;
        final String _tmp = __eventManagerConverters.fromStateToString(state);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updatedAt);
        _argIndex = 3;
        final String _tmp_1 = __eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 4;
        final String _tmp_2 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_2 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_2);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateState_1.release(_stmt);
        }
      }
    }, arg4);
  }

  @Override
  public Object updateRetry(final UserId userId, final EventManagerConfig config, final int retry,
      final long updatedAt, final Continuation<? super Unit> arg4) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateRetry.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, retry);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updatedAt);
        _argIndex = 3;
        final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 4;
        final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateRetry.release(_stmt);
        }
      }
    }, arg4);
  }

  @Override
  public Object deleteAll(final UserId userId, final EventManagerConfig config,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        int _argIndex = 1;
        final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Flow<List<EventMetadataEntity>> observe(final UserId userId,
      final EventManagerConfig config) {
    final String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? ORDER BY createdAt";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"EventMetadataEntity"}, new Callable<List<EventMetadataEntity>>() {
      @Override
      @NonNull
      public List<EventMetadataEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow(_cursor, "config");
          final int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "eventId");
          final int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "nextEventId");
          final int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow(_cursor, "refresh");
          final int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow(_cursor, "more");
          final int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow(_cursor, "retry");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfFetchedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "fetchedAt");
          final List<EventMetadataEntity> _result = new ArrayList<EventMetadataEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final EventMetadataEntity _item;
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final EventManagerConfig _tmpConfig;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfConfig)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfConfig);
            }
            _tmpConfig = __eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
            final String _tmpEventId;
            if (_cursor.isNull(_cursorIndexOfEventId)) {
              _tmpEventId = null;
            } else {
              _tmpEventId = _cursor.getString(_cursorIndexOfEventId);
            }
            final String _tmpNextEventId;
            if (_cursor.isNull(_cursorIndexOfNextEventId)) {
              _tmpNextEventId = null;
            } else {
              _tmpNextEventId = _cursor.getString(_cursorIndexOfNextEventId);
            }
            final RefreshType _tmpRefresh;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfRefresh)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfRefresh);
            }
            _tmpRefresh = __eventManagerConverters.fromStringToRefreshType(_tmp_4);
            final Boolean _tmpMore;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfMore)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfMore);
            }
            _tmpMore = _tmp_5 == null ? null : _tmp_5 != 0;
            final int _tmpRetry;
            _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
            final State _tmpState;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfState);
            }
            _tmpState = __eventManagerConverters.fromStringToState(_tmp_6);
            final long _tmpCreatedAt;
            _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
            final Long _tmpUpdatedAt;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmpUpdatedAt = null;
            } else {
              _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            final Long _tmpFetchedAt;
            if (_cursor.isNull(_cursorIndexOfFetchedAt)) {
              _tmpFetchedAt = null;
            } else {
              _tmpFetchedAt = _cursor.getLong(_cursorIndexOfFetchedAt);
            }
            _item = new EventMetadataEntity(_tmpUserId,_tmpConfig,_tmpEventId,_tmpNextEventId,_tmpRefresh,_tmpMore,_tmpRetry,_tmpState,_tmpCreatedAt,_tmpUpdatedAt,_tmpFetchedAt);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<EventMetadataEntity> observe(final UserId userId, final EventManagerConfig config,
      final String eventId) {
    final String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    _argIndex = 3;
    if (eventId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, eventId);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"EventMetadataEntity"}, new Callable<EventMetadataEntity>() {
      @Override
      @Nullable
      public EventMetadataEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow(_cursor, "config");
          final int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "eventId");
          final int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "nextEventId");
          final int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow(_cursor, "refresh");
          final int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow(_cursor, "more");
          final int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow(_cursor, "retry");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfFetchedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "fetchedAt");
          final EventMetadataEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final EventManagerConfig _tmpConfig;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfConfig)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfConfig);
            }
            _tmpConfig = __eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
            final String _tmpEventId;
            if (_cursor.isNull(_cursorIndexOfEventId)) {
              _tmpEventId = null;
            } else {
              _tmpEventId = _cursor.getString(_cursorIndexOfEventId);
            }
            final String _tmpNextEventId;
            if (_cursor.isNull(_cursorIndexOfNextEventId)) {
              _tmpNextEventId = null;
            } else {
              _tmpNextEventId = _cursor.getString(_cursorIndexOfNextEventId);
            }
            final RefreshType _tmpRefresh;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfRefresh)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfRefresh);
            }
            _tmpRefresh = __eventManagerConverters.fromStringToRefreshType(_tmp_4);
            final Boolean _tmpMore;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfMore)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfMore);
            }
            _tmpMore = _tmp_5 == null ? null : _tmp_5 != 0;
            final int _tmpRetry;
            _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
            final State _tmpState;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfState);
            }
            _tmpState = __eventManagerConverters.fromStringToState(_tmp_6);
            final long _tmpCreatedAt;
            _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
            final Long _tmpUpdatedAt;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmpUpdatedAt = null;
            } else {
              _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            final Long _tmpFetchedAt;
            if (_cursor.isNull(_cursorIndexOfFetchedAt)) {
              _tmpFetchedAt = null;
            } else {
              _tmpFetchedAt = _cursor.getLong(_cursorIndexOfFetchedAt);
            }
            _result = new EventMetadataEntity(_tmpUserId,_tmpConfig,_tmpEventId,_tmpNextEventId,_tmpRefresh,_tmpMore,_tmpRetry,_tmpState,_tmpCreatedAt,_tmpUpdatedAt,_tmpFetchedAt);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAll(final UserId userId,
      final Continuation<? super List<EventMetadataEntity>> arg1) {
    final String _sql = "SELECT * FROM EventMetadataEntity WHERE userId = ? ORDER BY createdAt";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<EventMetadataEntity>>() {
      @Override
      @NonNull
      public List<EventMetadataEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow(_cursor, "config");
          final int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "eventId");
          final int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "nextEventId");
          final int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow(_cursor, "refresh");
          final int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow(_cursor, "more");
          final int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow(_cursor, "retry");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfFetchedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "fetchedAt");
          final List<EventMetadataEntity> _result = new ArrayList<EventMetadataEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final EventMetadataEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final EventManagerConfig _tmpConfig;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfConfig)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfConfig);
            }
            _tmpConfig = __eventManagerConverters.fromStringToEventManagerConfig(_tmp_2);
            final String _tmpEventId;
            if (_cursor.isNull(_cursorIndexOfEventId)) {
              _tmpEventId = null;
            } else {
              _tmpEventId = _cursor.getString(_cursorIndexOfEventId);
            }
            final String _tmpNextEventId;
            if (_cursor.isNull(_cursorIndexOfNextEventId)) {
              _tmpNextEventId = null;
            } else {
              _tmpNextEventId = _cursor.getString(_cursorIndexOfNextEventId);
            }
            final RefreshType _tmpRefresh;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfRefresh)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfRefresh);
            }
            _tmpRefresh = __eventManagerConverters.fromStringToRefreshType(_tmp_3);
            final Boolean _tmpMore;
            final Integer _tmp_4;
            if (_cursor.isNull(_cursorIndexOfMore)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getInt(_cursorIndexOfMore);
            }
            _tmpMore = _tmp_4 == null ? null : _tmp_4 != 0;
            final int _tmpRetry;
            _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
            final State _tmpState;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfState);
            }
            _tmpState = __eventManagerConverters.fromStringToState(_tmp_5);
            final long _tmpCreatedAt;
            _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
            final Long _tmpUpdatedAt;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmpUpdatedAt = null;
            } else {
              _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            final Long _tmpFetchedAt;
            if (_cursor.isNull(_cursorIndexOfFetchedAt)) {
              _tmpFetchedAt = null;
            } else {
              _tmpFetchedAt = _cursor.getLong(_cursorIndexOfFetchedAt);
            }
            _item = new EventMetadataEntity(_tmpUserId,_tmpConfig,_tmpEventId,_tmpNextEventId,_tmpRefresh,_tmpMore,_tmpRetry,_tmpState,_tmpCreatedAt,_tmpUpdatedAt,_tmpFetchedAt);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object get(final UserId userId, final EventManagerConfig config,
      final Continuation<? super List<EventMetadataEntity>> arg2) {
    final String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? ORDER BY createdAt";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<EventMetadataEntity>>() {
      @Override
      @NonNull
      public List<EventMetadataEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow(_cursor, "config");
          final int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "eventId");
          final int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "nextEventId");
          final int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow(_cursor, "refresh");
          final int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow(_cursor, "more");
          final int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow(_cursor, "retry");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfFetchedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "fetchedAt");
          final List<EventMetadataEntity> _result = new ArrayList<EventMetadataEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final EventMetadataEntity _item;
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final EventManagerConfig _tmpConfig;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfConfig)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfConfig);
            }
            _tmpConfig = __eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
            final String _tmpEventId;
            if (_cursor.isNull(_cursorIndexOfEventId)) {
              _tmpEventId = null;
            } else {
              _tmpEventId = _cursor.getString(_cursorIndexOfEventId);
            }
            final String _tmpNextEventId;
            if (_cursor.isNull(_cursorIndexOfNextEventId)) {
              _tmpNextEventId = null;
            } else {
              _tmpNextEventId = _cursor.getString(_cursorIndexOfNextEventId);
            }
            final RefreshType _tmpRefresh;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfRefresh)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfRefresh);
            }
            _tmpRefresh = __eventManagerConverters.fromStringToRefreshType(_tmp_4);
            final Boolean _tmpMore;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfMore)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfMore);
            }
            _tmpMore = _tmp_5 == null ? null : _tmp_5 != 0;
            final int _tmpRetry;
            _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
            final State _tmpState;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfState);
            }
            _tmpState = __eventManagerConverters.fromStringToState(_tmp_6);
            final long _tmpCreatedAt;
            _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
            final Long _tmpUpdatedAt;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmpUpdatedAt = null;
            } else {
              _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            final Long _tmpFetchedAt;
            if (_cursor.isNull(_cursorIndexOfFetchedAt)) {
              _tmpFetchedAt = null;
            } else {
              _tmpFetchedAt = _cursor.getLong(_cursorIndexOfFetchedAt);
            }
            _item = new EventMetadataEntity(_tmpUserId,_tmpConfig,_tmpEventId,_tmpNextEventId,_tmpRefresh,_tmpMore,_tmpRetry,_tmpState,_tmpCreatedAt,_tmpUpdatedAt,_tmpFetchedAt);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg2);
  }

  @Override
  public Object get(final UserId userId, final EventManagerConfig config, final String eventId,
      final Continuation<? super EventMetadataEntity> arg3) {
    final String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    final String _tmp = __eventManagerConverters.fromEventManagerConfigToString(config);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    _argIndex = 3;
    if (eventId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, eventId);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<EventMetadataEntity>() {
      @Override
      @Nullable
      public EventMetadataEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow(_cursor, "config");
          final int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "eventId");
          final int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "nextEventId");
          final int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow(_cursor, "refresh");
          final int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow(_cursor, "more");
          final int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow(_cursor, "retry");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAt");
          final int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "updatedAt");
          final int _cursorIndexOfFetchedAt = CursorUtil.getColumnIndexOrThrow(_cursor, "fetchedAt");
          final EventMetadataEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final EventManagerConfig _tmpConfig;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfConfig)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfConfig);
            }
            _tmpConfig = __eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
            final String _tmpEventId;
            if (_cursor.isNull(_cursorIndexOfEventId)) {
              _tmpEventId = null;
            } else {
              _tmpEventId = _cursor.getString(_cursorIndexOfEventId);
            }
            final String _tmpNextEventId;
            if (_cursor.isNull(_cursorIndexOfNextEventId)) {
              _tmpNextEventId = null;
            } else {
              _tmpNextEventId = _cursor.getString(_cursorIndexOfNextEventId);
            }
            final RefreshType _tmpRefresh;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfRefresh)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfRefresh);
            }
            _tmpRefresh = __eventManagerConverters.fromStringToRefreshType(_tmp_4);
            final Boolean _tmpMore;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfMore)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfMore);
            }
            _tmpMore = _tmp_5 == null ? null : _tmp_5 != 0;
            final int _tmpRetry;
            _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
            final State _tmpState;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfState);
            }
            _tmpState = __eventManagerConverters.fromStringToState(_tmp_6);
            final long _tmpCreatedAt;
            _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
            final Long _tmpUpdatedAt;
            if (_cursor.isNull(_cursorIndexOfUpdatedAt)) {
              _tmpUpdatedAt = null;
            } else {
              _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
            }
            final Long _tmpFetchedAt;
            if (_cursor.isNull(_cursorIndexOfFetchedAt)) {
              _tmpFetchedAt = null;
            } else {
              _tmpFetchedAt = _cursor.getLong(_cursorIndexOfFetchedAt);
            }
            _result = new EventMetadataEntity(_tmpUserId,_tmpConfig,_tmpEventId,_tmpNextEventId,_tmpRefresh,_tmpMore,_tmpRetry,_tmpState,_tmpCreatedAt,_tmpUpdatedAt,_tmpFetchedAt);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg3);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
