package me.proton.core.key.data.db;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.key.data.entity.PublicAddressInfoEntity;
import me.proton.core.key.data.entity.SignedKeyListEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PublicAddressInfoDao_Impl extends PublicAddressInfoDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PublicAddressInfoEntity> __insertionAdapterOfPublicAddressInfoEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<PublicAddressInfoEntity> __deletionAdapterOfPublicAddressInfoEntity;

  private final EntityDeletionOrUpdateAdapter<PublicAddressInfoEntity> __updateAdapterOfPublicAddressInfoEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByEmail;

  public PublicAddressInfoDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPublicAddressInfoEntity = new EntityInsertionAdapter<PublicAddressInfoEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `PublicAddressInfoEntity` (`email`,`warnings`,`protonMx`,`isProton`,`addressSignedKeyList_data`,`addressSignedKeyList_signature`,`addressSignedKeyList_minEpochId`,`addressSignedKeyList_maxEpochId`,`addressSignedKeyList_expectedMinEpochId`,`catchAllSignedKeyList_data`,`catchAllSignedKeyList_signature`,`catchAllSignedKeyList_minEpochId`,`catchAllSignedKeyList_maxEpochId`,`catchAllSignedKeyList_expectedMinEpochId`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressInfoEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
        final String _tmp = __commonConverters.fromListOfStringToString(entity.getWarnings());
        if (_tmp == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp);
        }
        final int _tmp_1 = entity.getProtonMx() ? 1 : 0;
        statement.bindLong(3, _tmp_1);
        statement.bindLong(4, entity.isProton());
        final SignedKeyListEntity _tmpAddressSignedKeyList = entity.getAddressSignedKeyList();
        if (_tmpAddressSignedKeyList != null) {
          if (_tmpAddressSignedKeyList.getData() == null) {
            statement.bindNull(5);
          } else {
            statement.bindString(5, _tmpAddressSignedKeyList.getData());
          }
          if (_tmpAddressSignedKeyList.getSignature() == null) {
            statement.bindNull(6);
          } else {
            statement.bindString(6, _tmpAddressSignedKeyList.getSignature());
          }
          if (_tmpAddressSignedKeyList.getMinEpochId() == null) {
            statement.bindNull(7);
          } else {
            statement.bindLong(7, _tmpAddressSignedKeyList.getMinEpochId());
          }
          if (_tmpAddressSignedKeyList.getMaxEpochId() == null) {
            statement.bindNull(8);
          } else {
            statement.bindLong(8, _tmpAddressSignedKeyList.getMaxEpochId());
          }
          if (_tmpAddressSignedKeyList.getExpectedMinEpochId() == null) {
            statement.bindNull(9);
          } else {
            statement.bindLong(9, _tmpAddressSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          statement.bindNull(5);
          statement.bindNull(6);
          statement.bindNull(7);
          statement.bindNull(8);
          statement.bindNull(9);
        }
        final SignedKeyListEntity _tmpCatchAllSignedKeyList = entity.getCatchAllSignedKeyList();
        if (_tmpCatchAllSignedKeyList != null) {
          if (_tmpCatchAllSignedKeyList.getData() == null) {
            statement.bindNull(10);
          } else {
            statement.bindString(10, _tmpCatchAllSignedKeyList.getData());
          }
          if (_tmpCatchAllSignedKeyList.getSignature() == null) {
            statement.bindNull(11);
          } else {
            statement.bindString(11, _tmpCatchAllSignedKeyList.getSignature());
          }
          if (_tmpCatchAllSignedKeyList.getMinEpochId() == null) {
            statement.bindNull(12);
          } else {
            statement.bindLong(12, _tmpCatchAllSignedKeyList.getMinEpochId());
          }
          if (_tmpCatchAllSignedKeyList.getMaxEpochId() == null) {
            statement.bindNull(13);
          } else {
            statement.bindLong(13, _tmpCatchAllSignedKeyList.getMaxEpochId());
          }
          if (_tmpCatchAllSignedKeyList.getExpectedMinEpochId() == null) {
            statement.bindNull(14);
          } else {
            statement.bindLong(14, _tmpCatchAllSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          statement.bindNull(10);
          statement.bindNull(11);
          statement.bindNull(12);
          statement.bindNull(13);
          statement.bindNull(14);
        }
      }
    };
    this.__deletionAdapterOfPublicAddressInfoEntity = new EntityDeletionOrUpdateAdapter<PublicAddressInfoEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `PublicAddressInfoEntity` WHERE `email` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressInfoEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
      }
    };
    this.__updateAdapterOfPublicAddressInfoEntity = new EntityDeletionOrUpdateAdapter<PublicAddressInfoEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PublicAddressInfoEntity` SET `email` = ?,`warnings` = ?,`protonMx` = ?,`isProton` = ?,`addressSignedKeyList_data` = ?,`addressSignedKeyList_signature` = ?,`addressSignedKeyList_minEpochId` = ?,`addressSignedKeyList_maxEpochId` = ?,`addressSignedKeyList_expectedMinEpochId` = ?,`catchAllSignedKeyList_data` = ?,`catchAllSignedKeyList_signature` = ?,`catchAllSignedKeyList_minEpochId` = ?,`catchAllSignedKeyList_maxEpochId` = ?,`catchAllSignedKeyList_expectedMinEpochId` = ? WHERE `email` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressInfoEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
        final String _tmp = __commonConverters.fromListOfStringToString(entity.getWarnings());
        if (_tmp == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp);
        }
        final int _tmp_1 = entity.getProtonMx() ? 1 : 0;
        statement.bindLong(3, _tmp_1);
        statement.bindLong(4, entity.isProton());
        final SignedKeyListEntity _tmpAddressSignedKeyList = entity.getAddressSignedKeyList();
        if (_tmpAddressSignedKeyList != null) {
          if (_tmpAddressSignedKeyList.getData() == null) {
            statement.bindNull(5);
          } else {
            statement.bindString(5, _tmpAddressSignedKeyList.getData());
          }
          if (_tmpAddressSignedKeyList.getSignature() == null) {
            statement.bindNull(6);
          } else {
            statement.bindString(6, _tmpAddressSignedKeyList.getSignature());
          }
          if (_tmpAddressSignedKeyList.getMinEpochId() == null) {
            statement.bindNull(7);
          } else {
            statement.bindLong(7, _tmpAddressSignedKeyList.getMinEpochId());
          }
          if (_tmpAddressSignedKeyList.getMaxEpochId() == null) {
            statement.bindNull(8);
          } else {
            statement.bindLong(8, _tmpAddressSignedKeyList.getMaxEpochId());
          }
          if (_tmpAddressSignedKeyList.getExpectedMinEpochId() == null) {
            statement.bindNull(9);
          } else {
            statement.bindLong(9, _tmpAddressSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          statement.bindNull(5);
          statement.bindNull(6);
          statement.bindNull(7);
          statement.bindNull(8);
          statement.bindNull(9);
        }
        final SignedKeyListEntity _tmpCatchAllSignedKeyList = entity.getCatchAllSignedKeyList();
        if (_tmpCatchAllSignedKeyList != null) {
          if (_tmpCatchAllSignedKeyList.getData() == null) {
            statement.bindNull(10);
          } else {
            statement.bindString(10, _tmpCatchAllSignedKeyList.getData());
          }
          if (_tmpCatchAllSignedKeyList.getSignature() == null) {
            statement.bindNull(11);
          } else {
            statement.bindString(11, _tmpCatchAllSignedKeyList.getSignature());
          }
          if (_tmpCatchAllSignedKeyList.getMinEpochId() == null) {
            statement.bindNull(12);
          } else {
            statement.bindLong(12, _tmpCatchAllSignedKeyList.getMinEpochId());
          }
          if (_tmpCatchAllSignedKeyList.getMaxEpochId() == null) {
            statement.bindNull(13);
          } else {
            statement.bindLong(13, _tmpCatchAllSignedKeyList.getMaxEpochId());
          }
          if (_tmpCatchAllSignedKeyList.getExpectedMinEpochId() == null) {
            statement.bindNull(14);
          } else {
            statement.bindLong(14, _tmpCatchAllSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          statement.bindNull(10);
          statement.bindNull(11);
          statement.bindNull(12);
          statement.bindNull(13);
          statement.bindNull(14);
        }
        if (entity.getEmail() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getEmail());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM PublicAddressInfoEntity";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteByEmail = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM PublicAddressInfoEntity WHERE email = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final PublicAddressInfoEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPublicAddressInfoEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final PublicAddressInfoEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfPublicAddressInfoEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final PublicAddressInfoEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfPublicAddressInfoEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final PublicAddressInfoEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PublicAddressInfoDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Object deleteByEmail(final String email, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByEmail.acquire();
        int _argIndex = 1;
        if (email == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, email);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteByEmail.release(_stmt);
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
