package me.proton.core.label.data.local;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.label.domain.entity.LabelId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class LabelDao_Impl extends LabelDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LabelEntity> __insertionAdapterOfLabelEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final LabelConverters __labelConverters = new LabelConverters();

  private final EntityDeletionOrUpdateAdapter<LabelEntity> __deletionAdapterOfLabelEntity;

  private final EntityDeletionOrUpdateAdapter<LabelEntity> __updateAdapterOfLabelEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public LabelDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLabelEntity = new EntityInsertionAdapter<LabelEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `LabelEntity` (`userId`,`labelId`,`parentId`,`name`,`type`,`path`,`color`,`order`,`isNotified`,`isExpanded`,`isSticky`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LabelEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __labelConverters.fromLabelIdToString(entity.getLabelId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getParentId() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getParentId());
        }
        if (entity.getName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getName());
        }
        statement.bindLong(5, entity.getType());
        if (entity.getPath() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPath());
        }
        if (entity.getColor() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getColor());
        }
        statement.bindLong(8, entity.getOrder());
        final Integer _tmp_2 = entity.isNotified() == null ? null : (entity.isNotified() ? 1 : 0);
        if (_tmp_2 == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, _tmp_2);
        }
        final Integer _tmp_3 = entity.isExpanded() == null ? null : (entity.isExpanded() ? 1 : 0);
        if (_tmp_3 == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, _tmp_3);
        }
        final Integer _tmp_4 = entity.isSticky() == null ? null : (entity.isSticky() ? 1 : 0);
        if (_tmp_4 == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, _tmp_4);
        }
      }
    };
    this.__deletionAdapterOfLabelEntity = new EntityDeletionOrUpdateAdapter<LabelEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `LabelEntity` WHERE `userId` = ? AND `labelId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LabelEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __labelConverters.fromLabelIdToString(entity.getLabelId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
      }
    };
    this.__updateAdapterOfLabelEntity = new EntityDeletionOrUpdateAdapter<LabelEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `LabelEntity` SET `userId` = ?,`labelId` = ?,`parentId` = ?,`name` = ?,`type` = ?,`path` = ?,`color` = ?,`order` = ?,`isNotified` = ?,`isExpanded` = ?,`isSticky` = ? WHERE `userId` = ? AND `labelId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LabelEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __labelConverters.fromLabelIdToString(entity.getLabelId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getParentId() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getParentId());
        }
        if (entity.getName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getName());
        }
        statement.bindLong(5, entity.getType());
        if (entity.getPath() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPath());
        }
        if (entity.getColor() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getColor());
        }
        statement.bindLong(8, entity.getOrder());
        final Integer _tmp_2 = entity.isNotified() == null ? null : (entity.isNotified() ? 1 : 0);
        if (_tmp_2 == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, _tmp_2);
        }
        final Integer _tmp_3 = entity.isExpanded() == null ? null : (entity.isExpanded() ? 1 : 0);
        if (_tmp_3 == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, _tmp_3);
        }
        final Integer _tmp_4 = entity.isSticky() == null ? null : (entity.isSticky() ? 1 : 0);
        if (_tmp_4 == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, _tmp_4);
        }
        final String _tmp_5 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_5 == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, _tmp_5);
        }
        final String _tmp_6 = __labelConverters.fromLabelIdToString(entity.getLabelId());
        if (_tmp_6 == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, _tmp_6);
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM LabelEntity WHERE userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final LabelEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfLabelEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final LabelEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfLabelEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final LabelEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfLabelEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final LabelEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> LabelDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAll(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Flow<List<LabelEntity>> observeAll(final UserId userId, final int type) {
    final String _sql = "SELECT * FROM LabelEntity WHERE userId = ? AND type = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    _statement.bindLong(_argIndex, type);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"LabelEntity"}, new Callable<List<LabelEntity>>() {
      @Override
      @NonNull
      public List<LabelEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfLabelId = CursorUtil.getColumnIndexOrThrow(_cursor, "labelId");
          final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
          final int _cursorIndexOfColor = CursorUtil.getColumnIndexOrThrow(_cursor, "color");
          final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
          final int _cursorIndexOfIsNotified = CursorUtil.getColumnIndexOrThrow(_cursor, "isNotified");
          final int _cursorIndexOfIsExpanded = CursorUtil.getColumnIndexOrThrow(_cursor, "isExpanded");
          final int _cursorIndexOfIsSticky = CursorUtil.getColumnIndexOrThrow(_cursor, "isSticky");
          final List<LabelEntity> _result = new ArrayList<LabelEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final LabelEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final LabelId _tmpLabelId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfLabelId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfLabelId);
            }
            _tmpLabelId = __labelConverters.fromStringToLabelId(_tmp_2);
            final String _tmpParentId;
            if (_cursor.isNull(_cursorIndexOfParentId)) {
              _tmpParentId = null;
            } else {
              _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final int _tmpType;
            _tmpType = _cursor.getInt(_cursorIndexOfType);
            final String _tmpPath;
            if (_cursor.isNull(_cursorIndexOfPath)) {
              _tmpPath = null;
            } else {
              _tmpPath = _cursor.getString(_cursorIndexOfPath);
            }
            final String _tmpColor;
            if (_cursor.isNull(_cursorIndexOfColor)) {
              _tmpColor = null;
            } else {
              _tmpColor = _cursor.getString(_cursorIndexOfColor);
            }
            final int _tmpOrder;
            _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
            final Boolean _tmpIsNotified;
            final Integer _tmp_3;
            if (_cursor.isNull(_cursorIndexOfIsNotified)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getInt(_cursorIndexOfIsNotified);
            }
            _tmpIsNotified = _tmp_3 == null ? null : _tmp_3 != 0;
            final Boolean _tmpIsExpanded;
            final Integer _tmp_4;
            if (_cursor.isNull(_cursorIndexOfIsExpanded)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getInt(_cursorIndexOfIsExpanded);
            }
            _tmpIsExpanded = _tmp_4 == null ? null : _tmp_4 != 0;
            final Boolean _tmpIsSticky;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfIsSticky)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfIsSticky);
            }
            _tmpIsSticky = _tmp_5 == null ? null : _tmp_5 != 0;
            _item = new LabelEntity(_tmpUserId,_tmpLabelId,_tmpParentId,_tmpName,_tmpType,_tmpPath,_tmpColor,_tmpOrder,_tmpIsNotified,_tmpIsExpanded,_tmpIsSticky);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAll(final UserId userId, final int type,
      final Continuation<? super List<LabelEntity>> arg2) {
    final String _sql = "SELECT * FROM LabelEntity WHERE userId = ? AND type = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    _statement.bindLong(_argIndex, type);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<LabelEntity>>() {
      @Override
      @NonNull
      public List<LabelEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfLabelId = CursorUtil.getColumnIndexOrThrow(_cursor, "labelId");
          final int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow(_cursor, "parentId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
          final int _cursorIndexOfColor = CursorUtil.getColumnIndexOrThrow(_cursor, "color");
          final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
          final int _cursorIndexOfIsNotified = CursorUtil.getColumnIndexOrThrow(_cursor, "isNotified");
          final int _cursorIndexOfIsExpanded = CursorUtil.getColumnIndexOrThrow(_cursor, "isExpanded");
          final int _cursorIndexOfIsSticky = CursorUtil.getColumnIndexOrThrow(_cursor, "isSticky");
          final List<LabelEntity> _result = new ArrayList<LabelEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final LabelEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final LabelId _tmpLabelId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfLabelId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfLabelId);
            }
            _tmpLabelId = __labelConverters.fromStringToLabelId(_tmp_2);
            final String _tmpParentId;
            if (_cursor.isNull(_cursorIndexOfParentId)) {
              _tmpParentId = null;
            } else {
              _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final int _tmpType;
            _tmpType = _cursor.getInt(_cursorIndexOfType);
            final String _tmpPath;
            if (_cursor.isNull(_cursorIndexOfPath)) {
              _tmpPath = null;
            } else {
              _tmpPath = _cursor.getString(_cursorIndexOfPath);
            }
            final String _tmpColor;
            if (_cursor.isNull(_cursorIndexOfColor)) {
              _tmpColor = null;
            } else {
              _tmpColor = _cursor.getString(_cursorIndexOfColor);
            }
            final int _tmpOrder;
            _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
            final Boolean _tmpIsNotified;
            final Integer _tmp_3;
            if (_cursor.isNull(_cursorIndexOfIsNotified)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getInt(_cursorIndexOfIsNotified);
            }
            _tmpIsNotified = _tmp_3 == null ? null : _tmp_3 != 0;
            final Boolean _tmpIsExpanded;
            final Integer _tmp_4;
            if (_cursor.isNull(_cursorIndexOfIsExpanded)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getInt(_cursorIndexOfIsExpanded);
            }
            _tmpIsExpanded = _tmp_4 == null ? null : _tmp_4 != 0;
            final Boolean _tmpIsSticky;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfIsSticky)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfIsSticky);
            }
            _tmpIsSticky = _tmp_5 == null ? null : _tmp_5 != 0;
            _item = new LabelEntity(_tmpUserId,_tmpLabelId,_tmpParentId,_tmpName,_tmpType,_tmpPath,_tmpColor,_tmpOrder,_tmpIsNotified,_tmpIsExpanded,_tmpIsSticky);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg2);
  }

  @Override
  public Object delete(final UserId userId, final List<String> labelIds,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM LabelEntity WHERE userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" AND labelId IN (");
        final int _inputSize = labelIds.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        for (String _item : labelIds) {
          if (_item == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _item);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg2);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
