package me.proton.core.payment.data.local.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import me.proton.core.payment.data.local.entity.GooglePurchaseEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class GooglePurchaseDao_Impl extends GooglePurchaseDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<GooglePurchaseEntity> __insertionAdapterOfGooglePurchaseEntity;

  private final EntityDeletionOrUpdateAdapter<GooglePurchaseEntity> __deletionAdapterOfGooglePurchaseEntity;

  private final EntityDeletionOrUpdateAdapter<GooglePurchaseEntity> __updateAdapterOfGooglePurchaseEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByGooglePurchaseToken;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByProtonPaymentToken;

  public GooglePurchaseDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfGooglePurchaseEntity = new EntityInsertionAdapter<GooglePurchaseEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `GooglePurchaseEntity` (`googlePurchaseToken`,`paymentToken`) VALUES (?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final GooglePurchaseEntity entity) {
        if (entity.getGooglePurchaseToken() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getGooglePurchaseToken());
        }
        if (entity.getPaymentToken() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPaymentToken());
        }
      }
    };
    this.__deletionAdapterOfGooglePurchaseEntity = new EntityDeletionOrUpdateAdapter<GooglePurchaseEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `GooglePurchaseEntity` WHERE `googlePurchaseToken` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final GooglePurchaseEntity entity) {
        if (entity.getGooglePurchaseToken() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getGooglePurchaseToken());
        }
      }
    };
    this.__updateAdapterOfGooglePurchaseEntity = new EntityDeletionOrUpdateAdapter<GooglePurchaseEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `GooglePurchaseEntity` SET `googlePurchaseToken` = ?,`paymentToken` = ? WHERE `googlePurchaseToken` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final GooglePurchaseEntity entity) {
        if (entity.getGooglePurchaseToken() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getGooglePurchaseToken());
        }
        if (entity.getPaymentToken() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPaymentToken());
        }
        if (entity.getGooglePurchaseToken() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getGooglePurchaseToken());
        }
      }
    };
    this.__preparedStmtOfDeleteByGooglePurchaseToken = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM GooglePurchaseEntity WHERE googlePurchaseToken = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteByProtonPaymentToken = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM GooglePurchaseEntity WHERE paymentToken = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final GooglePurchaseEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfGooglePurchaseEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final GooglePurchaseEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfGooglePurchaseEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final GooglePurchaseEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfGooglePurchaseEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final GooglePurchaseEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> GooglePurchaseDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteByGooglePurchaseToken(final String googlePurchaseToken,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByGooglePurchaseToken.acquire();
        int _argIndex = 1;
        if (googlePurchaseToken == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, googlePurchaseToken);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteByGooglePurchaseToken.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteByProtonPaymentToken(final String paymentToken,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByProtonPaymentToken.acquire();
        int _argIndex = 1;
        if (paymentToken == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, paymentToken);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteByProtonPaymentToken.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object findByPaymentToken(final String paymentToken,
      final Continuation<? super GooglePurchaseEntity> arg1) {
    final String _sql = "SELECT * FROM GooglePurchaseEntity WHERE paymentToken = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (paymentToken == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, paymentToken);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<GooglePurchaseEntity>() {
      @Override
      @Nullable
      public GooglePurchaseEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGooglePurchaseToken = CursorUtil.getColumnIndexOrThrow(_cursor, "googlePurchaseToken");
          final int _cursorIndexOfPaymentToken = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentToken");
          final GooglePurchaseEntity _result;
          if (_cursor.moveToFirst()) {
            final String _tmpGooglePurchaseToken;
            if (_cursor.isNull(_cursorIndexOfGooglePurchaseToken)) {
              _tmpGooglePurchaseToken = null;
            } else {
              _tmpGooglePurchaseToken = _cursor.getString(_cursorIndexOfGooglePurchaseToken);
            }
            final String _tmpPaymentToken;
            if (_cursor.isNull(_cursorIndexOfPaymentToken)) {
              _tmpPaymentToken = null;
            } else {
              _tmpPaymentToken = _cursor.getString(_cursorIndexOfPaymentToken);
            }
            _result = new GooglePurchaseEntity(_tmpGooglePurchaseToken,_tmpPaymentToken);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
