package me.proton.core.userrecovery.data.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.userrecovery.data.entity.RecoveryFileEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class DeviceRecoveryDao_Impl extends DeviceRecoveryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<RecoveryFileEntity> __insertionAdapterOfRecoveryFileEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<RecoveryFileEntity> __deletionAdapterOfRecoveryFileEntity;

  private final EntityDeletionOrUpdateAdapter<RecoveryFileEntity> __updateAdapterOfRecoveryFileEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public DeviceRecoveryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfRecoveryFileEntity = new EntityInsertionAdapter<RecoveryFileEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `RecoveryFileEntity` (`userId`,`createdAtUtcMillis`,`keyCount`,`recoveryFile`,`recoverySecretHash`) VALUES (?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final RecoveryFileEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        statement.bindLong(2, entity.getCreatedAtUtcMillis());
        if (entity.getKeyCount() == null) {
          statement.bindNull(3);
        } else {
          statement.bindLong(3, entity.getKeyCount());
        }
        if (entity.getRecoveryFile() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getRecoveryFile());
        }
        if (entity.getRecoverySecretHash() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getRecoverySecretHash());
        }
      }
    };
    this.__deletionAdapterOfRecoveryFileEntity = new EntityDeletionOrUpdateAdapter<RecoveryFileEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `RecoveryFileEntity` WHERE `recoverySecretHash` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final RecoveryFileEntity entity) {
        if (entity.getRecoverySecretHash() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getRecoverySecretHash());
        }
      }
    };
    this.__updateAdapterOfRecoveryFileEntity = new EntityDeletionOrUpdateAdapter<RecoveryFileEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `RecoveryFileEntity` SET `userId` = ?,`createdAtUtcMillis` = ?,`keyCount` = ?,`recoveryFile` = ?,`recoverySecretHash` = ? WHERE `recoverySecretHash` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final RecoveryFileEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        statement.bindLong(2, entity.getCreatedAtUtcMillis());
        if (entity.getKeyCount() == null) {
          statement.bindNull(3);
        } else {
          statement.bindLong(3, entity.getKeyCount());
        }
        if (entity.getRecoveryFile() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getRecoveryFile());
        }
        if (entity.getRecoverySecretHash() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getRecoverySecretHash());
        }
        if (entity.getRecoverySecretHash() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getRecoverySecretHash());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM RecoveryFileEntity WHERE userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final RecoveryFileEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfRecoveryFileEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final RecoveryFileEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfRecoveryFileEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final RecoveryFileEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfRecoveryFileEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final RecoveryFileEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> DeviceRecoveryDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAll(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object getRecoveryFiles(final UserId userId,
      final Continuation<? super List<RecoveryFileEntity>> arg1) {
    final String _sql = "SELECT * FROM RecoveryFileEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<RecoveryFileEntity>>() {
      @Override
      @NonNull
      public List<RecoveryFileEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfCreatedAtUtcMillis = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcMillis");
          final int _cursorIndexOfKeyCount = CursorUtil.getColumnIndexOrThrow(_cursor, "keyCount");
          final int _cursorIndexOfRecoveryFile = CursorUtil.getColumnIndexOrThrow(_cursor, "recoveryFile");
          final int _cursorIndexOfRecoverySecretHash = CursorUtil.getColumnIndexOrThrow(_cursor, "recoverySecretHash");
          final List<RecoveryFileEntity> _result = new ArrayList<RecoveryFileEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final RecoveryFileEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final long _tmpCreatedAtUtcMillis;
            _tmpCreatedAtUtcMillis = _cursor.getLong(_cursorIndexOfCreatedAtUtcMillis);
            final Integer _tmpKeyCount;
            if (_cursor.isNull(_cursorIndexOfKeyCount)) {
              _tmpKeyCount = null;
            } else {
              _tmpKeyCount = _cursor.getInt(_cursorIndexOfKeyCount);
            }
            final String _tmpRecoveryFile;
            if (_cursor.isNull(_cursorIndexOfRecoveryFile)) {
              _tmpRecoveryFile = null;
            } else {
              _tmpRecoveryFile = _cursor.getString(_cursorIndexOfRecoveryFile);
            }
            final String _tmpRecoverySecretHash;
            if (_cursor.isNull(_cursorIndexOfRecoverySecretHash)) {
              _tmpRecoverySecretHash = null;
            } else {
              _tmpRecoverySecretHash = _cursor.getString(_cursorIndexOfRecoverySecretHash);
            }
            _item = new RecoveryFileEntity(_tmpUserId,_tmpCreatedAtUtcMillis,_tmpKeyCount,_tmpRecoveryFile,_tmpRecoverySecretHash);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
