package me.proton.core.humanverification.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.humanverification.data.entity.HumanVerificationEntity;
import me.proton.core.network.domain.client.ClientIdType;
import me.proton.core.network.domain.humanverification.HumanVerificationState;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class HumanVerificationDetailsDao_Impl extends HumanVerificationDetailsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<HumanVerificationEntity> __insertionAdapterOfHumanVerificationEntity;

  private final HumanVerificationConverters __humanVerificationConverters = new HumanVerificationConverters();

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<HumanVerificationEntity> __deletionAdapterOfHumanVerificationEntity;

  private final EntityDeletionOrUpdateAdapter<HumanVerificationEntity> __updateAdapterOfHumanVerificationEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByClientId;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStateAndToken;

  public HumanVerificationDetailsDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfHumanVerificationEntity = new EntityInsertionAdapter<HumanVerificationEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `HumanVerificationEntity` (`clientId`,`clientIdType`,`verificationMethods`,`verificationToken`,`state`,`humanHeaderTokenType`,`humanHeaderTokenCode`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final HumanVerificationEntity entity) {
        if (entity.getClientId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getClientId());
        }
        final String _tmp = __humanVerificationConverters.fromClientIdTypeToString(entity.getClientIdType());
        if (_tmp == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp);
        }
        final String _tmp_1 = __commonConverters.fromListOfStringToString(entity.getVerificationMethods());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        if (entity.getVerificationToken() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getVerificationToken());
        }
        final String _tmp_2 = __humanVerificationConverters.fromHumanVerificationStateToString(entity.getState());
        if (_tmp_2 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_2);
        }
        if (entity.getHumanHeaderTokenType() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getHumanHeaderTokenType());
        }
        if (entity.getHumanHeaderTokenCode() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getHumanHeaderTokenCode());
        }
      }
    };
    this.__deletionAdapterOfHumanVerificationEntity = new EntityDeletionOrUpdateAdapter<HumanVerificationEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `HumanVerificationEntity` WHERE `clientId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final HumanVerificationEntity entity) {
        if (entity.getClientId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getClientId());
        }
      }
    };
    this.__updateAdapterOfHumanVerificationEntity = new EntityDeletionOrUpdateAdapter<HumanVerificationEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `HumanVerificationEntity` SET `clientId` = ?,`clientIdType` = ?,`verificationMethods` = ?,`verificationToken` = ?,`state` = ?,`humanHeaderTokenType` = ?,`humanHeaderTokenCode` = ? WHERE `clientId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final HumanVerificationEntity entity) {
        if (entity.getClientId() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getClientId());
        }
        final String _tmp = __humanVerificationConverters.fromClientIdTypeToString(entity.getClientIdType());
        if (_tmp == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp);
        }
        final String _tmp_1 = __commonConverters.fromListOfStringToString(entity.getVerificationMethods());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        if (entity.getVerificationToken() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getVerificationToken());
        }
        final String _tmp_2 = __humanVerificationConverters.fromHumanVerificationStateToString(entity.getState());
        if (_tmp_2 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_2);
        }
        if (entity.getHumanHeaderTokenType() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getHumanHeaderTokenType());
        }
        if (entity.getHumanHeaderTokenCode() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getHumanHeaderTokenCode());
        }
        if (entity.getClientId() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getClientId());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM HumanVerificationEntity";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteByClientId = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM HumanVerificationEntity WHERE clientId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStateAndToken = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE HumanVerificationEntity SET state = ?, humanHeaderTokenType = ?, humanHeaderTokenCode = ? WHERE clientId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final HumanVerificationEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfHumanVerificationEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final HumanVerificationEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfHumanVerificationEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final HumanVerificationEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfHumanVerificationEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final HumanVerificationEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> HumanVerificationDetailsDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> HumanVerificationDetailsDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Object deleteByClientId(final String clientId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByClientId.acquire();
        int _argIndex = 1;
        if (clientId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, clientId);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteByClientId.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object updateStateAndToken(final String clientId,
      final HumanVerificationState humanVerificationState, final String tokenType,
      final String tokenCode, final Continuation<? super Unit> arg4) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStateAndToken.acquire();
        int _argIndex = 1;
        final String _tmp = __humanVerificationConverters.fromHumanVerificationStateToString(humanVerificationState);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (tokenType == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, tokenType);
        }
        _argIndex = 3;
        if (tokenCode == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, tokenCode);
        }
        _argIndex = 4;
        if (clientId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, clientId);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateStateAndToken.release(_stmt);
        }
      }
    }, arg4);
  }

  @Override
  public Flow<List<HumanVerificationEntity>> getAll() {
    final String _sql = "SELECT * FROM HumanVerificationEntity";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"HumanVerificationEntity"}, new Callable<List<HumanVerificationEntity>>() {
      @Override
      @NonNull
      public List<HumanVerificationEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClientId = CursorUtil.getColumnIndexOrThrow(_cursor, "clientId");
          final int _cursorIndexOfClientIdType = CursorUtil.getColumnIndexOrThrow(_cursor, "clientIdType");
          final int _cursorIndexOfVerificationMethods = CursorUtil.getColumnIndexOrThrow(_cursor, "verificationMethods");
          final int _cursorIndexOfVerificationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "verificationToken");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfHumanHeaderTokenType = CursorUtil.getColumnIndexOrThrow(_cursor, "humanHeaderTokenType");
          final int _cursorIndexOfHumanHeaderTokenCode = CursorUtil.getColumnIndexOrThrow(_cursor, "humanHeaderTokenCode");
          final List<HumanVerificationEntity> _result = new ArrayList<HumanVerificationEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final HumanVerificationEntity _item;
            final String _tmpClientId;
            if (_cursor.isNull(_cursorIndexOfClientId)) {
              _tmpClientId = null;
            } else {
              _tmpClientId = _cursor.getString(_cursorIndexOfClientId);
            }
            final ClientIdType _tmpClientIdType;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfClientIdType)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfClientIdType);
            }
            _tmpClientIdType = __humanVerificationConverters.fromStringToClientIdType(_tmp);
            final List<String> _tmpVerificationMethods;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfVerificationMethods)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfVerificationMethods);
            }
            _tmpVerificationMethods = __commonConverters.fromStringToListOfString(_tmp_1);
            final String _tmpVerificationToken;
            if (_cursor.isNull(_cursorIndexOfVerificationToken)) {
              _tmpVerificationToken = null;
            } else {
              _tmpVerificationToken = _cursor.getString(_cursorIndexOfVerificationToken);
            }
            final HumanVerificationState _tmpState;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfState);
            }
            _tmpState = __humanVerificationConverters.fromStringToHumanVerificationState(_tmp_2);
            final String _tmpHumanHeaderTokenType;
            if (_cursor.isNull(_cursorIndexOfHumanHeaderTokenType)) {
              _tmpHumanHeaderTokenType = null;
            } else {
              _tmpHumanHeaderTokenType = _cursor.getString(_cursorIndexOfHumanHeaderTokenType);
            }
            final String _tmpHumanHeaderTokenCode;
            if (_cursor.isNull(_cursorIndexOfHumanHeaderTokenCode)) {
              _tmpHumanHeaderTokenCode = null;
            } else {
              _tmpHumanHeaderTokenCode = _cursor.getString(_cursorIndexOfHumanHeaderTokenCode);
            }
            _item = new HumanVerificationEntity(_tmpClientId,_tmpClientIdType,_tmpVerificationMethods,_tmpVerificationToken,_tmpState,_tmpHumanHeaderTokenType,_tmpHumanHeaderTokenCode);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByClientId(final String clientId,
      final Continuation<? super HumanVerificationEntity> arg1) {
    final String _sql = "SELECT * FROM HumanVerificationEntity WHERE clientId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (clientId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, clientId);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<HumanVerificationEntity>() {
      @Override
      @Nullable
      public HumanVerificationEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClientId = CursorUtil.getColumnIndexOrThrow(_cursor, "clientId");
          final int _cursorIndexOfClientIdType = CursorUtil.getColumnIndexOrThrow(_cursor, "clientIdType");
          final int _cursorIndexOfVerificationMethods = CursorUtil.getColumnIndexOrThrow(_cursor, "verificationMethods");
          final int _cursorIndexOfVerificationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "verificationToken");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfHumanHeaderTokenType = CursorUtil.getColumnIndexOrThrow(_cursor, "humanHeaderTokenType");
          final int _cursorIndexOfHumanHeaderTokenCode = CursorUtil.getColumnIndexOrThrow(_cursor, "humanHeaderTokenCode");
          final HumanVerificationEntity _result;
          if (_cursor.moveToFirst()) {
            final String _tmpClientId;
            if (_cursor.isNull(_cursorIndexOfClientId)) {
              _tmpClientId = null;
            } else {
              _tmpClientId = _cursor.getString(_cursorIndexOfClientId);
            }
            final ClientIdType _tmpClientIdType;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfClientIdType)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfClientIdType);
            }
            _tmpClientIdType = __humanVerificationConverters.fromStringToClientIdType(_tmp);
            final List<String> _tmpVerificationMethods;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfVerificationMethods)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfVerificationMethods);
            }
            _tmpVerificationMethods = __commonConverters.fromStringToListOfString(_tmp_1);
            final String _tmpVerificationToken;
            if (_cursor.isNull(_cursorIndexOfVerificationToken)) {
              _tmpVerificationToken = null;
            } else {
              _tmpVerificationToken = _cursor.getString(_cursorIndexOfVerificationToken);
            }
            final HumanVerificationState _tmpState;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfState)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfState);
            }
            _tmpState = __humanVerificationConverters.fromStringToHumanVerificationState(_tmp_2);
            final String _tmpHumanHeaderTokenType;
            if (_cursor.isNull(_cursorIndexOfHumanHeaderTokenType)) {
              _tmpHumanHeaderTokenType = null;
            } else {
              _tmpHumanHeaderTokenType = _cursor.getString(_cursorIndexOfHumanHeaderTokenType);
            }
            final String _tmpHumanHeaderTokenCode;
            if (_cursor.isNull(_cursorIndexOfHumanHeaderTokenCode)) {
              _tmpHumanHeaderTokenCode = null;
            } else {
              _tmpHumanHeaderTokenCode = _cursor.getString(_cursorIndexOfHumanHeaderTokenCode);
            }
            _result = new HumanVerificationEntity(_tmpClientId,_tmpClientIdType,_tmpVerificationMethods,_tmpVerificationToken,_tmpState,_tmpHumanHeaderTokenType,_tmpHumanHeaderTokenCode);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
