package me.proton.core.key.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.RelationUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.key.data.entity.PublicAddressEntity;
import me.proton.core.key.data.entity.PublicAddressKeyEntity;
import me.proton.core.key.data.entity.PublicAddressWithKeys;
import me.proton.core.key.data.entity.SignedKeyListEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PublicAddressWithKeysDao_Impl extends PublicAddressWithKeysDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PublicAddressEntity> __insertionAdapterOfPublicAddressEntity;

  private final EntityDeletionOrUpdateAdapter<PublicAddressEntity> __deletionAdapterOfPublicAddressEntity;

  private final EntityDeletionOrUpdateAdapter<PublicAddressEntity> __updateAdapterOfPublicAddressEntity;

  public PublicAddressWithKeysDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPublicAddressEntity = new EntityInsertionAdapter<PublicAddressEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `PublicAddressEntity` (`email`,`recipientType`,`mimeType`,`ignoreKT`,`signedKeyList_data`,`signedKeyList_signature`,`signedKeyList_minEpochId`,`signedKeyList_maxEpochId`,`signedKeyList_expectedMinEpochId`) VALUES (?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
        statement.bindLong(2, entity.getRecipientType());
        if (entity.getMimeType() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getMimeType());
        }
        if (entity.getIgnoreKT() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getIgnoreKT());
        }
        final SignedKeyListEntity _tmpSignedKeyListEntity = entity.getSignedKeyListEntity();
        if (_tmpSignedKeyListEntity != null) {
          if (_tmpSignedKeyListEntity.getData() == null) {
            statement.bindNull(5);
          } else {
            statement.bindString(5, _tmpSignedKeyListEntity.getData());
          }
          if (_tmpSignedKeyListEntity.getSignature() == null) {
            statement.bindNull(6);
          } else {
            statement.bindString(6, _tmpSignedKeyListEntity.getSignature());
          }
          if (_tmpSignedKeyListEntity.getMinEpochId() == null) {
            statement.bindNull(7);
          } else {
            statement.bindLong(7, _tmpSignedKeyListEntity.getMinEpochId());
          }
          if (_tmpSignedKeyListEntity.getMaxEpochId() == null) {
            statement.bindNull(8);
          } else {
            statement.bindLong(8, _tmpSignedKeyListEntity.getMaxEpochId());
          }
          if (_tmpSignedKeyListEntity.getExpectedMinEpochId() == null) {
            statement.bindNull(9);
          } else {
            statement.bindLong(9, _tmpSignedKeyListEntity.getExpectedMinEpochId());
          }
        } else {
          statement.bindNull(5);
          statement.bindNull(6);
          statement.bindNull(7);
          statement.bindNull(8);
          statement.bindNull(9);
        }
      }
    };
    this.__deletionAdapterOfPublicAddressEntity = new EntityDeletionOrUpdateAdapter<PublicAddressEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `PublicAddressEntity` WHERE `email` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
      }
    };
    this.__updateAdapterOfPublicAddressEntity = new EntityDeletionOrUpdateAdapter<PublicAddressEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PublicAddressEntity` SET `email` = ?,`recipientType` = ?,`mimeType` = ?,`ignoreKT` = ?,`signedKeyList_data` = ?,`signedKeyList_signature` = ?,`signedKeyList_minEpochId` = ?,`signedKeyList_maxEpochId` = ?,`signedKeyList_expectedMinEpochId` = ? WHERE `email` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
        statement.bindLong(2, entity.getRecipientType());
        if (entity.getMimeType() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getMimeType());
        }
        if (entity.getIgnoreKT() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getIgnoreKT());
        }
        final SignedKeyListEntity _tmpSignedKeyListEntity = entity.getSignedKeyListEntity();
        if (_tmpSignedKeyListEntity != null) {
          if (_tmpSignedKeyListEntity.getData() == null) {
            statement.bindNull(5);
          } else {
            statement.bindString(5, _tmpSignedKeyListEntity.getData());
          }
          if (_tmpSignedKeyListEntity.getSignature() == null) {
            statement.bindNull(6);
          } else {
            statement.bindString(6, _tmpSignedKeyListEntity.getSignature());
          }
          if (_tmpSignedKeyListEntity.getMinEpochId() == null) {
            statement.bindNull(7);
          } else {
            statement.bindLong(7, _tmpSignedKeyListEntity.getMinEpochId());
          }
          if (_tmpSignedKeyListEntity.getMaxEpochId() == null) {
            statement.bindNull(8);
          } else {
            statement.bindLong(8, _tmpSignedKeyListEntity.getMaxEpochId());
          }
          if (_tmpSignedKeyListEntity.getExpectedMinEpochId() == null) {
            statement.bindNull(9);
          } else {
            statement.bindLong(9, _tmpSignedKeyListEntity.getExpectedMinEpochId());
          }
        } else {
          statement.bindNull(5);
          statement.bindNull(6);
          statement.bindNull(7);
          statement.bindNull(8);
          statement.bindNull(9);
        }
        if (entity.getEmail() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getEmail());
        }
      }
    };
  }

  @Override
  public Object insertOrIgnore(final PublicAddressEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPublicAddressEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final PublicAddressEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfPublicAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final PublicAddressEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfPublicAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final PublicAddressEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PublicAddressWithKeysDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PublicAddressWithKeysDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Flow<PublicAddressWithKeys> findWithKeysByEmail(final String email) {
    final String _sql = "SELECT * FROM PublicAddressEntity WHERE email = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (email == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, email);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[] {"PublicAddressKeyEntity",
        "PublicAddressEntity"}, new Callable<PublicAddressWithKeys>() {
      @Override
      @Nullable
      public PublicAddressWithKeys call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfRecipientType = CursorUtil.getColumnIndexOrThrow(_cursor, "recipientType");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
            final int _cursorIndexOfIgnoreKT = CursorUtil.getColumnIndexOrThrow(_cursor, "ignoreKT");
            final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
            final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
            final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
            final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
            final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
            final ArrayMap<String, ArrayList<PublicAddressKeyEntity>> _collectionKeys = new ArrayMap<String, ArrayList<PublicAddressKeyEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpKey = null;
              } else {
                _tmpKey = _cursor.getString(_cursorIndexOfEmail);
              }
              if (_tmpKey != null) {
                if (!_collectionKeys.containsKey(_tmpKey)) {
                  _collectionKeys.put(_tmpKey, new ArrayList<PublicAddressKeyEntity>());
                }
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipPublicAddressKeyEntityAsmeProtonCoreKeyDataEntityPublicAddressKeyEntity(_collectionKeys);
            final PublicAddressWithKeys _result;
            if (_cursor.moveToFirst()) {
              final PublicAddressEntity _tmpEntity;
              final String _tmpEmail;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpEmail = null;
              } else {
                _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
              }
              final int _tmpRecipientType;
              _tmpRecipientType = _cursor.getInt(_cursorIndexOfRecipientType);
              final String _tmpMimeType;
              if (_cursor.isNull(_cursorIndexOfMimeType)) {
                _tmpMimeType = null;
              } else {
                _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
              }
              final Integer _tmpIgnoreKT;
              if (_cursor.isNull(_cursorIndexOfIgnoreKT)) {
                _tmpIgnoreKT = null;
              } else {
                _tmpIgnoreKT = _cursor.getInt(_cursorIndexOfIgnoreKT);
              }
              final SignedKeyListEntity _tmpSignedKeyListEntity;
              if (!(_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
                final String _tmpData;
                if (_cursor.isNull(_cursorIndexOfData)) {
                  _tmpData = null;
                } else {
                  _tmpData = _cursor.getString(_cursorIndexOfData);
                }
                final String _tmpSignature;
                if (_cursor.isNull(_cursorIndexOfSignature)) {
                  _tmpSignature = null;
                } else {
                  _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
                }
                final Integer _tmpMinEpochId;
                if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                  _tmpMinEpochId = null;
                } else {
                  _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
                }
                final Integer _tmpMaxEpochId;
                if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                  _tmpMaxEpochId = null;
                } else {
                  _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
                }
                final Integer _tmpExpectedMinEpochId;
                if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                  _tmpExpectedMinEpochId = null;
                } else {
                  _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
                }
                _tmpSignedKeyListEntity = new SignedKeyListEntity(_tmpData,_tmpSignature,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
              } else {
                _tmpSignedKeyListEntity = null;
              }
              _tmpEntity = new PublicAddressEntity(_tmpEmail,_tmpRecipientType,_tmpMimeType,_tmpSignedKeyListEntity,_tmpIgnoreKT);
              final ArrayList<PublicAddressKeyEntity> _tmpKeysCollection;
              final String _tmpKey_1;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpKey_1 = null;
              } else {
                _tmpKey_1 = _cursor.getString(_cursorIndexOfEmail);
              }
              if (_tmpKey_1 != null) {
                _tmpKeysCollection = _collectionKeys.get(_tmpKey_1);
              } else {
                _tmpKeysCollection = new ArrayList<PublicAddressKeyEntity>();
              }
              _result = new PublicAddressWithKeys(_tmpEntity,_tmpKeysCollection);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getWithKeysByEmail(final String email,
      final Continuation<? super PublicAddressWithKeys> arg1) {
    final String _sql = "SELECT * FROM PublicAddressEntity WHERE email = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (email == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, email);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<PublicAddressWithKeys>() {
      @Override
      @Nullable
      public PublicAddressWithKeys call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfRecipientType = CursorUtil.getColumnIndexOrThrow(_cursor, "recipientType");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
            final int _cursorIndexOfIgnoreKT = CursorUtil.getColumnIndexOrThrow(_cursor, "ignoreKT");
            final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
            final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
            final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
            final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
            final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
            final ArrayMap<String, ArrayList<PublicAddressKeyEntity>> _collectionKeys = new ArrayMap<String, ArrayList<PublicAddressKeyEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpKey = null;
              } else {
                _tmpKey = _cursor.getString(_cursorIndexOfEmail);
              }
              if (_tmpKey != null) {
                if (!_collectionKeys.containsKey(_tmpKey)) {
                  _collectionKeys.put(_tmpKey, new ArrayList<PublicAddressKeyEntity>());
                }
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipPublicAddressKeyEntityAsmeProtonCoreKeyDataEntityPublicAddressKeyEntity(_collectionKeys);
            final PublicAddressWithKeys _result;
            if (_cursor.moveToFirst()) {
              final PublicAddressEntity _tmpEntity;
              final String _tmpEmail;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpEmail = null;
              } else {
                _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
              }
              final int _tmpRecipientType;
              _tmpRecipientType = _cursor.getInt(_cursorIndexOfRecipientType);
              final String _tmpMimeType;
              if (_cursor.isNull(_cursorIndexOfMimeType)) {
                _tmpMimeType = null;
              } else {
                _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
              }
              final Integer _tmpIgnoreKT;
              if (_cursor.isNull(_cursorIndexOfIgnoreKT)) {
                _tmpIgnoreKT = null;
              } else {
                _tmpIgnoreKT = _cursor.getInt(_cursorIndexOfIgnoreKT);
              }
              final SignedKeyListEntity _tmpSignedKeyListEntity;
              if (!(_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
                final String _tmpData;
                if (_cursor.isNull(_cursorIndexOfData)) {
                  _tmpData = null;
                } else {
                  _tmpData = _cursor.getString(_cursorIndexOfData);
                }
                final String _tmpSignature;
                if (_cursor.isNull(_cursorIndexOfSignature)) {
                  _tmpSignature = null;
                } else {
                  _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
                }
                final Integer _tmpMinEpochId;
                if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                  _tmpMinEpochId = null;
                } else {
                  _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
                }
                final Integer _tmpMaxEpochId;
                if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                  _tmpMaxEpochId = null;
                } else {
                  _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
                }
                final Integer _tmpExpectedMinEpochId;
                if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                  _tmpExpectedMinEpochId = null;
                } else {
                  _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
                }
                _tmpSignedKeyListEntity = new SignedKeyListEntity(_tmpData,_tmpSignature,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
              } else {
                _tmpSignedKeyListEntity = null;
              }
              _tmpEntity = new PublicAddressEntity(_tmpEmail,_tmpRecipientType,_tmpMimeType,_tmpSignedKeyListEntity,_tmpIgnoreKT);
              final ArrayList<PublicAddressKeyEntity> _tmpKeysCollection;
              final String _tmpKey_1;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpKey_1 = null;
              } else {
                _tmpKey_1 = _cursor.getString(_cursorIndexOfEmail);
              }
              if (_tmpKey_1 != null) {
                _tmpKeysCollection = _collectionKeys.get(_tmpKey_1);
              } else {
                _tmpKeysCollection = new ArrayList<PublicAddressKeyEntity>();
              }
              _result = new PublicAddressWithKeys(_tmpEntity,_tmpKeysCollection);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipPublicAddressKeyEntityAsmeProtonCoreKeyDataEntityPublicAddressKeyEntity(
      @NonNull final ArrayMap<String, ArrayList<PublicAddressKeyEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    if (_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      RelationUtil.recursiveFetchArrayMap(_map, true, (map) -> {
        __fetchRelationshipPublicAddressKeyEntityAsmeProtonCoreKeyDataEntityPublicAddressKeyEntity(map);
        return Unit.INSTANCE;
      });
      return;
    }
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `email`,`flags`,`publicKey`,`isPrimary` FROM `PublicAddressKeyEntity` WHERE `email` IN (");
    final int _inputSize = __mapKeySet == null ? 1 : __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    if (__mapKeySet == null) {
      _stmt.bindNull(_argIndex);
    } else {
      for (String _item : __mapKeySet) {
        if (_item == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _item);
        }
        _argIndex++;
      }
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "email");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfEmail = 0;
      final int _cursorIndexOfFlags = 1;
      final int _cursorIndexOfPublicKey = 2;
      final int _cursorIndexOfIsPrimary = 3;
      while (_cursor.moveToNext()) {
        final String _tmpKey;
        if (_cursor.isNull(_itemKeyIndex)) {
          _tmpKey = null;
        } else {
          _tmpKey = _cursor.getString(_itemKeyIndex);
        }
        if (_tmpKey != null) {
          final ArrayList<PublicAddressKeyEntity> _tmpRelation = _map.get(_tmpKey);
          if (_tmpRelation != null) {
            final PublicAddressKeyEntity _item_1;
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final int _tmpFlags;
            _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
            final String _tmpPublicKey;
            if (_cursor.isNull(_cursorIndexOfPublicKey)) {
              _tmpPublicKey = null;
            } else {
              _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
            }
            final boolean _tmpIsPrimary;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsPrimary);
            _tmpIsPrimary = _tmp != 0;
            _item_1 = new PublicAddressKeyEntity(_tmpEmail,_tmpFlags,_tmpPublicKey,_tmpIsPrimary);
            _tmpRelation.add(_item_1);
          }
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
