package me.proton.core.keytransparency.data.local;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.keytransparency.data.local.entity.AddressChangeEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AddressChangeDao_Impl extends AddressChangeDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AddressChangeEntity> __insertionAdapterOfAddressChangeEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<AddressChangeEntity> __deletionAdapterOfAddressChangeEntity;

  private final EntityDeletionOrUpdateAdapter<AddressChangeEntity> __updateAdapterOfAddressChangeEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAddressChange;

  public AddressChangeDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAddressChangeEntity = new EntityInsertionAdapter<AddressChangeEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `AddressChangeEntity` (`userId`,`changeId`,`counterEncrypted`,`emailEncrypted`,`epochIdEncrypted`,`creationTimestampEncrypted`,`publicKeysEncrypted`,`isObsolete`) VALUES (?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AddressChangeEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getChangeId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getChangeId());
        }
        if (entity.getCounterEncrypted() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCounterEncrypted());
        }
        if (entity.getEmailEncrypted() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getEmailEncrypted());
        }
        if (entity.getEpochIdEncrypted() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getEpochIdEncrypted());
        }
        if (entity.getCreationTimestampEncrypted() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCreationTimestampEncrypted());
        }
        final String _tmp_1 = __commonConverters.fromListOfStringToString(entity.getPublicKeysEncrypted());
        if (_tmp_1 == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, _tmp_1);
        }
        if (entity.isObsolete() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.isObsolete());
        }
      }
    };
    this.__deletionAdapterOfAddressChangeEntity = new EntityDeletionOrUpdateAdapter<AddressChangeEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `AddressChangeEntity` WHERE `userId` = ? AND `changeId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AddressChangeEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getChangeId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getChangeId());
        }
      }
    };
    this.__updateAdapterOfAddressChangeEntity = new EntityDeletionOrUpdateAdapter<AddressChangeEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `AddressChangeEntity` SET `userId` = ?,`changeId` = ?,`counterEncrypted` = ?,`emailEncrypted` = ?,`epochIdEncrypted` = ?,`creationTimestampEncrypted` = ?,`publicKeysEncrypted` = ?,`isObsolete` = ? WHERE `userId` = ? AND `changeId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AddressChangeEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getChangeId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getChangeId());
        }
        if (entity.getCounterEncrypted() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCounterEncrypted());
        }
        if (entity.getEmailEncrypted() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getEmailEncrypted());
        }
        if (entity.getEpochIdEncrypted() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getEpochIdEncrypted());
        }
        if (entity.getCreationTimestampEncrypted() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCreationTimestampEncrypted());
        }
        final String _tmp_1 = __commonConverters.fromListOfStringToString(entity.getPublicKeysEncrypted());
        if (_tmp_1 == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, _tmp_1);
        }
        if (entity.isObsolete() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.isObsolete());
        }
        final String _tmp_2 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_2 == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, _tmp_2);
        }
        if (entity.getChangeId() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getChangeId());
        }
      }
    };
    this.__preparedStmtOfDeleteAddressChange = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM AddressChangeEntity \n"
                + "        WHERE userId = ? AND changeId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final AddressChangeEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfAddressChangeEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final AddressChangeEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfAddressChangeEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final AddressChangeEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfAddressChangeEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final AddressChangeEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AddressChangeDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AddressChangeDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteAddressChange(final UserId userId, final String changeId,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAddressChange.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (changeId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, changeId);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAddressChange.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Object getAddressChanges(final UserId userId,
      final Continuation<? super List<AddressChangeEntity>> arg1) {
    final String _sql = "SELECT * FROM AddressChangeEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<AddressChangeEntity>>() {
      @Override
      @NonNull
      public List<AddressChangeEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfChangeId = CursorUtil.getColumnIndexOrThrow(_cursor, "changeId");
          final int _cursorIndexOfCounterEncrypted = CursorUtil.getColumnIndexOrThrow(_cursor, "counterEncrypted");
          final int _cursorIndexOfEmailEncrypted = CursorUtil.getColumnIndexOrThrow(_cursor, "emailEncrypted");
          final int _cursorIndexOfEpochIdEncrypted = CursorUtil.getColumnIndexOrThrow(_cursor, "epochIdEncrypted");
          final int _cursorIndexOfCreationTimestampEncrypted = CursorUtil.getColumnIndexOrThrow(_cursor, "creationTimestampEncrypted");
          final int _cursorIndexOfPublicKeysEncrypted = CursorUtil.getColumnIndexOrThrow(_cursor, "publicKeysEncrypted");
          final int _cursorIndexOfIsObsolete = CursorUtil.getColumnIndexOrThrow(_cursor, "isObsolete");
          final List<AddressChangeEntity> _result = new ArrayList<AddressChangeEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AddressChangeEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpChangeId;
            if (_cursor.isNull(_cursorIndexOfChangeId)) {
              _tmpChangeId = null;
            } else {
              _tmpChangeId = _cursor.getString(_cursorIndexOfChangeId);
            }
            final String _tmpCounterEncrypted;
            if (_cursor.isNull(_cursorIndexOfCounterEncrypted)) {
              _tmpCounterEncrypted = null;
            } else {
              _tmpCounterEncrypted = _cursor.getString(_cursorIndexOfCounterEncrypted);
            }
            final String _tmpEmailEncrypted;
            if (_cursor.isNull(_cursorIndexOfEmailEncrypted)) {
              _tmpEmailEncrypted = null;
            } else {
              _tmpEmailEncrypted = _cursor.getString(_cursorIndexOfEmailEncrypted);
            }
            final String _tmpEpochIdEncrypted;
            if (_cursor.isNull(_cursorIndexOfEpochIdEncrypted)) {
              _tmpEpochIdEncrypted = null;
            } else {
              _tmpEpochIdEncrypted = _cursor.getString(_cursorIndexOfEpochIdEncrypted);
            }
            final String _tmpCreationTimestampEncrypted;
            if (_cursor.isNull(_cursorIndexOfCreationTimestampEncrypted)) {
              _tmpCreationTimestampEncrypted = null;
            } else {
              _tmpCreationTimestampEncrypted = _cursor.getString(_cursorIndexOfCreationTimestampEncrypted);
            }
            final List<String> _tmpPublicKeysEncrypted;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfPublicKeysEncrypted)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfPublicKeysEncrypted);
            }
            _tmpPublicKeysEncrypted = __commonConverters.fromStringToListOfString(_tmp_2);
            final String _tmpIsObsolete;
            if (_cursor.isNull(_cursorIndexOfIsObsolete)) {
              _tmpIsObsolete = null;
            } else {
              _tmpIsObsolete = _cursor.getString(_cursorIndexOfIsObsolete);
            }
            _item = new AddressChangeEntity(_tmpUserId,_tmpChangeId,_tmpCounterEncrypted,_tmpEmailEncrypted,_tmpEpochIdEncrypted,_tmpCreationTimestampEncrypted,_tmpPublicKeysEncrypted,_tmpIsObsolete);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
