package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.entity.UserKeyEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class UserKeyDao_Impl extends UserKeyDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<UserKeyEntity> __insertionAdapterOfUserKeyEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final UserConverters __userConverters = new UserConverters();

  private final EntityDeletionOrUpdateAdapter<UserKeyEntity> __deletionAdapterOfUserKeyEntity;

  private final EntityDeletionOrUpdateAdapter<UserKeyEntity> __updateAdapterOfUserKeyEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllByUserId;

  public UserKeyDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfUserKeyEntity = new EntityInsertionAdapter<UserKeyEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `UserKeyEntity` (`userId`,`keyId`,`version`,`privateKey`,`isPrimary`,`isUnlockable`,`fingerprint`,`activation`,`active`,`recoverySecretHash`,`recoverySecretSignature`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final UserKeyEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        statement.bindLong(3, entity.getVersion());
        if (entity.getPrivateKey() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPrivateKey());
        }
        final int _tmp_2 = entity.isPrimary() ? 1 : 0;
        statement.bindLong(5, _tmp_2);
        final int _tmp_3 = entity.isUnlockable() ? 1 : 0;
        statement.bindLong(6, _tmp_3);
        if (entity.getFingerprint() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getFingerprint());
        }
        if (entity.getActivation() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getActivation());
        }
        final Integer _tmp_4 = entity.getActive() == null ? null : (entity.getActive() ? 1 : 0);
        if (_tmp_4 == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, _tmp_4);
        }
        if (entity.getRecoverySecretHash() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getRecoverySecretHash());
        }
        if (entity.getRecoverySecretSignature() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getRecoverySecretSignature());
        }
      }
    };
    this.__deletionAdapterOfUserKeyEntity = new EntityDeletionOrUpdateAdapter<UserKeyEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `UserKeyEntity` WHERE `keyId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final UserKeyEntity entity) {
        final String _tmp = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfUserKeyEntity = new EntityDeletionOrUpdateAdapter<UserKeyEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `UserKeyEntity` SET `userId` = ?,`keyId` = ?,`version` = ?,`privateKey` = ?,`isPrimary` = ?,`isUnlockable` = ?,`fingerprint` = ?,`activation` = ?,`active` = ?,`recoverySecretHash` = ?,`recoverySecretSignature` = ? WHERE `keyId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final UserKeyEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        statement.bindLong(3, entity.getVersion());
        if (entity.getPrivateKey() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPrivateKey());
        }
        final int _tmp_2 = entity.isPrimary() ? 1 : 0;
        statement.bindLong(5, _tmp_2);
        final int _tmp_3 = entity.isUnlockable() ? 1 : 0;
        statement.bindLong(6, _tmp_3);
        if (entity.getFingerprint() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getFingerprint());
        }
        if (entity.getActivation() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getActivation());
        }
        final Integer _tmp_4 = entity.getActive() == null ? null : (entity.getActive() ? 1 : 0);
        if (_tmp_4 == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, _tmp_4);
        }
        if (entity.getRecoverySecretHash() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getRecoverySecretHash());
        }
        if (entity.getRecoverySecretSignature() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getRecoverySecretSignature());
        }
        final String _tmp_5 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_5 == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, _tmp_5);
        }
      }
    };
    this.__preparedStmtOfDeleteAllByUserId = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM UserKeyEntity WHERE userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final UserKeyEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfUserKeyEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final UserKeyEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfUserKeyEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final UserKeyEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfUserKeyEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final UserKeyEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> UserKeyDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> UserKeyDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteAllByUserId(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllByUserId.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAllByUserId.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Flow<List<UserKeyEntity>> observeAllByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM UserKeyEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"UserKeyEntity"}, new Callable<List<UserKeyEntity>>() {
      @Override
      @NonNull
      public List<UserKeyEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow(_cursor, "keyId");
          final int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "version");
          final int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow(_cursor, "privateKey");
          final int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow(_cursor, "isPrimary");
          final int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow(_cursor, "isUnlockable");
          final int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow(_cursor, "fingerprint");
          final int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow(_cursor, "activation");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfRecoverySecretHash = CursorUtil.getColumnIndexOrThrow(_cursor, "recoverySecretHash");
          final int _cursorIndexOfRecoverySecretSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "recoverySecretSignature");
          final List<UserKeyEntity> _result = new ArrayList<UserKeyEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UserKeyEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final KeyId _tmpKeyId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfKeyId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfKeyId);
            }
            _tmpKeyId = __userConverters.fromStringToKeyId(_tmp_2);
            final int _tmpVersion;
            _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
            final String _tmpPrivateKey;
            if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
              _tmpPrivateKey = null;
            } else {
              _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
            }
            final boolean _tmpIsPrimary;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
            _tmpIsPrimary = _tmp_3 != 0;
            final boolean _tmpIsUnlockable;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
            _tmpIsUnlockable = _tmp_4 != 0;
            final String _tmpFingerprint;
            if (_cursor.isNull(_cursorIndexOfFingerprint)) {
              _tmpFingerprint = null;
            } else {
              _tmpFingerprint = _cursor.getString(_cursorIndexOfFingerprint);
            }
            final String _tmpActivation;
            if (_cursor.isNull(_cursorIndexOfActivation)) {
              _tmpActivation = null;
            } else {
              _tmpActivation = _cursor.getString(_cursorIndexOfActivation);
            }
            final Boolean _tmpActive;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfActive)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfActive);
            }
            _tmpActive = _tmp_5 == null ? null : _tmp_5 != 0;
            final String _tmpRecoverySecretHash;
            if (_cursor.isNull(_cursorIndexOfRecoverySecretHash)) {
              _tmpRecoverySecretHash = null;
            } else {
              _tmpRecoverySecretHash = _cursor.getString(_cursorIndexOfRecoverySecretHash);
            }
            final String _tmpRecoverySecretSignature;
            if (_cursor.isNull(_cursorIndexOfRecoverySecretSignature)) {
              _tmpRecoverySecretSignature = null;
            } else {
              _tmpRecoverySecretSignature = _cursor.getString(_cursorIndexOfRecoverySecretSignature);
            }
            _item = new UserKeyEntity(_tmpUserId,_tmpKeyId,_tmpVersion,_tmpPrivateKey,_tmpIsPrimary,_tmpIsUnlockable,_tmpFingerprint,_tmpActivation,_tmpActive,_tmpRecoverySecretHash,_tmpRecoverySecretSignature);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAllByUserId(final UserId userId,
      final Continuation<? super List<UserKeyEntity>> arg1) {
    final String _sql = "SELECT * FROM UserKeyEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UserKeyEntity>>() {
      @Override
      @NonNull
      public List<UserKeyEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow(_cursor, "keyId");
          final int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "version");
          final int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow(_cursor, "privateKey");
          final int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow(_cursor, "isPrimary");
          final int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow(_cursor, "isUnlockable");
          final int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow(_cursor, "fingerprint");
          final int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow(_cursor, "activation");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfRecoverySecretHash = CursorUtil.getColumnIndexOrThrow(_cursor, "recoverySecretHash");
          final int _cursorIndexOfRecoverySecretSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "recoverySecretSignature");
          final List<UserKeyEntity> _result = new ArrayList<UserKeyEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UserKeyEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final KeyId _tmpKeyId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfKeyId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfKeyId);
            }
            _tmpKeyId = __userConverters.fromStringToKeyId(_tmp_2);
            final int _tmpVersion;
            _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
            final String _tmpPrivateKey;
            if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
              _tmpPrivateKey = null;
            } else {
              _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
            }
            final boolean _tmpIsPrimary;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
            _tmpIsPrimary = _tmp_3 != 0;
            final boolean _tmpIsUnlockable;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
            _tmpIsUnlockable = _tmp_4 != 0;
            final String _tmpFingerprint;
            if (_cursor.isNull(_cursorIndexOfFingerprint)) {
              _tmpFingerprint = null;
            } else {
              _tmpFingerprint = _cursor.getString(_cursorIndexOfFingerprint);
            }
            final String _tmpActivation;
            if (_cursor.isNull(_cursorIndexOfActivation)) {
              _tmpActivation = null;
            } else {
              _tmpActivation = _cursor.getString(_cursorIndexOfActivation);
            }
            final Boolean _tmpActive;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfActive)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfActive);
            }
            _tmpActive = _tmp_5 == null ? null : _tmp_5 != 0;
            final String _tmpRecoverySecretHash;
            if (_cursor.isNull(_cursorIndexOfRecoverySecretHash)) {
              _tmpRecoverySecretHash = null;
            } else {
              _tmpRecoverySecretHash = _cursor.getString(_cursorIndexOfRecoverySecretHash);
            }
            final String _tmpRecoverySecretSignature;
            if (_cursor.isNull(_cursorIndexOfRecoverySecretSignature)) {
              _tmpRecoverySecretSignature = null;
            } else {
              _tmpRecoverySecretSignature = _cursor.getString(_cursorIndexOfRecoverySecretSignature);
            }
            _item = new UserKeyEntity(_tmpUserId,_tmpKeyId,_tmpVersion,_tmpPrivateKey,_tmpIsPrimary,_tmpIsUnlockable,_tmpFingerprint,_tmpActivation,_tmpActive,_tmpRecoverySecretHash,_tmpRecoverySecretSignature);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
