package me.proton.core.auth.data.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.auth.data.db.AuthConverters;
import me.proton.core.auth.data.entity.AuthDeviceEntity;
import me.proton.core.auth.domain.entity.AuthDeviceId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.domain.entity.AddressId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AuthDeviceDao_Impl extends AuthDeviceDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AuthDeviceEntity> __insertionAdapterOfAuthDeviceEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final UserConverters __userConverters = new UserConverters();

  private final EntityDeletionOrUpdateAdapter<AuthDeviceEntity> __deletionAdapterOfAuthDeviceEntity;

  private final EntityDeletionOrUpdateAdapter<AuthDeviceEntity> __updateAdapterOfAuthDeviceEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final AuthConverters __authConverters = new AuthConverters();

  public AuthDeviceDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAuthDeviceEntity = new EntityInsertionAdapter<AuthDeviceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `AuthDeviceEntity` (`userId`,`deviceId`,`addressId`,`state`,`name`,`localizedClientName`,`platform`,`createdAtUtcSeconds`,`activatedAtUtcSeconds`,`rejectedAtUtcSeconds`,`activationToken`,`lastActivityAtUtcSeconds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AuthDeviceEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDeviceId());
        }
        final String _tmp_1 = __userConverters.fromAddressIdToString(entity.getAddressId());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        statement.bindLong(4, entity.getState());
        if (entity.getName() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getName());
        }
        if (entity.getLocalizedClientName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getLocalizedClientName());
        }
        if (entity.getPlatform() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getPlatform());
        }
        statement.bindLong(8, entity.getCreatedAtUtcSeconds());
        if (entity.getActivatedAtUtcSeconds() == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, entity.getActivatedAtUtcSeconds());
        }
        if (entity.getRejectedAtUtcSeconds() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getRejectedAtUtcSeconds());
        }
        if (entity.getActivationToken() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getActivationToken());
        }
        statement.bindLong(12, entity.getLastActivityAtUtcSeconds());
      }
    };
    this.__deletionAdapterOfAuthDeviceEntity = new EntityDeletionOrUpdateAdapter<AuthDeviceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `AuthDeviceEntity` WHERE `userId` = ? AND `deviceId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AuthDeviceEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDeviceId());
        }
      }
    };
    this.__updateAdapterOfAuthDeviceEntity = new EntityDeletionOrUpdateAdapter<AuthDeviceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `AuthDeviceEntity` SET `userId` = ?,`deviceId` = ?,`addressId` = ?,`state` = ?,`name` = ?,`localizedClientName` = ?,`platform` = ?,`createdAtUtcSeconds` = ?,`activatedAtUtcSeconds` = ?,`rejectedAtUtcSeconds` = ?,`activationToken` = ?,`lastActivityAtUtcSeconds` = ? WHERE `userId` = ? AND `deviceId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AuthDeviceEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDeviceId());
        }
        final String _tmp_1 = __userConverters.fromAddressIdToString(entity.getAddressId());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        statement.bindLong(4, entity.getState());
        if (entity.getName() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getName());
        }
        if (entity.getLocalizedClientName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getLocalizedClientName());
        }
        if (entity.getPlatform() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getPlatform());
        }
        statement.bindLong(8, entity.getCreatedAtUtcSeconds());
        if (entity.getActivatedAtUtcSeconds() == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, entity.getActivatedAtUtcSeconds());
        }
        if (entity.getRejectedAtUtcSeconds() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getRejectedAtUtcSeconds());
        }
        if (entity.getActivationToken() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getActivationToken());
        }
        statement.bindLong(12, entity.getLastActivityAtUtcSeconds());
        final String _tmp_2 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_2 == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, _tmp_2);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getDeviceId());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM AuthDeviceEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final AuthDeviceEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfAuthDeviceEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final AuthDeviceEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfAuthDeviceEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final AuthDeviceEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfAuthDeviceEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final AuthDeviceEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AuthDeviceDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AuthDeviceDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<List<AuthDeviceEntity>> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM AuthDeviceEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"AuthDeviceEntity"}, new Callable<List<AuthDeviceEntity>>() {
      @Override
      @NonNull
      public List<AuthDeviceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
          final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
          final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
          final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
          final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
          final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
          final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
          final List<AuthDeviceEntity> _result = new ArrayList<AuthDeviceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AuthDeviceEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpDeviceId;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmpDeviceId = null;
            } else {
              _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
            }
            final AddressId _tmpAddressId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
            final int _tmpState;
            _tmpState = _cursor.getInt(_cursorIndexOfState);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpLocalizedClientName;
            if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
              _tmpLocalizedClientName = null;
            } else {
              _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
            }
            final String _tmpPlatform;
            if (_cursor.isNull(_cursorIndexOfPlatform)) {
              _tmpPlatform = null;
            } else {
              _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
            }
            final long _tmpCreatedAtUtcSeconds;
            _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
            final Long _tmpActivatedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
              _tmpActivatedAtUtcSeconds = null;
            } else {
              _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
            }
            final Long _tmpRejectedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
              _tmpRejectedAtUtcSeconds = null;
            } else {
              _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
            }
            final String _tmpActivationToken;
            if (_cursor.isNull(_cursorIndexOfActivationToken)) {
              _tmpActivationToken = null;
            } else {
              _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
            }
            final long _tmpLastActivityAtUtcSeconds;
            _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
            _item = new AuthDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super List<AuthDeviceEntity>> arg1) {
    final String _sql = "SELECT * FROM AuthDeviceEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<AuthDeviceEntity>>() {
      @Override
      @NonNull
      public List<AuthDeviceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
          final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
          final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
          final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
          final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
          final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
          final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
          final List<AuthDeviceEntity> _result = new ArrayList<AuthDeviceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AuthDeviceEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpDeviceId;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmpDeviceId = null;
            } else {
              _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
            }
            final AddressId _tmpAddressId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
            final int _tmpState;
            _tmpState = _cursor.getInt(_cursorIndexOfState);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpLocalizedClientName;
            if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
              _tmpLocalizedClientName = null;
            } else {
              _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
            }
            final String _tmpPlatform;
            if (_cursor.isNull(_cursorIndexOfPlatform)) {
              _tmpPlatform = null;
            } else {
              _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
            }
            final long _tmpCreatedAtUtcSeconds;
            _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
            final Long _tmpActivatedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
              _tmpActivatedAtUtcSeconds = null;
            } else {
              _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
            }
            final Long _tmpRejectedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
              _tmpRejectedAtUtcSeconds = null;
            } else {
              _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
            }
            final String _tmpActivationToken;
            if (_cursor.isNull(_cursorIndexOfActivationToken)) {
              _tmpActivationToken = null;
            } else {
              _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
            }
            final long _tmpLastActivityAtUtcSeconds;
            _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
            _item = new AuthDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getByAddressId(final AddressId addressId,
      final Continuation<? super List<AuthDeviceEntity>> arg1) {
    final String _sql = "SELECT * FROM AuthDeviceEntity WHERE addressId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __userConverters.fromAddressIdToString(addressId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<AuthDeviceEntity>>() {
      @Override
      @NonNull
      public List<AuthDeviceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
          final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
          final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
          final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
          final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
          final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
          final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
          final List<AuthDeviceEntity> _result = new ArrayList<AuthDeviceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AuthDeviceEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpDeviceId;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmpDeviceId = null;
            } else {
              _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
            }
            final AddressId _tmpAddressId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
            final int _tmpState;
            _tmpState = _cursor.getInt(_cursorIndexOfState);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpLocalizedClientName;
            if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
              _tmpLocalizedClientName = null;
            } else {
              _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
            }
            final String _tmpPlatform;
            if (_cursor.isNull(_cursorIndexOfPlatform)) {
              _tmpPlatform = null;
            } else {
              _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
            }
            final long _tmpCreatedAtUtcSeconds;
            _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
            final Long _tmpActivatedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
              _tmpActivatedAtUtcSeconds = null;
            } else {
              _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
            }
            final Long _tmpRejectedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
              _tmpRejectedAtUtcSeconds = null;
            } else {
              _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
            }
            final String _tmpActivationToken;
            if (_cursor.isNull(_cursorIndexOfActivationToken)) {
              _tmpActivationToken = null;
            } else {
              _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
            }
            final long _tmpLastActivityAtUtcSeconds;
            _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
            _item = new AuthDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  protected Object deleteAllBatch(final List<UserId> userIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM AuthDeviceEntity WHERE userId IN (");
        final int _inputSize = userIds.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (UserId _item : userIds) {
          final String _tmp = __commonConverters.fromUserIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  protected Object deleteByDeviceIdBatch(final List<AuthDeviceId> deviceId,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM AuthDeviceEntity WHERE deviceId IN (");
        final int _inputSize = deviceId.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (AuthDeviceId _item : deviceId) {
          final String _tmp = __authConverters.fromAuthDeviceIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
