package me.proton.core.auth.data.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.auth.data.db.AuthConverters;
import me.proton.core.auth.data.entity.MemberDeviceEntity;
import me.proton.core.auth.domain.entity.MemberDeviceId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.domain.entity.AddressId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MemberDeviceDao_Impl extends MemberDeviceDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<MemberDeviceEntity> __insertionAdapterOfMemberDeviceEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final UserConverters __userConverters = new UserConverters();

  private final EntityDeletionOrUpdateAdapter<MemberDeviceEntity> __deletionAdapterOfMemberDeviceEntity;

  private final EntityDeletionOrUpdateAdapter<MemberDeviceEntity> __updateAdapterOfMemberDeviceEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll_1;

  private final AuthConverters __authConverters = new AuthConverters();

  public MemberDeviceDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfMemberDeviceEntity = new EntityInsertionAdapter<MemberDeviceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `MemberDeviceEntity` (`userId`,`deviceId`,`memberId`,`addressId`,`state`,`name`,`localizedClientName`,`platform`,`createdAtUtcSeconds`,`activatedAtUtcSeconds`,`rejectedAtUtcSeconds`,`activationToken`,`lastActivityAtUtcSeconds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final MemberDeviceEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDeviceId());
        }
        final String _tmp_1 = __commonConverters.fromUserIdToString(entity.getMemberId());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        final String _tmp_2 = __userConverters.fromAddressIdToString(entity.getAddressId());
        if (_tmp_2 == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, _tmp_2);
        }
        statement.bindLong(5, entity.getState());
        if (entity.getName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getName());
        }
        if (entity.getLocalizedClientName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getLocalizedClientName());
        }
        if (entity.getPlatform() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getPlatform());
        }
        statement.bindLong(9, entity.getCreatedAtUtcSeconds());
        if (entity.getActivatedAtUtcSeconds() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getActivatedAtUtcSeconds());
        }
        if (entity.getRejectedAtUtcSeconds() == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, entity.getRejectedAtUtcSeconds());
        }
        if (entity.getActivationToken() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getActivationToken());
        }
        statement.bindLong(13, entity.getLastActivityAtUtcSeconds());
      }
    };
    this.__deletionAdapterOfMemberDeviceEntity = new EntityDeletionOrUpdateAdapter<MemberDeviceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `MemberDeviceEntity` WHERE `userId` = ? AND `deviceId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final MemberDeviceEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDeviceId());
        }
      }
    };
    this.__updateAdapterOfMemberDeviceEntity = new EntityDeletionOrUpdateAdapter<MemberDeviceEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `MemberDeviceEntity` SET `userId` = ?,`deviceId` = ?,`memberId` = ?,`addressId` = ?,`state` = ?,`name` = ?,`localizedClientName` = ?,`platform` = ?,`createdAtUtcSeconds` = ?,`activatedAtUtcSeconds` = ?,`rejectedAtUtcSeconds` = ?,`activationToken` = ?,`lastActivityAtUtcSeconds` = ? WHERE `userId` = ? AND `deviceId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final MemberDeviceEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDeviceId());
        }
        final String _tmp_1 = __commonConverters.fromUserIdToString(entity.getMemberId());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        final String _tmp_2 = __userConverters.fromAddressIdToString(entity.getAddressId());
        if (_tmp_2 == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, _tmp_2);
        }
        statement.bindLong(5, entity.getState());
        if (entity.getName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getName());
        }
        if (entity.getLocalizedClientName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getLocalizedClientName());
        }
        if (entity.getPlatform() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getPlatform());
        }
        statement.bindLong(9, entity.getCreatedAtUtcSeconds());
        if (entity.getActivatedAtUtcSeconds() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getActivatedAtUtcSeconds());
        }
        if (entity.getRejectedAtUtcSeconds() == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, entity.getRejectedAtUtcSeconds());
        }
        if (entity.getActivationToken() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getActivationToken());
        }
        statement.bindLong(13, entity.getLastActivityAtUtcSeconds());
        final String _tmp_3 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_3 == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, _tmp_3);
        }
        if (entity.getDeviceId() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getDeviceId());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM MemberDeviceEntity";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll_1 = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM MemberDeviceEntity WHERE userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final MemberDeviceEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfMemberDeviceEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final MemberDeviceEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfMemberDeviceEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final MemberDeviceEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfMemberDeviceEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final MemberDeviceEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MemberDeviceDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MemberDeviceDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Object deleteAll(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll_1.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll_1.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public List<MemberDeviceEntity> getByDeviceId(final UserId userId,
      final MemberDeviceId deviceId) {
    final String _sql = "SELECT * FROM MemberDeviceEntity WHERE userId = ? AND deviceId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __authConverters.fromMemberDeviceIdToString(deviceId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
      final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
      final int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow(_cursor, "memberId");
      final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
      final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
      final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
      final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
      final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
      final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
      final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
      final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
      final List<MemberDeviceEntity> _result = new ArrayList<MemberDeviceEntity>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final MemberDeviceEntity _item;
        final UserId _tmpUserId;
        final String _tmp_2;
        if (_cursor.isNull(_cursorIndexOfUserId)) {
          _tmp_2 = null;
        } else {
          _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
        }
        _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
        final String _tmpDeviceId;
        if (_cursor.isNull(_cursorIndexOfDeviceId)) {
          _tmpDeviceId = null;
        } else {
          _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
        }
        final UserId _tmpMemberId;
        final String _tmp_3;
        if (_cursor.isNull(_cursorIndexOfMemberId)) {
          _tmp_3 = null;
        } else {
          _tmp_3 = _cursor.getString(_cursorIndexOfMemberId);
        }
        _tmpMemberId = __commonConverters.fromStringToUserId(_tmp_3);
        final AddressId _tmpAddressId;
        final String _tmp_4;
        if (_cursor.isNull(_cursorIndexOfAddressId)) {
          _tmp_4 = null;
        } else {
          _tmp_4 = _cursor.getString(_cursorIndexOfAddressId);
        }
        _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_4);
        final int _tmpState;
        _tmpState = _cursor.getInt(_cursorIndexOfState);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpLocalizedClientName;
        if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
          _tmpLocalizedClientName = null;
        } else {
          _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
        }
        final String _tmpPlatform;
        if (_cursor.isNull(_cursorIndexOfPlatform)) {
          _tmpPlatform = null;
        } else {
          _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
        }
        final long _tmpCreatedAtUtcSeconds;
        _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
        final Long _tmpActivatedAtUtcSeconds;
        if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
          _tmpActivatedAtUtcSeconds = null;
        } else {
          _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
        }
        final Long _tmpRejectedAtUtcSeconds;
        if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
          _tmpRejectedAtUtcSeconds = null;
        } else {
          _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
        }
        final String _tmpActivationToken;
        if (_cursor.isNull(_cursorIndexOfActivationToken)) {
          _tmpActivationToken = null;
        } else {
          _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
        }
        final long _tmpLastActivityAtUtcSeconds;
        _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
        _item = new MemberDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpMemberId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<MemberDeviceEntity> getByMemberId(final UserId userId, final UserId memberId) {
    final String _sql = "SELECT * FROM MemberDeviceEntity WHERE userId = ? AND memberId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(memberId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
      final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
      final int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow(_cursor, "memberId");
      final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
      final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
      final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
      final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
      final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
      final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
      final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
      final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
      final List<MemberDeviceEntity> _result = new ArrayList<MemberDeviceEntity>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final MemberDeviceEntity _item;
        final UserId _tmpUserId;
        final String _tmp_2;
        if (_cursor.isNull(_cursorIndexOfUserId)) {
          _tmp_2 = null;
        } else {
          _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
        }
        _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
        final String _tmpDeviceId;
        if (_cursor.isNull(_cursorIndexOfDeviceId)) {
          _tmpDeviceId = null;
        } else {
          _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
        }
        final UserId _tmpMemberId;
        final String _tmp_3;
        if (_cursor.isNull(_cursorIndexOfMemberId)) {
          _tmp_3 = null;
        } else {
          _tmp_3 = _cursor.getString(_cursorIndexOfMemberId);
        }
        _tmpMemberId = __commonConverters.fromStringToUserId(_tmp_3);
        final AddressId _tmpAddressId;
        final String _tmp_4;
        if (_cursor.isNull(_cursorIndexOfAddressId)) {
          _tmp_4 = null;
        } else {
          _tmp_4 = _cursor.getString(_cursorIndexOfAddressId);
        }
        _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_4);
        final int _tmpState;
        _tmpState = _cursor.getInt(_cursorIndexOfState);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpLocalizedClientName;
        if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
          _tmpLocalizedClientName = null;
        } else {
          _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
        }
        final String _tmpPlatform;
        if (_cursor.isNull(_cursorIndexOfPlatform)) {
          _tmpPlatform = null;
        } else {
          _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
        }
        final long _tmpCreatedAtUtcSeconds;
        _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
        final Long _tmpActivatedAtUtcSeconds;
        if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
          _tmpActivatedAtUtcSeconds = null;
        } else {
          _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
        }
        final Long _tmpRejectedAtUtcSeconds;
        if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
          _tmpRejectedAtUtcSeconds = null;
        } else {
          _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
        }
        final String _tmpActivationToken;
        if (_cursor.isNull(_cursorIndexOfActivationToken)) {
          _tmpActivationToken = null;
        } else {
          _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
        }
        final long _tmpLastActivityAtUtcSeconds;
        _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
        _item = new MemberDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpMemberId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<MemberDeviceEntity> getByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM MemberDeviceEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
      final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
      final int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow(_cursor, "memberId");
      final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
      final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
      final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
      final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
      final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
      final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
      final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
      final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
      final List<MemberDeviceEntity> _result = new ArrayList<MemberDeviceEntity>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final MemberDeviceEntity _item;
        final UserId _tmpUserId;
        final String _tmp_1;
        if (_cursor.isNull(_cursorIndexOfUserId)) {
          _tmp_1 = null;
        } else {
          _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
        }
        _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
        final String _tmpDeviceId;
        if (_cursor.isNull(_cursorIndexOfDeviceId)) {
          _tmpDeviceId = null;
        } else {
          _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
        }
        final UserId _tmpMemberId;
        final String _tmp_2;
        if (_cursor.isNull(_cursorIndexOfMemberId)) {
          _tmp_2 = null;
        } else {
          _tmp_2 = _cursor.getString(_cursorIndexOfMemberId);
        }
        _tmpMemberId = __commonConverters.fromStringToUserId(_tmp_2);
        final AddressId _tmpAddressId;
        final String _tmp_3;
        if (_cursor.isNull(_cursorIndexOfAddressId)) {
          _tmp_3 = null;
        } else {
          _tmp_3 = _cursor.getString(_cursorIndexOfAddressId);
        }
        _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_3);
        final int _tmpState;
        _tmpState = _cursor.getInt(_cursorIndexOfState);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpLocalizedClientName;
        if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
          _tmpLocalizedClientName = null;
        } else {
          _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
        }
        final String _tmpPlatform;
        if (_cursor.isNull(_cursorIndexOfPlatform)) {
          _tmpPlatform = null;
        } else {
          _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
        }
        final long _tmpCreatedAtUtcSeconds;
        _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
        final Long _tmpActivatedAtUtcSeconds;
        if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
          _tmpActivatedAtUtcSeconds = null;
        } else {
          _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
        }
        final Long _tmpRejectedAtUtcSeconds;
        if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
          _tmpRejectedAtUtcSeconds = null;
        } else {
          _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
        }
        final String _tmpActivationToken;
        if (_cursor.isNull(_cursorIndexOfActivationToken)) {
          _tmpActivationToken = null;
        } else {
          _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
        }
        final long _tmpLastActivityAtUtcSeconds;
        _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
        _item = new MemberDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpMemberId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<List<MemberDeviceEntity>> observeByDeviceId(final UserId userId,
      final MemberDeviceId deviceId) {
    final String _sql = "SELECT * FROM MemberDeviceEntity WHERE userId = ? AND deviceId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __authConverters.fromMemberDeviceIdToString(deviceId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"MemberDeviceEntity"}, new Callable<List<MemberDeviceEntity>>() {
      @Override
      @NonNull
      public List<MemberDeviceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow(_cursor, "memberId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
          final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
          final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
          final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
          final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
          final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
          final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
          final List<MemberDeviceEntity> _result = new ArrayList<MemberDeviceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final MemberDeviceEntity _item;
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final String _tmpDeviceId;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmpDeviceId = null;
            } else {
              _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
            }
            final UserId _tmpMemberId;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfMemberId)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfMemberId);
            }
            _tmpMemberId = __commonConverters.fromStringToUserId(_tmp_3);
            final AddressId _tmpAddressId;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_4);
            final int _tmpState;
            _tmpState = _cursor.getInt(_cursorIndexOfState);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpLocalizedClientName;
            if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
              _tmpLocalizedClientName = null;
            } else {
              _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
            }
            final String _tmpPlatform;
            if (_cursor.isNull(_cursorIndexOfPlatform)) {
              _tmpPlatform = null;
            } else {
              _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
            }
            final long _tmpCreatedAtUtcSeconds;
            _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
            final Long _tmpActivatedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
              _tmpActivatedAtUtcSeconds = null;
            } else {
              _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
            }
            final Long _tmpRejectedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
              _tmpRejectedAtUtcSeconds = null;
            } else {
              _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
            }
            final String _tmpActivationToken;
            if (_cursor.isNull(_cursorIndexOfActivationToken)) {
              _tmpActivationToken = null;
            } else {
              _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
            }
            final long _tmpLastActivityAtUtcSeconds;
            _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
            _item = new MemberDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpMemberId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<MemberDeviceEntity>> observeByMemberId(final UserId userId,
      final UserId memberId) {
    final String _sql = "SELECT * FROM MemberDeviceEntity WHERE userId = ? AND memberId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(memberId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"MemberDeviceEntity"}, new Callable<List<MemberDeviceEntity>>() {
      @Override
      @NonNull
      public List<MemberDeviceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow(_cursor, "memberId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
          final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
          final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
          final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
          final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
          final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
          final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
          final List<MemberDeviceEntity> _result = new ArrayList<MemberDeviceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final MemberDeviceEntity _item;
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final String _tmpDeviceId;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmpDeviceId = null;
            } else {
              _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
            }
            final UserId _tmpMemberId;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfMemberId)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfMemberId);
            }
            _tmpMemberId = __commonConverters.fromStringToUserId(_tmp_3);
            final AddressId _tmpAddressId;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_4);
            final int _tmpState;
            _tmpState = _cursor.getInt(_cursorIndexOfState);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpLocalizedClientName;
            if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
              _tmpLocalizedClientName = null;
            } else {
              _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
            }
            final String _tmpPlatform;
            if (_cursor.isNull(_cursorIndexOfPlatform)) {
              _tmpPlatform = null;
            } else {
              _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
            }
            final long _tmpCreatedAtUtcSeconds;
            _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
            final Long _tmpActivatedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
              _tmpActivatedAtUtcSeconds = null;
            } else {
              _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
            }
            final Long _tmpRejectedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
              _tmpRejectedAtUtcSeconds = null;
            } else {
              _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
            }
            final String _tmpActivationToken;
            if (_cursor.isNull(_cursorIndexOfActivationToken)) {
              _tmpActivationToken = null;
            } else {
              _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
            }
            final long _tmpLastActivityAtUtcSeconds;
            _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
            _item = new MemberDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpMemberId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<MemberDeviceEntity>> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM MemberDeviceEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"MemberDeviceEntity"}, new Callable<List<MemberDeviceEntity>>() {
      @Override
      @NonNull
      public List<MemberDeviceEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfMemberId = CursorUtil.getColumnIndexOrThrow(_cursor, "memberId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "state");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfLocalizedClientName = CursorUtil.getColumnIndexOrThrow(_cursor, "localizedClientName");
          final int _cursorIndexOfPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "platform");
          final int _cursorIndexOfCreatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtcSeconds");
          final int _cursorIndexOfActivatedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "activatedAtUtcSeconds");
          final int _cursorIndexOfRejectedAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "rejectedAtUtcSeconds");
          final int _cursorIndexOfActivationToken = CursorUtil.getColumnIndexOrThrow(_cursor, "activationToken");
          final int _cursorIndexOfLastActivityAtUtcSeconds = CursorUtil.getColumnIndexOrThrow(_cursor, "lastActivityAtUtcSeconds");
          final List<MemberDeviceEntity> _result = new ArrayList<MemberDeviceEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final MemberDeviceEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpDeviceId;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmpDeviceId = null;
            } else {
              _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
            }
            final UserId _tmpMemberId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfMemberId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfMemberId);
            }
            _tmpMemberId = __commonConverters.fromStringToUserId(_tmp_2);
            final AddressId _tmpAddressId;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_3);
            final int _tmpState;
            _tmpState = _cursor.getInt(_cursorIndexOfState);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpLocalizedClientName;
            if (_cursor.isNull(_cursorIndexOfLocalizedClientName)) {
              _tmpLocalizedClientName = null;
            } else {
              _tmpLocalizedClientName = _cursor.getString(_cursorIndexOfLocalizedClientName);
            }
            final String _tmpPlatform;
            if (_cursor.isNull(_cursorIndexOfPlatform)) {
              _tmpPlatform = null;
            } else {
              _tmpPlatform = _cursor.getString(_cursorIndexOfPlatform);
            }
            final long _tmpCreatedAtUtcSeconds;
            _tmpCreatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfCreatedAtUtcSeconds);
            final Long _tmpActivatedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfActivatedAtUtcSeconds)) {
              _tmpActivatedAtUtcSeconds = null;
            } else {
              _tmpActivatedAtUtcSeconds = _cursor.getLong(_cursorIndexOfActivatedAtUtcSeconds);
            }
            final Long _tmpRejectedAtUtcSeconds;
            if (_cursor.isNull(_cursorIndexOfRejectedAtUtcSeconds)) {
              _tmpRejectedAtUtcSeconds = null;
            } else {
              _tmpRejectedAtUtcSeconds = _cursor.getLong(_cursorIndexOfRejectedAtUtcSeconds);
            }
            final String _tmpActivationToken;
            if (_cursor.isNull(_cursorIndexOfActivationToken)) {
              _tmpActivationToken = null;
            } else {
              _tmpActivationToken = _cursor.getString(_cursorIndexOfActivationToken);
            }
            final long _tmpLastActivityAtUtcSeconds;
            _tmpLastActivityAtUtcSeconds = _cursor.getLong(_cursorIndexOfLastActivityAtUtcSeconds);
            _item = new MemberDeviceEntity(_tmpUserId,_tmpDeviceId,_tmpMemberId,_tmpAddressId,_tmpState,_tmpName,_tmpLocalizedClientName,_tmpPlatform,_tmpCreatedAtUtcSeconds,_tmpActivatedAtUtcSeconds,_tmpRejectedAtUtcSeconds,_tmpActivationToken,_tmpLastActivityAtUtcSeconds);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  protected Object deleteByMemberIdBatch(final UserId userId, final List<UserId> memberIds,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM MemberDeviceEntity WHERE userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" AND memberId IN (");
        final int _inputSize = memberIds.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        for (UserId _item : memberIds) {
          final String _tmp_1 = __commonConverters.fromUserIdToString(_item);
          if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp_1);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg2);
  }

  @Override
  protected Object deleteByDeviceIdBatch(final UserId userId, final List<MemberDeviceId> deviceIds,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM MemberDeviceEntity WHERE userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" AND deviceId IN (");
        final int _inputSize = deviceIds.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        for (MemberDeviceId _item : deviceIds) {
          final String _tmp_1 = __authConverters.fromMemberDeviceIdToString(_item);
          if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp_1);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg2);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
