package me.proton.core.account.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.account.data.entity.SessionDetailsEntity;
import me.proton.core.account.domain.entity.AccountType;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.network.domain.session.SessionId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class SessionDetailsDao_Impl extends SessionDetailsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<SessionDetailsEntity> __insertionAdapterOfSessionDetailsEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final AccountConverters __accountConverters = new AccountConverters();

  private final EntityDeletionOrUpdateAdapter<SessionDetailsEntity> __deletionAdapterOfSessionDetailsEntity;

  private final EntityDeletionOrUpdateAdapter<SessionDetailsEntity> __updateAdapterOfSessionDetailsEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfClearPassword;

  public SessionDetailsDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSessionDetailsEntity = new EntityInsertionAdapter<SessionDetailsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `SessionDetailsEntity` (`sessionId`,`initialEventId`,`requiredAccountType`,`secondFactorEnabled`,`twoPassModeEnabled`,`password`,`fido2AuthenticationOptionsJson`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final SessionDetailsEntity entity) {
        final String _tmp = __commonConverters.fromSessionIdToString(entity.getSessionId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getInitialEventId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getInitialEventId());
        }
        final String _tmp_1 = __accountConverters.fromAccountTypeToString(entity.getRequiredAccountType());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        final int _tmp_2 = entity.getSecondFactorEnabled() ? 1 : 0;
        statement.bindLong(4, _tmp_2);
        final int _tmp_3 = entity.getTwoPassModeEnabled() ? 1 : 0;
        statement.bindLong(5, _tmp_3);
        if (entity.getPassword() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPassword());
        }
        if (entity.getFido2AuthenticationOptionsJson() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getFido2AuthenticationOptionsJson());
        }
      }
    };
    this.__deletionAdapterOfSessionDetailsEntity = new EntityDeletionOrUpdateAdapter<SessionDetailsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `SessionDetailsEntity` WHERE `sessionId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final SessionDetailsEntity entity) {
        final String _tmp = __commonConverters.fromSessionIdToString(entity.getSessionId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfSessionDetailsEntity = new EntityDeletionOrUpdateAdapter<SessionDetailsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `SessionDetailsEntity` SET `sessionId` = ?,`initialEventId` = ?,`requiredAccountType` = ?,`secondFactorEnabled` = ?,`twoPassModeEnabled` = ?,`password` = ?,`fido2AuthenticationOptionsJson` = ? WHERE `sessionId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final SessionDetailsEntity entity) {
        final String _tmp = __commonConverters.fromSessionIdToString(entity.getSessionId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getInitialEventId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getInitialEventId());
        }
        final String _tmp_1 = __accountConverters.fromAccountTypeToString(entity.getRequiredAccountType());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        final int _tmp_2 = entity.getSecondFactorEnabled() ? 1 : 0;
        statement.bindLong(4, _tmp_2);
        final int _tmp_3 = entity.getTwoPassModeEnabled() ? 1 : 0;
        statement.bindLong(5, _tmp_3);
        if (entity.getPassword() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPassword());
        }
        if (entity.getFido2AuthenticationOptionsJson() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getFido2AuthenticationOptionsJson());
        }
        final String _tmp_4 = __commonConverters.fromSessionIdToString(entity.getSessionId());
        if (_tmp_4 == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, _tmp_4);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM SessionDetailsEntity WHERE sessionId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfClearPassword = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE SessionDetailsEntity SET password = null WHERE sessionId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final SessionDetailsEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSessionDetailsEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final SessionDetailsEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfSessionDetailsEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final SessionDetailsEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfSessionDetailsEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final SessionDetailsEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> SessionDetailsDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> SessionDetailsDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object delete(final SessionId sessionId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object clearPassword(final SessionId sessionId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfClearPassword.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfClearPassword.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Flow<SessionDetailsEntity> findBySessionId(final SessionId sessionId) {
    final String _sql = "SELECT * FROM SessionDetailsEntity WHERE sessionId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"SessionDetailsEntity"}, new Callable<SessionDetailsEntity>() {
      @Override
      @Nullable
      public SessionDetailsEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfInitialEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "initialEventId");
          final int _cursorIndexOfRequiredAccountType = CursorUtil.getColumnIndexOrThrow(_cursor, "requiredAccountType");
          final int _cursorIndexOfSecondFactorEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "secondFactorEnabled");
          final int _cursorIndexOfTwoPassModeEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "twoPassModeEnabled");
          final int _cursorIndexOfPassword = CursorUtil.getColumnIndexOrThrow(_cursor, "password");
          final int _cursorIndexOfFido2AuthenticationOptionsJson = CursorUtil.getColumnIndexOrThrow(_cursor, "fido2AuthenticationOptionsJson");
          final SessionDetailsEntity _result;
          if (_cursor.moveToFirst()) {
            final SessionId _tmpSessionId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_1);
            final String _tmpInitialEventId;
            if (_cursor.isNull(_cursorIndexOfInitialEventId)) {
              _tmpInitialEventId = null;
            } else {
              _tmpInitialEventId = _cursor.getString(_cursorIndexOfInitialEventId);
            }
            final AccountType _tmpRequiredAccountType;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfRequiredAccountType)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfRequiredAccountType);
            }
            _tmpRequiredAccountType = __accountConverters.fromStringToAccountType(_tmp_2);
            final boolean _tmpSecondFactorEnabled;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfSecondFactorEnabled);
            _tmpSecondFactorEnabled = _tmp_3 != 0;
            final boolean _tmpTwoPassModeEnabled;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfTwoPassModeEnabled);
            _tmpTwoPassModeEnabled = _tmp_4 != 0;
            final String _tmpPassword;
            if (_cursor.isNull(_cursorIndexOfPassword)) {
              _tmpPassword = null;
            } else {
              _tmpPassword = _cursor.getString(_cursorIndexOfPassword);
            }
            final String _tmpFido2AuthenticationOptionsJson;
            if (_cursor.isNull(_cursorIndexOfFido2AuthenticationOptionsJson)) {
              _tmpFido2AuthenticationOptionsJson = null;
            } else {
              _tmpFido2AuthenticationOptionsJson = _cursor.getString(_cursorIndexOfFido2AuthenticationOptionsJson);
            }
            _result = new SessionDetailsEntity(_tmpSessionId,_tmpInitialEventId,_tmpRequiredAccountType,_tmpSecondFactorEnabled,_tmpTwoPassModeEnabled,_tmpPassword,_tmpFido2AuthenticationOptionsJson);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getBySessionId(final SessionId sessionId,
      final Continuation<? super SessionDetailsEntity> arg1) {
    final String _sql = "SELECT * FROM SessionDetailsEntity WHERE sessionId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SessionDetailsEntity>() {
      @Override
      @Nullable
      public SessionDetailsEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfInitialEventId = CursorUtil.getColumnIndexOrThrow(_cursor, "initialEventId");
          final int _cursorIndexOfRequiredAccountType = CursorUtil.getColumnIndexOrThrow(_cursor, "requiredAccountType");
          final int _cursorIndexOfSecondFactorEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "secondFactorEnabled");
          final int _cursorIndexOfTwoPassModeEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "twoPassModeEnabled");
          final int _cursorIndexOfPassword = CursorUtil.getColumnIndexOrThrow(_cursor, "password");
          final int _cursorIndexOfFido2AuthenticationOptionsJson = CursorUtil.getColumnIndexOrThrow(_cursor, "fido2AuthenticationOptionsJson");
          final SessionDetailsEntity _result;
          if (_cursor.moveToFirst()) {
            final SessionId _tmpSessionId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_1);
            final String _tmpInitialEventId;
            if (_cursor.isNull(_cursorIndexOfInitialEventId)) {
              _tmpInitialEventId = null;
            } else {
              _tmpInitialEventId = _cursor.getString(_cursorIndexOfInitialEventId);
            }
            final AccountType _tmpRequiredAccountType;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfRequiredAccountType)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfRequiredAccountType);
            }
            _tmpRequiredAccountType = __accountConverters.fromStringToAccountType(_tmp_2);
            final boolean _tmpSecondFactorEnabled;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfSecondFactorEnabled);
            _tmpSecondFactorEnabled = _tmp_3 != 0;
            final boolean _tmpTwoPassModeEnabled;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfTwoPassModeEnabled);
            _tmpTwoPassModeEnabled = _tmp_4 != 0;
            final String _tmpPassword;
            if (_cursor.isNull(_cursorIndexOfPassword)) {
              _tmpPassword = null;
            } else {
              _tmpPassword = _cursor.getString(_cursorIndexOfPassword);
            }
            final String _tmpFido2AuthenticationOptionsJson;
            if (_cursor.isNull(_cursorIndexOfFido2AuthenticationOptionsJson)) {
              _tmpFido2AuthenticationOptionsJson = null;
            } else {
              _tmpFido2AuthenticationOptionsJson = _cursor.getString(_cursorIndexOfFido2AuthenticationOptionsJson);
            }
            _result = new SessionDetailsEntity(_tmpSessionId,_tmpInitialEventId,_tmpRequiredAccountType,_tmpSecondFactorEnabled,_tmpTwoPassModeEnabled,_tmpPassword,_tmpFido2AuthenticationOptionsJson);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
