package me.proton.core.auth.data.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.auth.data.db.AuthConverters;
import me.proton.core.auth.data.entity.DeviceSecretEntity;
import me.proton.core.auth.domain.entity.AuthDeviceId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class DeviceSecretDao_Impl extends DeviceSecretDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<DeviceSecretEntity> __insertionAdapterOfDeviceSecretEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final AuthConverters __authConverters = new AuthConverters();

  private final EntityDeletionOrUpdateAdapter<DeviceSecretEntity> __deletionAdapterOfDeviceSecretEntity;

  private final EntityDeletionOrUpdateAdapter<DeviceSecretEntity> __updateAdapterOfDeviceSecretEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public DeviceSecretDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfDeviceSecretEntity = new EntityInsertionAdapter<DeviceSecretEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `DeviceSecretEntity` (`userId`,`deviceId`,`secret`,`token`) VALUES (?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DeviceSecretEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __authConverters.fromAuthDeviceIdToString(entity.getDeviceId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getSecret() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getSecret());
        }
        if (entity.getToken() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getToken());
        }
      }
    };
    this.__deletionAdapterOfDeviceSecretEntity = new EntityDeletionOrUpdateAdapter<DeviceSecretEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `DeviceSecretEntity` WHERE `userId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DeviceSecretEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfDeviceSecretEntity = new EntityDeletionOrUpdateAdapter<DeviceSecretEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `DeviceSecretEntity` SET `userId` = ?,`deviceId` = ?,`secret` = ?,`token` = ? WHERE `userId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DeviceSecretEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __authConverters.fromAuthDeviceIdToString(entity.getDeviceId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getSecret() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getSecret());
        }
        if (entity.getToken() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getToken());
        }
        final String _tmp_2 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_2 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_2);
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM DeviceSecretEntity WHERE userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final DeviceSecretEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfDeviceSecretEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final DeviceSecretEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfDeviceSecretEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final DeviceSecretEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfDeviceSecretEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final DeviceSecretEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> DeviceSecretDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> DeviceSecretDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteAll(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Flow<DeviceSecretEntity> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM DeviceSecretEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"DeviceSecretEntity"}, new Callable<DeviceSecretEntity>() {
      @Override
      @Nullable
      public DeviceSecretEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfSecret = CursorUtil.getColumnIndexOrThrow(_cursor, "secret");
          final int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow(_cursor, "token");
          final DeviceSecretEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final AuthDeviceId _tmpDeviceId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfDeviceId);
            }
            _tmpDeviceId = __authConverters.fromStringToAuthDeviceId(_tmp_2);
            final String _tmpSecret;
            if (_cursor.isNull(_cursorIndexOfSecret)) {
              _tmpSecret = null;
            } else {
              _tmpSecret = _cursor.getString(_cursorIndexOfSecret);
            }
            final String _tmpToken;
            if (_cursor.isNull(_cursorIndexOfToken)) {
              _tmpToken = null;
            } else {
              _tmpToken = _cursor.getString(_cursorIndexOfToken);
            }
            _result = new DeviceSecretEntity(_tmpUserId,_tmpDeviceId,_tmpSecret,_tmpToken);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super DeviceSecretEntity> arg1) {
    final String _sql = "SELECT * FROM DeviceSecretEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<DeviceSecretEntity>() {
      @Override
      @Nullable
      public DeviceSecretEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceId");
          final int _cursorIndexOfSecret = CursorUtil.getColumnIndexOrThrow(_cursor, "secret");
          final int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow(_cursor, "token");
          final DeviceSecretEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final AuthDeviceId _tmpDeviceId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfDeviceId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfDeviceId);
            }
            _tmpDeviceId = __authConverters.fromStringToAuthDeviceId(_tmp_2);
            final String _tmpSecret;
            if (_cursor.isNull(_cursorIndexOfSecret)) {
              _tmpSecret = null;
            } else {
              _tmpSecret = _cursor.getString(_cursorIndexOfSecret);
            }
            final String _tmpToken;
            if (_cursor.isNull(_cursorIndexOfToken)) {
              _tmpToken = null;
            } else {
              _tmpToken = _cursor.getString(_cursorIndexOfToken);
            }
            _result = new DeviceSecretEntity(_tmpUserId,_tmpDeviceId,_tmpSecret,_tmpToken);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
