package me.proton.core.key.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.RelationUtil;
import androidx.room.util.StringUtil;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.key.data.entity.PublicAddressInfoEntity;
import me.proton.core.key.data.entity.PublicAddressInfoWithKeys;
import me.proton.core.key.data.entity.PublicAddressKeyDataEntity;
import me.proton.core.key.data.entity.SignedKeyListEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PublicAddressInfoWithKeysDao_Impl extends PublicAddressInfoWithKeysDao {
  private final RoomDatabase __db;

  private final CommonConverters __commonConverters = new CommonConverters();

  public PublicAddressInfoWithKeysDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
  }

  @Override
  public Flow<PublicAddressInfoWithKeys> findWithKeysByEmail(final String email) {
    final String _sql = "SELECT * FROM PublicAddressInfoEntity WHERE email = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (email == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, email);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[] {"PublicAddressKeyDataEntity",
        "PublicAddressInfoEntity"}, new Callable<PublicAddressInfoWithKeys>() {
      @Override
      @Nullable
      public PublicAddressInfoWithKeys call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfWarnings = CursorUtil.getColumnIndexOrThrow(_cursor, "warnings");
            final int _cursorIndexOfProtonMx = CursorUtil.getColumnIndexOrThrow(_cursor, "protonMx");
            final int _cursorIndexOfIsProton = CursorUtil.getColumnIndexOrThrow(_cursor, "isProton");
            final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "addressSignedKeyList_data");
            final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "addressSignedKeyList_signature");
            final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressSignedKeyList_minEpochId");
            final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressSignedKeyList_maxEpochId");
            final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressSignedKeyList_expectedMinEpochId");
            final int _cursorIndexOfData_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "catchAllSignedKeyList_data");
            final int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "catchAllSignedKeyList_signature");
            final int _cursorIndexOfMinEpochId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "catchAllSignedKeyList_minEpochId");
            final int _cursorIndexOfMaxEpochId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "catchAllSignedKeyList_maxEpochId");
            final int _cursorIndexOfExpectedMinEpochId_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "catchAllSignedKeyList_expectedMinEpochId");
            final ArrayMap<String, ArrayList<PublicAddressKeyDataEntity>> _collectionKeys = new ArrayMap<String, ArrayList<PublicAddressKeyDataEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpKey = null;
              } else {
                _tmpKey = _cursor.getString(_cursorIndexOfEmail);
              }
              if (_tmpKey != null) {
                if (!_collectionKeys.containsKey(_tmpKey)) {
                  _collectionKeys.put(_tmpKey, new ArrayList<PublicAddressKeyDataEntity>());
                }
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipPublicAddressKeyDataEntityAsmeProtonCoreKeyDataEntityPublicAddressKeyDataEntity(_collectionKeys);
            final PublicAddressInfoWithKeys _result;
            if (_cursor.moveToFirst()) {
              final PublicAddressInfoEntity _tmpEntity;
              final String _tmpEmail;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpEmail = null;
              } else {
                _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
              }
              final List<String> _tmpWarnings;
              final String _tmp;
              if (_cursor.isNull(_cursorIndexOfWarnings)) {
                _tmp = null;
              } else {
                _tmp = _cursor.getString(_cursorIndexOfWarnings);
              }
              _tmpWarnings = __commonConverters.fromStringToListOfString(_tmp);
              final boolean _tmpProtonMx;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfProtonMx);
              _tmpProtonMx = _tmp_1 != 0;
              final int _tmpIsProton;
              _tmpIsProton = _cursor.getInt(_cursorIndexOfIsProton);
              final SignedKeyListEntity _tmpAddressSignedKeyList;
              if (!(_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
                final String _tmpData;
                if (_cursor.isNull(_cursorIndexOfData)) {
                  _tmpData = null;
                } else {
                  _tmpData = _cursor.getString(_cursorIndexOfData);
                }
                final String _tmpSignature;
                if (_cursor.isNull(_cursorIndexOfSignature)) {
                  _tmpSignature = null;
                } else {
                  _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
                }
                final Integer _tmpMinEpochId;
                if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                  _tmpMinEpochId = null;
                } else {
                  _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
                }
                final Integer _tmpMaxEpochId;
                if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                  _tmpMaxEpochId = null;
                } else {
                  _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
                }
                final Integer _tmpExpectedMinEpochId;
                if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                  _tmpExpectedMinEpochId = null;
                } else {
                  _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
                }
                _tmpAddressSignedKeyList = new SignedKeyListEntity(_tmpData,_tmpSignature,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
              } else {
                _tmpAddressSignedKeyList = null;
              }
              final SignedKeyListEntity _tmpCatchAllSignedKeyList;
              if (!(_cursor.isNull(_cursorIndexOfData_1) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId_1) && _cursor.isNull(_cursorIndexOfMaxEpochId_1) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId_1))) {
                final String _tmpData_1;
                if (_cursor.isNull(_cursorIndexOfData_1)) {
                  _tmpData_1 = null;
                } else {
                  _tmpData_1 = _cursor.getString(_cursorIndexOfData_1);
                }
                final String _tmpSignature_1;
                if (_cursor.isNull(_cursorIndexOfSignature_1)) {
                  _tmpSignature_1 = null;
                } else {
                  _tmpSignature_1 = _cursor.getString(_cursorIndexOfSignature_1);
                }
                final Integer _tmpMinEpochId_1;
                if (_cursor.isNull(_cursorIndexOfMinEpochId_1)) {
                  _tmpMinEpochId_1 = null;
                } else {
                  _tmpMinEpochId_1 = _cursor.getInt(_cursorIndexOfMinEpochId_1);
                }
                final Integer _tmpMaxEpochId_1;
                if (_cursor.isNull(_cursorIndexOfMaxEpochId_1)) {
                  _tmpMaxEpochId_1 = null;
                } else {
                  _tmpMaxEpochId_1 = _cursor.getInt(_cursorIndexOfMaxEpochId_1);
                }
                final Integer _tmpExpectedMinEpochId_1;
                if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId_1)) {
                  _tmpExpectedMinEpochId_1 = null;
                } else {
                  _tmpExpectedMinEpochId_1 = _cursor.getInt(_cursorIndexOfExpectedMinEpochId_1);
                }
                _tmpCatchAllSignedKeyList = new SignedKeyListEntity(_tmpData_1,_tmpSignature_1,_tmpMinEpochId_1,_tmpMaxEpochId_1,_tmpExpectedMinEpochId_1);
              } else {
                _tmpCatchAllSignedKeyList = null;
              }
              _tmpEntity = new PublicAddressInfoEntity(_tmpEmail,_tmpWarnings,_tmpProtonMx,_tmpIsProton,_tmpAddressSignedKeyList,_tmpCatchAllSignedKeyList);
              final ArrayList<PublicAddressKeyDataEntity> _tmpKeysCollection;
              final String _tmpKey_1;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpKey_1 = null;
              } else {
                _tmpKey_1 = _cursor.getString(_cursorIndexOfEmail);
              }
              if (_tmpKey_1 != null) {
                _tmpKeysCollection = _collectionKeys.get(_tmpKey_1);
              } else {
                _tmpKeysCollection = new ArrayList<PublicAddressKeyDataEntity>();
              }
              _result = new PublicAddressInfoWithKeys(_tmpEntity,_tmpKeysCollection);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipPublicAddressKeyDataEntityAsmeProtonCoreKeyDataEntityPublicAddressKeyDataEntity(
      @NonNull final ArrayMap<String, ArrayList<PublicAddressKeyDataEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    if (_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      RelationUtil.recursiveFetchArrayMap(_map, true, (map) -> {
        __fetchRelationshipPublicAddressKeyDataEntityAsmeProtonCoreKeyDataEntityPublicAddressKeyDataEntity(map);
        return Unit.INSTANCE;
      });
      return;
    }
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `email`,`emailAddressType`,`flags`,`publicKey`,`isPrimary`,`source` FROM `PublicAddressKeyDataEntity` WHERE `email` IN (");
    final int _inputSize = __mapKeySet == null ? 1 : __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    if (__mapKeySet == null) {
      _stmt.bindNull(_argIndex);
    } else {
      for (String _item : __mapKeySet) {
        if (_item == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _item);
        }
        _argIndex++;
      }
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "email");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfEmail = 0;
      final int _cursorIndexOfEmailAddressType = 1;
      final int _cursorIndexOfFlags = 2;
      final int _cursorIndexOfPublicKey = 3;
      final int _cursorIndexOfIsPrimary = 4;
      final int _cursorIndexOfSource = 5;
      while (_cursor.moveToNext()) {
        final String _tmpKey;
        if (_cursor.isNull(_itemKeyIndex)) {
          _tmpKey = null;
        } else {
          _tmpKey = _cursor.getString(_itemKeyIndex);
        }
        if (_tmpKey != null) {
          final ArrayList<PublicAddressKeyDataEntity> _tmpRelation = _map.get(_tmpKey);
          if (_tmpRelation != null) {
            final PublicAddressKeyDataEntity _item_1;
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final int _tmpEmailAddressType;
            _tmpEmailAddressType = _cursor.getInt(_cursorIndexOfEmailAddressType);
            final int _tmpFlags;
            _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
            final String _tmpPublicKey;
            if (_cursor.isNull(_cursorIndexOfPublicKey)) {
              _tmpPublicKey = null;
            } else {
              _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
            }
            final boolean _tmpIsPrimary;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsPrimary);
            _tmpIsPrimary = _tmp != 0;
            final Integer _tmpSource;
            if (_cursor.isNull(_cursorIndexOfSource)) {
              _tmpSource = null;
            } else {
              _tmpSource = _cursor.getInt(_cursorIndexOfSource);
            }
            _item_1 = new PublicAddressKeyDataEntity(_tmpEmail,_tmpEmailAddressType,_tmpFlags,_tmpPublicKey,_tmpIsPrimary,_tmpSource);
            _tmpRelation.add(_item_1);
          }
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
