package me.proton.core.key.data.db;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import me.proton.core.key.data.entity.PublicAddressKeyDataEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PublicAddressKeyDataDao_Impl extends PublicAddressKeyDataDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PublicAddressKeyDataEntity> __insertionAdapterOfPublicAddressKeyDataEntity;

  private final EntityDeletionOrUpdateAdapter<PublicAddressKeyDataEntity> __deletionAdapterOfPublicAddressKeyDataEntity;

  private final EntityDeletionOrUpdateAdapter<PublicAddressKeyDataEntity> __updateAdapterOfPublicAddressKeyDataEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByEmail;

  public PublicAddressKeyDataDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPublicAddressKeyDataEntity = new EntityInsertionAdapter<PublicAddressKeyDataEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `PublicAddressKeyDataEntity` (`email`,`emailAddressType`,`flags`,`publicKey`,`isPrimary`,`source`) VALUES (?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressKeyDataEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
        statement.bindLong(2, entity.getEmailAddressType());
        statement.bindLong(3, entity.getFlags());
        if (entity.getPublicKey() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPublicKey());
        }
        final int _tmp = entity.isPrimary() ? 1 : 0;
        statement.bindLong(5, _tmp);
        if (entity.getSource() == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, entity.getSource());
        }
      }
    };
    this.__deletionAdapterOfPublicAddressKeyDataEntity = new EntityDeletionOrUpdateAdapter<PublicAddressKeyDataEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `PublicAddressKeyDataEntity` WHERE `email` = ? AND `publicKey` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressKeyDataEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
        if (entity.getPublicKey() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPublicKey());
        }
      }
    };
    this.__updateAdapterOfPublicAddressKeyDataEntity = new EntityDeletionOrUpdateAdapter<PublicAddressKeyDataEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PublicAddressKeyDataEntity` SET `email` = ?,`emailAddressType` = ?,`flags` = ?,`publicKey` = ?,`isPrimary` = ?,`source` = ? WHERE `email` = ? AND `publicKey` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PublicAddressKeyDataEntity entity) {
        if (entity.getEmail() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getEmail());
        }
        statement.bindLong(2, entity.getEmailAddressType());
        statement.bindLong(3, entity.getFlags());
        if (entity.getPublicKey() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPublicKey());
        }
        final int _tmp = entity.isPrimary() ? 1 : 0;
        statement.bindLong(5, _tmp);
        if (entity.getSource() == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, entity.getSource());
        }
        if (entity.getEmail() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getEmail());
        }
        if (entity.getPublicKey() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getPublicKey());
        }
      }
    };
    this.__preparedStmtOfDeleteByEmail = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM PublicAddressKeyDataEntity WHERE email = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final PublicAddressKeyDataEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPublicAddressKeyDataEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final PublicAddressKeyDataEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfPublicAddressKeyDataEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final PublicAddressKeyDataEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfPublicAddressKeyDataEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final PublicAddressKeyDataEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PublicAddressKeyDataDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PublicAddressKeyDataDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteByEmail(final String email, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByEmail.acquire();
        int _argIndex = 1;
        if (email == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, email);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteByEmail.release(_stmt);
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
