package me.proton.core.payment.data.local.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalArgumentException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.network.domain.session.SessionId;
import me.proton.core.payment.data.local.entity.PurchaseEntity;
import me.proton.core.payment.domain.entity.Currency;
import me.proton.core.payment.domain.entity.PurchaseState;
import me.proton.core.payment.domain.usecase.PaymentProvider;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PurchaseDao_Impl extends PurchaseDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PurchaseEntity> __insertionAdapterOfPurchaseEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<PurchaseEntity> __deletionAdapterOfPurchaseEntity;

  private final EntityDeletionOrUpdateAdapter<PurchaseEntity> __updateAdapterOfPurchaseEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfUpdatePurchaseState;

  public PurchaseDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPurchaseEntity = new EntityInsertionAdapter<PurchaseEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `PurchaseEntity` (`sessionId`,`planName`,`planCycle`,`purchaseState`,`purchaseFailure`,`paymentProvider`,`paymentOrderId`,`paymentToken`,`paymentCurrency`,`paymentAmount`) VALUES (?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PurchaseEntity entity) {
        final String _tmp = __commonConverters.fromSessionIdToString(entity.getSessionId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getPlanName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPlanName());
        }
        statement.bindLong(3, entity.getPlanCycle());
        statement.bindString(4, __PurchaseState_enumToString(entity.getPurchaseState()));
        if (entity.getPurchaseFailure() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getPurchaseFailure());
        }
        statement.bindString(6, __PaymentProvider_enumToString(entity.getPaymentProvider()));
        if (entity.getPaymentOrderId() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getPaymentOrderId());
        }
        if (entity.getPaymentToken() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getPaymentToken());
        }
        statement.bindString(9, __Currency_enumToString(entity.getPaymentCurrency()));
        statement.bindLong(10, entity.getPaymentAmount());
      }
    };
    this.__deletionAdapterOfPurchaseEntity = new EntityDeletionOrUpdateAdapter<PurchaseEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `PurchaseEntity` WHERE `planName` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PurchaseEntity entity) {
        if (entity.getPlanName() == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, entity.getPlanName());
        }
      }
    };
    this.__updateAdapterOfPurchaseEntity = new EntityDeletionOrUpdateAdapter<PurchaseEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PurchaseEntity` SET `sessionId` = ?,`planName` = ?,`planCycle` = ?,`purchaseState` = ?,`purchaseFailure` = ?,`paymentProvider` = ?,`paymentOrderId` = ?,`paymentToken` = ?,`paymentCurrency` = ?,`paymentAmount` = ? WHERE `planName` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PurchaseEntity entity) {
        final String _tmp = __commonConverters.fromSessionIdToString(entity.getSessionId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getPlanName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPlanName());
        }
        statement.bindLong(3, entity.getPlanCycle());
        statement.bindString(4, __PurchaseState_enumToString(entity.getPurchaseState()));
        if (entity.getPurchaseFailure() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getPurchaseFailure());
        }
        statement.bindString(6, __PaymentProvider_enumToString(entity.getPaymentProvider()));
        if (entity.getPaymentOrderId() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getPaymentOrderId());
        }
        if (entity.getPaymentToken() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getPaymentToken());
        }
        statement.bindString(9, __Currency_enumToString(entity.getPaymentCurrency()));
        statement.bindLong(10, entity.getPaymentAmount());
        if (entity.getPlanName() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getPlanName());
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM PurchaseEntity WHERE planName = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdatePurchaseState = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE PurchaseEntity SET purchaseState = ? WHERE planName = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final PurchaseEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPurchaseEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final PurchaseEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfPurchaseEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final PurchaseEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfPurchaseEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final PurchaseEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PurchaseDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PurchaseDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object delete(final String planName, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        if (planName == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, planName);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object updatePurchaseState(final String planName, final PurchaseState state,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdatePurchaseState.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, __PurchaseState_enumToString(state));
        _argIndex = 2;
        if (planName == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, planName);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdatePurchaseState.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Flow<PurchaseEntity> observe(final String planName) {
    final String _sql = "SELECT * FROM PurchaseEntity WHERE planName = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (planName == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, planName);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"PurchaseEntity"}, new Callable<PurchaseEntity>() {
      @Override
      @Nullable
      public PurchaseEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfPlanName = CursorUtil.getColumnIndexOrThrow(_cursor, "planName");
          final int _cursorIndexOfPlanCycle = CursorUtil.getColumnIndexOrThrow(_cursor, "planCycle");
          final int _cursorIndexOfPurchaseState = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseState");
          final int _cursorIndexOfPurchaseFailure = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseFailure");
          final int _cursorIndexOfPaymentProvider = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentProvider");
          final int _cursorIndexOfPaymentOrderId = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentOrderId");
          final int _cursorIndexOfPaymentToken = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentToken");
          final int _cursorIndexOfPaymentCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentCurrency");
          final int _cursorIndexOfPaymentAmount = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentAmount");
          final PurchaseEntity _result;
          if (_cursor.moveToFirst()) {
            final SessionId _tmpSessionId;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp);
            final String _tmpPlanName;
            if (_cursor.isNull(_cursorIndexOfPlanName)) {
              _tmpPlanName = null;
            } else {
              _tmpPlanName = _cursor.getString(_cursorIndexOfPlanName);
            }
            final int _tmpPlanCycle;
            _tmpPlanCycle = _cursor.getInt(_cursorIndexOfPlanCycle);
            final PurchaseState _tmpPurchaseState;
            _tmpPurchaseState = __PurchaseState_stringToEnum(_cursor.getString(_cursorIndexOfPurchaseState));
            final String _tmpPurchaseFailure;
            if (_cursor.isNull(_cursorIndexOfPurchaseFailure)) {
              _tmpPurchaseFailure = null;
            } else {
              _tmpPurchaseFailure = _cursor.getString(_cursorIndexOfPurchaseFailure);
            }
            final PaymentProvider _tmpPaymentProvider;
            _tmpPaymentProvider = __PaymentProvider_stringToEnum(_cursor.getString(_cursorIndexOfPaymentProvider));
            final String _tmpPaymentOrderId;
            if (_cursor.isNull(_cursorIndexOfPaymentOrderId)) {
              _tmpPaymentOrderId = null;
            } else {
              _tmpPaymentOrderId = _cursor.getString(_cursorIndexOfPaymentOrderId);
            }
            final String _tmpPaymentToken;
            if (_cursor.isNull(_cursorIndexOfPaymentToken)) {
              _tmpPaymentToken = null;
            } else {
              _tmpPaymentToken = _cursor.getString(_cursorIndexOfPaymentToken);
            }
            final Currency _tmpPaymentCurrency;
            _tmpPaymentCurrency = __Currency_stringToEnum(_cursor.getString(_cursorIndexOfPaymentCurrency));
            final long _tmpPaymentAmount;
            _tmpPaymentAmount = _cursor.getLong(_cursorIndexOfPaymentAmount);
            _result = new PurchaseEntity(_tmpSessionId,_tmpPlanName,_tmpPlanCycle,_tmpPurchaseState,_tmpPurchaseFailure,_tmpPaymentProvider,_tmpPaymentOrderId,_tmpPaymentToken,_tmpPaymentCurrency,_tmpPaymentAmount);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<PurchaseEntity>> observe() {
    final String _sql = "SELECT * FROM PurchaseEntity";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"PurchaseEntity"}, new Callable<List<PurchaseEntity>>() {
      @Override
      @NonNull
      public List<PurchaseEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfPlanName = CursorUtil.getColumnIndexOrThrow(_cursor, "planName");
          final int _cursorIndexOfPlanCycle = CursorUtil.getColumnIndexOrThrow(_cursor, "planCycle");
          final int _cursorIndexOfPurchaseState = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseState");
          final int _cursorIndexOfPurchaseFailure = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseFailure");
          final int _cursorIndexOfPaymentProvider = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentProvider");
          final int _cursorIndexOfPaymentOrderId = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentOrderId");
          final int _cursorIndexOfPaymentToken = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentToken");
          final int _cursorIndexOfPaymentCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentCurrency");
          final int _cursorIndexOfPaymentAmount = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentAmount");
          final List<PurchaseEntity> _result = new ArrayList<PurchaseEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PurchaseEntity _item;
            final SessionId _tmpSessionId;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp);
            final String _tmpPlanName;
            if (_cursor.isNull(_cursorIndexOfPlanName)) {
              _tmpPlanName = null;
            } else {
              _tmpPlanName = _cursor.getString(_cursorIndexOfPlanName);
            }
            final int _tmpPlanCycle;
            _tmpPlanCycle = _cursor.getInt(_cursorIndexOfPlanCycle);
            final PurchaseState _tmpPurchaseState;
            _tmpPurchaseState = __PurchaseState_stringToEnum(_cursor.getString(_cursorIndexOfPurchaseState));
            final String _tmpPurchaseFailure;
            if (_cursor.isNull(_cursorIndexOfPurchaseFailure)) {
              _tmpPurchaseFailure = null;
            } else {
              _tmpPurchaseFailure = _cursor.getString(_cursorIndexOfPurchaseFailure);
            }
            final PaymentProvider _tmpPaymentProvider;
            _tmpPaymentProvider = __PaymentProvider_stringToEnum(_cursor.getString(_cursorIndexOfPaymentProvider));
            final String _tmpPaymentOrderId;
            if (_cursor.isNull(_cursorIndexOfPaymentOrderId)) {
              _tmpPaymentOrderId = null;
            } else {
              _tmpPaymentOrderId = _cursor.getString(_cursorIndexOfPaymentOrderId);
            }
            final String _tmpPaymentToken;
            if (_cursor.isNull(_cursorIndexOfPaymentToken)) {
              _tmpPaymentToken = null;
            } else {
              _tmpPaymentToken = _cursor.getString(_cursorIndexOfPaymentToken);
            }
            final Currency _tmpPaymentCurrency;
            _tmpPaymentCurrency = __Currency_stringToEnum(_cursor.getString(_cursorIndexOfPaymentCurrency));
            final long _tmpPaymentAmount;
            _tmpPaymentAmount = _cursor.getLong(_cursorIndexOfPaymentAmount);
            _item = new PurchaseEntity(_tmpSessionId,_tmpPlanName,_tmpPlanCycle,_tmpPurchaseState,_tmpPurchaseFailure,_tmpPaymentProvider,_tmpPaymentOrderId,_tmpPaymentToken,_tmpPaymentCurrency,_tmpPaymentAmount);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object get(final String planName, final Continuation<? super PurchaseEntity> arg1) {
    final String _sql = "SELECT * FROM PurchaseEntity WHERE planName = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (planName == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, planName);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PurchaseEntity>() {
      @Override
      @Nullable
      public PurchaseEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfPlanName = CursorUtil.getColumnIndexOrThrow(_cursor, "planName");
          final int _cursorIndexOfPlanCycle = CursorUtil.getColumnIndexOrThrow(_cursor, "planCycle");
          final int _cursorIndexOfPurchaseState = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseState");
          final int _cursorIndexOfPurchaseFailure = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseFailure");
          final int _cursorIndexOfPaymentProvider = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentProvider");
          final int _cursorIndexOfPaymentOrderId = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentOrderId");
          final int _cursorIndexOfPaymentToken = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentToken");
          final int _cursorIndexOfPaymentCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentCurrency");
          final int _cursorIndexOfPaymentAmount = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentAmount");
          final PurchaseEntity _result;
          if (_cursor.moveToFirst()) {
            final SessionId _tmpSessionId;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp);
            final String _tmpPlanName;
            if (_cursor.isNull(_cursorIndexOfPlanName)) {
              _tmpPlanName = null;
            } else {
              _tmpPlanName = _cursor.getString(_cursorIndexOfPlanName);
            }
            final int _tmpPlanCycle;
            _tmpPlanCycle = _cursor.getInt(_cursorIndexOfPlanCycle);
            final PurchaseState _tmpPurchaseState;
            _tmpPurchaseState = __PurchaseState_stringToEnum(_cursor.getString(_cursorIndexOfPurchaseState));
            final String _tmpPurchaseFailure;
            if (_cursor.isNull(_cursorIndexOfPurchaseFailure)) {
              _tmpPurchaseFailure = null;
            } else {
              _tmpPurchaseFailure = _cursor.getString(_cursorIndexOfPurchaseFailure);
            }
            final PaymentProvider _tmpPaymentProvider;
            _tmpPaymentProvider = __PaymentProvider_stringToEnum(_cursor.getString(_cursorIndexOfPaymentProvider));
            final String _tmpPaymentOrderId;
            if (_cursor.isNull(_cursorIndexOfPaymentOrderId)) {
              _tmpPaymentOrderId = null;
            } else {
              _tmpPaymentOrderId = _cursor.getString(_cursorIndexOfPaymentOrderId);
            }
            final String _tmpPaymentToken;
            if (_cursor.isNull(_cursorIndexOfPaymentToken)) {
              _tmpPaymentToken = null;
            } else {
              _tmpPaymentToken = _cursor.getString(_cursorIndexOfPaymentToken);
            }
            final Currency _tmpPaymentCurrency;
            _tmpPaymentCurrency = __Currency_stringToEnum(_cursor.getString(_cursorIndexOfPaymentCurrency));
            final long _tmpPaymentAmount;
            _tmpPaymentAmount = _cursor.getLong(_cursorIndexOfPaymentAmount);
            _result = new PurchaseEntity(_tmpSessionId,_tmpPlanName,_tmpPlanCycle,_tmpPurchaseState,_tmpPurchaseFailure,_tmpPaymentProvider,_tmpPaymentOrderId,_tmpPaymentToken,_tmpPaymentCurrency,_tmpPaymentAmount);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getAll(final Continuation<? super List<PurchaseEntity>> arg0) {
    final String _sql = "SELECT * FROM PurchaseEntity";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PurchaseEntity>>() {
      @Override
      @NonNull
      public List<PurchaseEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfPlanName = CursorUtil.getColumnIndexOrThrow(_cursor, "planName");
          final int _cursorIndexOfPlanCycle = CursorUtil.getColumnIndexOrThrow(_cursor, "planCycle");
          final int _cursorIndexOfPurchaseState = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseState");
          final int _cursorIndexOfPurchaseFailure = CursorUtil.getColumnIndexOrThrow(_cursor, "purchaseFailure");
          final int _cursorIndexOfPaymentProvider = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentProvider");
          final int _cursorIndexOfPaymentOrderId = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentOrderId");
          final int _cursorIndexOfPaymentToken = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentToken");
          final int _cursorIndexOfPaymentCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentCurrency");
          final int _cursorIndexOfPaymentAmount = CursorUtil.getColumnIndexOrThrow(_cursor, "paymentAmount");
          final List<PurchaseEntity> _result = new ArrayList<PurchaseEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PurchaseEntity _item;
            final SessionId _tmpSessionId;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp);
            final String _tmpPlanName;
            if (_cursor.isNull(_cursorIndexOfPlanName)) {
              _tmpPlanName = null;
            } else {
              _tmpPlanName = _cursor.getString(_cursorIndexOfPlanName);
            }
            final int _tmpPlanCycle;
            _tmpPlanCycle = _cursor.getInt(_cursorIndexOfPlanCycle);
            final PurchaseState _tmpPurchaseState;
            _tmpPurchaseState = __PurchaseState_stringToEnum(_cursor.getString(_cursorIndexOfPurchaseState));
            final String _tmpPurchaseFailure;
            if (_cursor.isNull(_cursorIndexOfPurchaseFailure)) {
              _tmpPurchaseFailure = null;
            } else {
              _tmpPurchaseFailure = _cursor.getString(_cursorIndexOfPurchaseFailure);
            }
            final PaymentProvider _tmpPaymentProvider;
            _tmpPaymentProvider = __PaymentProvider_stringToEnum(_cursor.getString(_cursorIndexOfPaymentProvider));
            final String _tmpPaymentOrderId;
            if (_cursor.isNull(_cursorIndexOfPaymentOrderId)) {
              _tmpPaymentOrderId = null;
            } else {
              _tmpPaymentOrderId = _cursor.getString(_cursorIndexOfPaymentOrderId);
            }
            final String _tmpPaymentToken;
            if (_cursor.isNull(_cursorIndexOfPaymentToken)) {
              _tmpPaymentToken = null;
            } else {
              _tmpPaymentToken = _cursor.getString(_cursorIndexOfPaymentToken);
            }
            final Currency _tmpPaymentCurrency;
            _tmpPaymentCurrency = __Currency_stringToEnum(_cursor.getString(_cursorIndexOfPaymentCurrency));
            final long _tmpPaymentAmount;
            _tmpPaymentAmount = _cursor.getLong(_cursorIndexOfPaymentAmount);
            _item = new PurchaseEntity(_tmpSessionId,_tmpPlanName,_tmpPlanCycle,_tmpPurchaseState,_tmpPurchaseFailure,_tmpPaymentProvider,_tmpPaymentOrderId,_tmpPaymentToken,_tmpPaymentCurrency,_tmpPaymentAmount);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg0);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private String __PurchaseState_enumToString(@NonNull final PurchaseState _value) {
    switch (_value) {
      case Pending: return "Pending";
      case Purchased: return "Purchased";
      case Subscribed: return "Subscribed";
      case Acknowledged: return "Acknowledged";
      case Failed: return "Failed";
      case Cancelled: return "Cancelled";
      case Deleted: return "Deleted";
      default: throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }
  }

  private String __PaymentProvider_enumToString(@NonNull final PaymentProvider _value) {
    switch (_value) {
      case CardPayment: return "CardPayment";
      case GoogleInAppPurchase: return "GoogleInAppPurchase";
      case PayPal: return "PayPal";
      default: throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }
  }

  private String __Currency_enumToString(@NonNull final Currency _value) {
    switch (_value) {
      case EUR: return "EUR";
      case USD: return "USD";
      case CHF: return "CHF";
      default: throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }
  }

  private PurchaseState __PurchaseState_stringToEnum(@NonNull final String _value) {
    switch (_value) {
      case "Pending": return PurchaseState.Pending;
      case "Purchased": return PurchaseState.Purchased;
      case "Subscribed": return PurchaseState.Subscribed;
      case "Acknowledged": return PurchaseState.Acknowledged;
      case "Failed": return PurchaseState.Failed;
      case "Cancelled": return PurchaseState.Cancelled;
      case "Deleted": return PurchaseState.Deleted;
      default: throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
  }

  private PaymentProvider __PaymentProvider_stringToEnum(@NonNull final String _value) {
    switch (_value) {
      case "CardPayment": return PaymentProvider.CardPayment;
      case "GoogleInAppPurchase": return PaymentProvider.GoogleInAppPurchase;
      case "PayPal": return PaymentProvider.PayPal;
      default: throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
  }

  private Currency __Currency_stringToEnum(@NonNull final String _value) {
    switch (_value) {
      case "EUR": return Currency.EUR;
      case "USD": return Currency.USD;
      case "CHF": return Currency.CHF;
      default: throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
  }
}
