package me.proton.core.push.data.local.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.push.domain.entity.PushId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PushDao_Impl extends PushDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PushEntity> __insertionAdapterOfPushEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final PushConverters __pushConverters = new PushConverters();

  private final EntityDeletionOrUpdateAdapter<PushEntity> __deletionAdapterOfPushEntity;

  private final EntityDeletionOrUpdateAdapter<PushEntity> __updateAdapterOfPushEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllPushes;

  private final SharedSQLiteStatement __preparedStmtOfDeletePushes;

  public PushDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPushEntity = new EntityInsertionAdapter<PushEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `PushEntity` (`userId`,`pushId`,`objectId`,`type`) VALUES (?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PushEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __pushConverters.fromPushIdToString(entity.getPushId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getObjectId() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getObjectId());
        }
        if (entity.getType() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getType());
        }
      }
    };
    this.__deletionAdapterOfPushEntity = new EntityDeletionOrUpdateAdapter<PushEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `PushEntity` WHERE `userId` = ? AND `pushId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PushEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __pushConverters.fromPushIdToString(entity.getPushId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
      }
    };
    this.__updateAdapterOfPushEntity = new EntityDeletionOrUpdateAdapter<PushEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PushEntity` SET `userId` = ?,`pushId` = ?,`objectId` = ?,`type` = ? WHERE `userId` = ? AND `pushId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PushEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __pushConverters.fromPushIdToString(entity.getPushId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getObjectId() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getObjectId());
        }
        if (entity.getType() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getType());
        }
        final String _tmp_2 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_2 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_2);
        }
        final String _tmp_3 = __pushConverters.fromPushIdToString(entity.getPushId());
        if (_tmp_3 == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, _tmp_3);
        }
      }
    };
    this.__preparedStmtOfDeleteAllPushes = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM PushEntity";
        return _query;
      }
    };
    this.__preparedStmtOfDeletePushes = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM PushEntity WHERE userId = ? AND type = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final PushEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPushEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final PushEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfPushEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final PushEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfPushEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final PushEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PushDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public <V> Object deleteChunked(final List<? extends V> entities,
      final Function2<? super List<? extends V>, ? super Continuation<? super Unit>, ?> delete,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PushDao_Impl.super.deleteChunked(entities, delete, __cont), $completion);
  }

  @Override
  public Object deleteAllPushes(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllPushes.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAllPushes.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Object deletePushes(final UserId userId, final String pushType,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeletePushes.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (pushType == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, pushType);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeletePushes.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Flow<List<PushEntity>> observeAllPushes(final UserId userId, final String type) {
    final String _sql = "SELECT * FROM PushEntity WHERE userId = ? AND type = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    if (type == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, type);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"PushEntity"}, new Callable<List<PushEntity>>() {
      @Override
      @NonNull
      public List<PushEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfPushId = CursorUtil.getColumnIndexOrThrow(_cursor, "pushId");
          final int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow(_cursor, "objectId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final List<PushEntity> _result = new ArrayList<PushEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PushEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final PushId _tmpPushId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfPushId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfPushId);
            }
            _tmpPushId = __pushConverters.fromStringToPushId(_tmp_2);
            final String _tmpObjectId;
            if (_cursor.isNull(_cursorIndexOfObjectId)) {
              _tmpObjectId = null;
            } else {
              _tmpObjectId = _cursor.getString(_cursorIndexOfObjectId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            _item = new PushEntity(_tmpUserId,_tmpPushId,_tmpObjectId,_tmpType);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAllPushes(final UserId userId, final String type,
      final Continuation<? super List<PushEntity>> arg2) {
    final String _sql = "SELECT * FROM PushEntity WHERE userId = ? AND type = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    if (type == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, type);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PushEntity>>() {
      @Override
      @NonNull
      public List<PushEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfPushId = CursorUtil.getColumnIndexOrThrow(_cursor, "pushId");
          final int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow(_cursor, "objectId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final List<PushEntity> _result = new ArrayList<PushEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PushEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final PushId _tmpPushId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfPushId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfPushId);
            }
            _tmpPushId = __pushConverters.fromStringToPushId(_tmp_2);
            final String _tmpObjectId;
            if (_cursor.isNull(_cursorIndexOfObjectId)) {
              _tmpObjectId = null;
            } else {
              _tmpObjectId = _cursor.getString(_cursorIndexOfObjectId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            _item = new PushEntity(_tmpUserId,_tmpPushId,_tmpObjectId,_tmpType);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg2);
  }

  @Override
  public Object getPush(final UserId userId, final PushId pushId,
      final Continuation<? super PushEntity> arg2) {
    final String _sql = "SELECT * FROM PushEntity WHERE userId = ? AND pushId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __pushConverters.fromPushIdToString(pushId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PushEntity>() {
      @Override
      @Nullable
      public PushEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfPushId = CursorUtil.getColumnIndexOrThrow(_cursor, "pushId");
          final int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow(_cursor, "objectId");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final PushEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final PushId _tmpPushId;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfPushId)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfPushId);
            }
            _tmpPushId = __pushConverters.fromStringToPushId(_tmp_3);
            final String _tmpObjectId;
            if (_cursor.isNull(_cursorIndexOfObjectId)) {
              _tmpObjectId = null;
            } else {
              _tmpObjectId = _cursor.getString(_cursorIndexOfObjectId);
            }
            final String _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getString(_cursorIndexOfType);
            }
            _result = new PushEntity(_tmpUserId,_tmpPushId,_tmpObjectId,_tmpType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg2);
  }

  @Override
  public Object deletePushes(final UserId[] userIds, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM PushEntity WHERE userId IN (");
        final int _inputSize = userIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (UserId _item : userIds) {
          final String _tmp = __commonConverters.fromUserIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object deletePushes(final UserId userId, final PushId[] pushIds,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM PushEntity WHERE userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" AND pushId IN (");
        final int _inputSize = pushIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        for (PushId _item : pushIds) {
          final String _tmp_1 = __pushConverters.fromPushIdToString(_item);
          if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp_1);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg2);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
