/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.mailsendpreferences.domain.usecase;

import ezvcard.VCard;
import ezvcard.property.RawProperty;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.proton.core.contact.domain.CryptoUtils;
import me.proton.core.contact.domain.VCardUtilsKt;
import me.proton.core.crypto.common.context.CryptoContext;
import me.proton.core.domain.type.IntEnum;
import me.proton.core.domain.type.StringEnum;
import me.proton.core.key.domain.entity.key.PublicAddress;
import me.proton.core.key.domain.entity.key.PublicAddressKey;
import me.proton.core.key.domain.entity.key.PublicAddressKeyKt;
import me.proton.core.key.domain.entity.key.PublicKey;
import me.proton.core.key.domain.entity.key.Recipient;
import me.proton.core.mailsendpreferences.domain.model.SendPreferences;
import me.proton.core.mailsettings.domain.entity.MailSettings;
import me.proton.core.mailsettings.domain.entity.MimeType;
import me.proton.core.mailsettings.domain.entity.PackageType;
import me.proton.core.util.kotlin.StringUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences;", "", "cryptoUtils", "Lme/proton/core/contact/domain/CryptoUtils;", "(Lme/proton/core/contact/domain/CryptoUtils;)V", "combineSendingSettings", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$SendingSettings;", "vCard", "Lezvcard/VCard;", "vCardEmail", "", "defaultMailSettings", "Lme/proton/core/mailsettings/domain/entity/MailSettings;", "invoke", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result;", "cryptoContext", "Lme/proton/core/crypto/common/context/CryptoContext;", "publicAddress", "Lme/proton/core/key/domain/entity/key/PublicAddress;", "Result", "SendingSettings", "mail-send-preferences-domain"})
@SourceDebugExtension(value={"SMAP\nCreateSendPreferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateSendPreferences.kt\nme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n288#2,2:244\n288#2,2:246\n*S KotlinDebug\n*F\n+ 1 CreateSendPreferences.kt\nme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences\n*L\n67#1:244,2\n134#1:246,2\n*E\n"})
public final class CreateSendPreferences {
    @NotNull
    private final CryptoUtils cryptoUtils;

    @Inject
    public CreateSendPreferences(@NotNull CryptoUtils cryptoUtils) {
        Intrinsics.checkNotNullParameter((Object)cryptoUtils, (String)"cryptoUtils");
        this.cryptoUtils = cryptoUtils;
    }

    @NotNull
    public final Result invoke(@NotNull CryptoContext cryptoContext, @NotNull String vCardEmail, @NotNull PublicAddress publicAddress, @NotNull VCard vCard, @NotNull MailSettings defaultMailSettings) {
        Result result;
        List list;
        Object v0;
        boolean isInternal;
        block16: {
            Intrinsics.checkNotNullParameter((Object)cryptoContext, (String)"cryptoContext");
            Intrinsics.checkNotNullParameter((Object)vCardEmail, (String)"vCardEmail");
            Intrinsics.checkNotNullParameter((Object)publicAddress, (String)"publicAddress");
            Intrinsics.checkNotNullParameter((Object)vCard, (String)"vCard");
            Intrinsics.checkNotNullParameter((Object)defaultMailSettings, (String)"defaultMailSettings");
            isInternal = publicAddress.getRecipient() == Recipient.Internal;
            Iterable $this$firstOrNull$iv = publicAddress.getKeys();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PublicAddressKey it = (PublicAddressKey)element$iv;
                boolean bl = false;
                if (!it.getPublicKey().isPrimary()) continue;
                v0 = element$iv;
                break block16;
            }
            v0 = null;
        }
        PublicAddressKey publicAddressKey = v0;
        if (publicAddressKey != null && (PublicAddressKeyKt.isObsolete((int)publicAddressKey.getFlags()) || PublicAddressKeyKt.isCompromised((int)publicAddressKey.getFlags()))) {
            return Result.Error.PublicKeysInvalid.INSTANCE;
        }
        if (VCardUtilsKt.getGroupForEmail((VCard)vCard, (String)vCardEmail) == null) {
            return Result.Error.NoEmailInVCard.INSTANCE;
        }
        SendingSettings sendingSettings = this.combineSendingSettings(vCard, vCardEmail, defaultMailSettings);
        if (sendingSettings == null) {
            return Result.Error.MailSettingsInvalid.INSTANCE;
        }
        SendingSettings sendingSettings2 = sendingSettings;
        CryptoUtils.PinnedKeysOrError pinnedKeysOrError = this.cryptoUtils.extractPinnedPublicKeys((CryptoUtils.PinnedKeysPurpose)CryptoUtils.PinnedKeysPurpose.Encrypting.INSTANCE, vCardEmail, vCard, publicAddress, cryptoContext);
        if (pinnedKeysOrError instanceof CryptoUtils.PinnedKeysOrError.Success) {
            list = ((CryptoUtils.PinnedKeysOrError.Success)pinnedKeysOrError).getPinnedPublicKeys();
        } else if (pinnedKeysOrError instanceof CryptoUtils.PinnedKeysOrError.Error.NoKeysAvailable ? true : Intrinsics.areEqual((Object)pinnedKeysOrError, (Object)CryptoUtils.PinnedKeysOrError.Error.NoEmailInVCard.INSTANCE)) {
            list = null;
        } else {
            return Result.Error.TrustedKeysInvalid.INSTANCE;
        }
        List pinnedPublicKeys = list;
        if (isInternal) {
            Collection collection = pinnedPublicKeys;
            if ((collection == null || collection.isEmpty()) && publicAddressKey == null) {
                result = Result.Error.NoKeysAvailable.INSTANCE;
            } else {
                MimeType mimeType = sendingSettings2.getMimeType();
                List list2 = pinnedPublicKeys;
                if (list2 == null || (list2 = (PublicKey)CollectionsKt.firstOrNull((List)list2)) == null) {
                    PublicAddressKey publicAddressKey2 = publicAddressKey;
                    list2 = publicAddressKey2 != null ? publicAddressKey2.getPublicKey() : null;
                }
                result = new Result.Success(new SendPreferences(true, true, PackageType.ProtonMail, mimeType, (PublicKey)list2));
            }
        } else if (sendingSettings2.getEncrypt() && pinnedPublicKeys == null && publicAddressKey == null) {
            result = Result.Error.NoKeysAvailable.INSTANCE;
        } else {
            boolean bl = sendingSettings2.getEncrypt();
            boolean bl2 = sendingSettings2.getEncrypt() ? true : sendingSettings2.getSign();
            PackageType packageType = sendingSettings2.getScheme();
            MimeType mimeType = sendingSettings2.getMimeType();
            List list3 = pinnedPublicKeys;
            if (list3 == null || (list3 = (PublicKey)CollectionsKt.firstOrNull((List)list3)) == null) {
                PublicAddressKey publicAddressKey3 = publicAddressKey;
                list3 = publicAddressKey3 != null ? publicAddressKey3.getPublicKey() : null;
            }
            result = new Result.Success(new SendPreferences(bl, bl2, packageType, mimeType, (PublicKey)list3));
        }
        return result;
    }

    @NotNull
    public final Result invoke(@NotNull MailSettings defaultMailSettings, @Nullable PublicAddress publicAddress) {
        Result result;
        block12: {
            Result.Success success;
            block16: {
                boolean sign;
                block13: {
                    IntEnum defaultPgpScheme;
                    Object object;
                    PublicAddressKey publicAddressKey;
                    block15: {
                        block14: {
                            IntEnum intEnum;
                            block11: {
                                Intrinsics.checkNotNullParameter((Object)defaultMailSettings, (String)"defaultMailSettings");
                                PublicAddress publicAddress2 = publicAddress;
                                boolean isInternal = (publicAddress2 != null ? publicAddress2.getRecipient() : null) == Recipient.Internal;
                                Object object2 = publicAddress;
                                if (object2 != null && (object2 = object2.getKeys()) != null) {
                                    Object v2;
                                    block10: {
                                        Iterable $this$firstOrNull$iv = (Iterable)object2;
                                        boolean $i$f$firstOrNull = false;
                                        for (Object element$iv : $this$firstOrNull$iv) {
                                            PublicAddressKey it = (PublicAddressKey)element$iv;
                                            boolean bl = false;
                                            if (!it.getPublicKey().isPrimary()) continue;
                                            v2 = element$iv;
                                            break block10;
                                        }
                                        v2 = null;
                                    }
                                    v3 = v2;
                                } else {
                                    v3 = publicAddressKey = null;
                                }
                                if (publicAddressKey != null && (PublicAddressKeyKt.isObsolete((int)publicAddressKey.getFlags()) || PublicAddressKeyKt.isCompromised((int)publicAddressKey.getFlags()))) {
                                    return Result.Error.PublicKeysInvalid.INSTANCE;
                                }
                                Boolean bl = defaultMailSettings.getSign();
                                if (bl == null) {
                                    return Result.Error.MailSettingsInvalid.INSTANCE;
                                }
                                sign = bl;
                                StringEnum stringEnum = defaultMailSettings.getDraftMimeType();
                                if (stringEnum == null || (stringEnum = (MimeType)stringEnum.getEnum()) == null) {
                                    return Result.Error.MailSettingsInvalid.INSTANCE;
                                }
                                StringEnum draftMimeType = stringEnum;
                                if (!isInternal) break block11;
                                result = publicAddressKey != null ? (Result)new Result.Success(new SendPreferences(true, true, PackageType.ProtonMail, (MimeType)draftMimeType, publicAddressKey.getPublicKey())) : (Result)Result.Error.NoKeysAvailable.INSTANCE;
                                break block12;
                            }
                            if (publicAddressKey == null) break block13;
                            object = defaultMailSettings.getPgpScheme();
                            if (object == null || (object = (PackageType)object.getEnum()) == null) break block14;
                            IntEnum it = intEnum = object;
                            boolean bl = false;
                            object = it == PackageType.PgpInline || it == PackageType.PgpMime ? intEnum : null;
                            if (object != null) break block15;
                        }
                        object = PackageType.PgpMime;
                    }
                    MimeType defaultMimeType = (defaultPgpScheme = object) == PackageType.PgpMime ? MimeType.Mixed : MimeType.PlainText;
                    success = new Result.Success(new SendPreferences(true, true, (PackageType)defaultPgpScheme, defaultMimeType, publicAddressKey.getPublicKey()));
                    break block16;
                }
                success = new Result.Success(new SendPreferences(false, sign, PackageType.Cleartext, MimeType.PlainText, null));
            }
            result = success;
        }
        return result;
    }

    private final SendingSettings combineSendingSettings(VCard vCard, String vCardEmail, MailSettings defaultMailSettings) {
        MimeType mimeType;
        PackageType scheme;
        boolean sign;
        boolean encrypt;
        block16: {
            block15: {
                String string;
                Object object;
                boolean bl;
                String string2 = VCardUtilsKt.getGroupForEmail((VCard)vCard, (String)vCardEmail);
                if (string2 == null) {
                    return null;
                }
                String propertyGroup = string2;
                RawProperty vCardEncrypt = VCardUtilsKt.getProperty((VCard)vCard, (String)propertyGroup, (String)"x-pm-encrypt");
                RawProperty vCardSign = VCardUtilsKt.getProperty((VCard)vCard, (String)propertyGroup, (String)"x-pm-sign");
                RawProperty vCardMime = VCardUtilsKt.getProperty((VCard)vCard, (String)propertyGroup, (String)"x-pm-mimetype");
                RawProperty vCardScheme = VCardUtilsKt.getProperty((VCard)vCard, (String)propertyGroup, (String)"x-pm-scheme");
                RawProperty rawProperty = vCardEncrypt;
                if (rawProperty != null) {
                    String string3 = (String)rawProperty.getValue();
                    v3 = string3 != null ? StringUtilsKt.equalsNoCase((String)string3, (String)"true") : false;
                } else {
                    v3 = encrypt = false;
                }
                if (vCardSign != null) {
                    String string4 = (String)vCardSign.getValue();
                    bl = string4 != null ? StringUtilsKt.equalsNoCase((String)string4, (String)"true") : false;
                } else {
                    Boolean bl2 = defaultMailSettings.getSign();
                    if (bl2 != null) {
                        bl = bl2;
                    } else {
                        return null;
                    }
                }
                sign = bl;
                RawProperty rawProperty2 = vCardScheme;
                String string5 = rawProperty2 != null ? (String)rawProperty2.getValue() : null;
                if (string5 == null) {
                    string5 = "";
                }
                if ((object = PackageType.Companion.enumFromScheme(string5, encrypt, sign)) == null) {
                    IntEnum intEnum = defaultMailSettings.getPgpScheme();
                    object = intEnum != null ? (PackageType)intEnum.getEnum() : null;
                    if (object == null) {
                        return null;
                    }
                }
                scheme = object;
                RawProperty rawProperty3 = vCardMime;
                if ((rawProperty3 != null ? (String)rawProperty3.getValue() : null) != null) {
                    v12 = (String)vCardMime.getValue();
                } else {
                    StringEnum stringEnum = defaultMailSettings.getDraftMimeType();
                    v12 = string = stringEnum != null ? stringEnum.getValue() : null;
                }
                if (string == null) break block15;
                String mimeString = string;
                boolean bl3 = false;
                mimeType = MimeType.Companion.enumFromContentType(mimeString);
                if (mimeType != null) break block16;
            }
            return null;
        }
        MimeType mimeType2 = mimeType;
        return new SendingSettings(encrypt, sign, scheme, mimeType2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result;", "", "()V", "Error", "Success", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Success;", "mail-send-preferences-domain"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result;", "()V", "MailSettingsInvalid", "NoEmailInVCard", "NoKeysAvailable", "PublicKeysInvalid", "TrustedKeysInvalid", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$MailSettingsInvalid;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$NoEmailInVCard;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$NoKeysAvailable;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$PublicKeysInvalid;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$TrustedKeysInvalid;", "mail-send-preferences-domain"})
        public static abstract class Error
        extends Result {
            private Error() {
                super(null);
            }

            public /* synthetic */ Error(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$MailSettingsInvalid;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error;", "()V", "mail-send-preferences-domain"})
            public static final class MailSettingsInvalid
            extends Error {
                @NotNull
                public static final MailSettingsInvalid INSTANCE = new MailSettingsInvalid();

                private MailSettingsInvalid() {
                    super(null);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$NoEmailInVCard;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error;", "()V", "mail-send-preferences-domain"})
            public static final class NoEmailInVCard
            extends Error {
                @NotNull
                public static final NoEmailInVCard INSTANCE = new NoEmailInVCard();

                private NoEmailInVCard() {
                    super(null);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$NoKeysAvailable;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error;", "()V", "mail-send-preferences-domain"})
            public static final class NoKeysAvailable
            extends Error {
                @NotNull
                public static final NoKeysAvailable INSTANCE = new NoKeysAvailable();

                private NoKeysAvailable() {
                    super(null);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$PublicKeysInvalid;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error;", "()V", "mail-send-preferences-domain"})
            public static final class PublicKeysInvalid
            extends Error {
                @NotNull
                public static final PublicKeysInvalid INSTANCE = new PublicKeysInvalid();

                private PublicKeysInvalid() {
                    super(null);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error$TrustedKeysInvalid;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Error;", "()V", "mail-send-preferences-domain"})
            public static final class TrustedKeysInvalid
            extends Error {
                @NotNull
                public static final TrustedKeysInvalid INSTANCE = new TrustedKeysInvalid();

                private TrustedKeysInvalid() {
                    super(null);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result$Success;", "Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$Result;", "sendPreferences", "Lme/proton/core/mailsendpreferences/domain/model/SendPreferences;", "(Lme/proton/core/mailsendpreferences/domain/model/SendPreferences;)V", "getSendPreferences", "()Lme/proton/core/mailsendpreferences/domain/model/SendPreferences;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "mail-send-preferences-domain"})
        public static final class Success
        extends Result {
            @NotNull
            private final SendPreferences sendPreferences;

            public Success(@NotNull SendPreferences sendPreferences) {
                Intrinsics.checkNotNullParameter((Object)sendPreferences, (String)"sendPreferences");
                super(null);
                this.sendPreferences = sendPreferences;
            }

            @NotNull
            public final SendPreferences getSendPreferences() {
                return this.sendPreferences;
            }

            @NotNull
            public final SendPreferences component1() {
                return this.sendPreferences;
            }

            @NotNull
            public final Success copy(@NotNull SendPreferences sendPreferences) {
                Intrinsics.checkNotNullParameter((Object)sendPreferences, (String)"sendPreferences");
                return new Success(sendPreferences);
            }

            public static /* synthetic */ Success copy$default(Success success, SendPreferences sendPreferences, int n, Object object) {
                if ((n & 1) != 0) {
                    sendPreferences = success.sendPreferences;
                }
                return success.copy(sendPreferences);
            }

            @NotNull
            public String toString() {
                return "Success(sendPreferences=" + this.sendPreferences + ")";
            }

            public int hashCode() {
                return this.sendPreferences.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.sendPreferences, (Object)success.sendPreferences);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lme/proton/core/mailsendpreferences/domain/usecase/CreateSendPreferences$SendingSettings;", "", "encrypt", "", "sign", "scheme", "Lme/proton/core/mailsettings/domain/entity/PackageType;", "mimeType", "Lme/proton/core/mailsettings/domain/entity/MimeType;", "(ZZLme/proton/core/mailsettings/domain/entity/PackageType;Lme/proton/core/mailsettings/domain/entity/MimeType;)V", "getEncrypt", "()Z", "getMimeType", "()Lme/proton/core/mailsettings/domain/entity/MimeType;", "getScheme", "()Lme/proton/core/mailsettings/domain/entity/PackageType;", "getSign", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "mail-send-preferences-domain"})
    public static final class SendingSettings {
        private final boolean encrypt;
        private final boolean sign;
        @NotNull
        private final PackageType scheme;
        @NotNull
        private final MimeType mimeType;

        public SendingSettings(boolean encrypt, boolean sign, @NotNull PackageType scheme, @NotNull MimeType mimeType) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            this.encrypt = encrypt;
            this.sign = sign;
            this.scheme = scheme;
            this.mimeType = mimeType;
        }

        public final boolean getEncrypt() {
            return this.encrypt;
        }

        public final boolean getSign() {
            return this.sign;
        }

        @NotNull
        public final PackageType getScheme() {
            return this.scheme;
        }

        @NotNull
        public final MimeType getMimeType() {
            return this.mimeType;
        }

        public final boolean component1() {
            return this.encrypt;
        }

        public final boolean component2() {
            return this.sign;
        }

        @NotNull
        public final PackageType component3() {
            return this.scheme;
        }

        @NotNull
        public final MimeType component4() {
            return this.mimeType;
        }

        @NotNull
        public final SendingSettings copy(boolean encrypt, boolean sign, @NotNull PackageType scheme, @NotNull MimeType mimeType) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return new SendingSettings(encrypt, sign, scheme, mimeType);
        }

        public static /* synthetic */ SendingSettings copy$default(SendingSettings sendingSettings, boolean bl, boolean bl2, PackageType packageType, MimeType mimeType, int n, Object object) {
            if ((n & 1) != 0) {
                bl = sendingSettings.encrypt;
            }
            if ((n & 2) != 0) {
                bl2 = sendingSettings.sign;
            }
            if ((n & 4) != 0) {
                packageType = sendingSettings.scheme;
            }
            if ((n & 8) != 0) {
                mimeType = sendingSettings.mimeType;
            }
            return sendingSettings.copy(bl, bl2, packageType, mimeType);
        }

        @NotNull
        public String toString() {
            return "SendingSettings(encrypt=" + this.encrypt + ", sign=" + this.sign + ", scheme=" + this.scheme + ", mimeType=" + this.mimeType + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.encrypt);
            result = result * 31 + Boolean.hashCode(this.sign);
            result = result * 31 + this.scheme.hashCode();
            result = result * 31 + this.mimeType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SendingSettings)) {
                return false;
            }
            SendingSettings sendingSettings = (SendingSettings)other;
            if (this.encrypt != sendingSettings.encrypt) {
                return false;
            }
            if (this.sign != sendingSettings.sign) {
                return false;
            }
            if (this.scheme != sendingSettings.scheme) {
                return false;
            }
            return this.mimeType == sendingSettings.mimeType;
        }
    }
}

