/*
 * Copyright (c) 2021 Proton Technologies AG
 * This file is part of Proton Technologies AG and ProtonCore.
 *
 * ProtonCore is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ProtonCore is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ProtonCore.  If not, see <https://www.gnu.org/licenses/>.
 */
package me.proton.core.compose.theme

import androidx.compose.ui.unit.dp

object ProtonDimens {
    val ExtraSmallSpacing = 4.dp
    val SmallSpacing = 8.dp
    val DefaultSpacing = 16.dp
    val MediumSpacing = 24.dp
    val LargeSpacing = 32.dp
    val LargerSpacing = 40.dp

    val DefaultCornerRadius = 4.dp
    val LargeCornerRadius = 8.dp
    val ExtraLargeCornerRadius = 12.dp

    val DefaultButtonMinHeight = 48.dp
    val SmallIconSize = 16.dp
    val CounterIconSize = 20.dp
    val DefaultIconSize = 24.dp

    val DefaultBottomSheetHeaderMinHeight = 56.dp

    val ListItemHeight = 48.dp
    val ListItemTextStartPadding = 12.dp
}
