/*
 * Decompiled with CFR 0.152.
 */
package me.shib.gitlab.release.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class FileContent {
    private File destination;
    private boolean overwrite;
    private String[] lines;

    void writeContentToFile(String charset, Log log) throws MojoExecutionException {
        if (null == this.destination) {
            throw new MojoExecutionException("Content destination not specified");
        }
        if (!this.destination.exists() || this.overwrite) {
            this.destination.getParentFile().mkdirs();
            if (this.destination.exists()) {
                log.info((CharSequence)("Overwriting to file: " + this.destination.getAbsolutePath()));
            } else {
                log.info((CharSequence)("Creating and writing to file: " + this.destination.getAbsolutePath()));
            }
        } else {
            log.info((CharSequence)("Skipped writing to file: " + this.destination.getAbsolutePath()));
        }
        try {
            if (null != this.lines && this.lines.length > 0) {
                StringBuilder content = new StringBuilder(this.lines[0]);
                for (int i = 1; i < this.lines.length; ++i) {
                    content.append("\n");
                    if (null == this.lines[i]) continue;
                    content.append(this.lines[i]);
                }
                FileWriter writer = new FileWriter(this.destination);
                writer.append(content.toString());
                writer.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

