/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageAdapter;
import org.mule.providers.jms.MessageRedeliveredException;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.umo.MessagingException;

public class DefaultRedeliveryHandler
implements RedeliveryHandler {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$jms$DefaultRedeliveryHandler == null ? (class$org$mule$providers$jms$DefaultRedeliveryHandler = DefaultRedeliveryHandler.class$("org.mule.providers.jms.DefaultRedeliveryHandler")) : class$org$mule$providers$jms$DefaultRedeliveryHandler));
    private Map messages = Collections.synchronizedMap(new LRUMap(256));
    protected JmsConnector connector;
    static /* synthetic */ Class class$org$mule$providers$jms$DefaultRedeliveryHandler;

    public void setConnector(JmsConnector connector) {
        this.connector = connector;
    }

    public void handleRedelivery(Message message) throws JMSException, MessagingException {
        if (this.connector.getMaxRedelivery() <= 0) {
            return;
        }
        String id = message.getJMSMessageID();
        Integer i = (Integer)this.messages.remove(id);
        if (i == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered for the fist time"));
            }
            this.messages.put(id, new Integer(1));
            return;
        }
        if (i.intValue() == this.connector.getMaxRedelivery()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered " + (i + 1) + " times, which exceeds the maxRedelivery setting on the connector"));
            }
            JmsMessageAdapter adapter = (JmsMessageAdapter)this.connector.getMessageAdapter(message);
            throw new MessageRedeliveredException(adapter);
        }
        this.messages.put(id, new Integer(i + 1));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Message with id: " + id + " has been redelivered " + i + " times"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

