/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.NamingException;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;

public class Jms11Support
implements JmsSupport {
    protected Context context;
    protected boolean jndiDestinations = false;
    protected boolean forceJndiDestinations = false;
    protected JmsConnector connector;

    public Jms11Support(JmsConnector connector, Context context, boolean jndiDestinations, boolean forceJndiDestinations) {
        this.connector = connector;
        this.context = context;
        this.jndiDestinations = jndiDestinations;
        this.forceJndiDestinations = forceJndiDestinations;
    }

    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        return connectionFactory.createConnection(username, password);
    }

    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        return connectionFactory.createConnection();
    }

    public Session createSession(Connection connection, boolean topic, boolean transacted, int ackMode, boolean noLocal) throws JMSException {
        return connection.createSession(transacted, transacted ? 0 : ackMode);
    }

    public MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        return session.createProducer(destination);
    }

    public MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        return this.createConsumer(session, destination, null, false, null);
    }

    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, boolean noLocal, String durableName) throws JMSException {
        if (durableName == null) {
            if (destination instanceof Topic) {
                return session.createConsumer(destination, messageSelector, noLocal);
            }
            return session.createConsumer(destination, messageSelector);
        }
        if (destination instanceof Topic) {
            return session.createDurableSubscriber((Topic)destination, durableName, messageSelector, noLocal);
        }
        throw new JMSException("A durable subscriber name was set but the destination was not a Topic");
    }

    public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (name == null) {
            throw new IllegalArgumentException("Destination name cannot be null when creating a destination");
        }
        if (this.jndiDestinations) {
            if (this.context == null) {
                throw new IllegalArgumentException("Jndi Context name cannot be null when looking up a destination");
            }
            Destination dest = this.getJndiDestination(name);
            if (dest != null) {
                return dest;
            }
            if (this.forceJndiDestinations) {
                throw new JMSException("JNDI destination not found with name: " + name);
            }
        }
        if (!topic) {
            if (session instanceof QueueSession) {
                return ((QueueSession)session).createQueue(name);
            }
            return session.createQueue(name);
        }
        if (session instanceof TopicSession) {
            return ((TopicSession)session).createTopic(name);
        }
        return session.createTopic(name);
    }

    protected Destination getJndiDestination(String name) throws JMSException {
        Object temp = null;
        try {
            temp = this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new JMSException("Failed to look up destination: " + e.getMessage());
        }
        if (temp != null) {
            if (temp instanceof Destination) {
                return (Destination)temp;
            }
            if (this.forceJndiDestinations) {
                throw new JMSException("JNDI destination not found with name: " + name);
            }
        }
        return null;
    }

    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (!topic) {
            if (session instanceof QueueSession) {
                return ((QueueSession)session).createTemporaryQueue();
            }
            return session.createTemporaryQueue();
        }
        if (session instanceof TopicSession) {
            return ((TopicSession)session).createTemporaryTopic();
        }
        return session.createTemporaryTopic();
    }

    public void send(MessageProducer producer, Message message) throws JMSException {
        this.send(producer, message, this.connector.isPersistentDelivery(), 4, 0L);
    }

    public void send(MessageProducer producer, Message message, Destination dest) throws JMSException {
        this.send(producer, message, dest, this.connector.isPersistentDelivery(), 4, 0L);
    }

    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl) throws JMSException {
        producer.send(message, persistent ? 2 : 1, priority, ttl);
    }

    public void send(MessageProducer producer, Message message, Destination dest, boolean persistent, int priority, long ttl) throws JMSException {
        producer.send(dest, message, persistent ? 2 : 1, priority, ttl);
    }
}

