/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.ConnectException;
import org.mule.providers.ReplyToHandler;
import org.mule.providers.jms.DefaultRedeliveryHandler;
import org.mule.providers.jms.Jms102bSupport;
import org.mule.providers.jms.Jms11Support;
import org.mule.providers.jms.JmsClientAcknowledgeTransactionFactory;
import org.mule.providers.jms.JmsReplyToHandler;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.xa.ConnectionFactoryWrapper;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.util.BeanUtils;
import org.mule.util.ClassHelper;

public class JmsConnector
extends AbstractServiceEnabledConnector {
    public static final String JMS_SELECTOR_PROPERTY = "selector";
    public static final String JMS_SPECIFICATION_102B = "1.0.2b";
    public static final String JMS_SPECIFICATION_11 = "1.1";
    private String connectionFactoryJndiName;
    private ConnectionFactory connectionFactory;
    private String jndiInitialFactory;
    private String jndiProviderUrl;
    private int acknowledgementMode = 1;
    private String clientId;
    private boolean durable;
    private boolean noLocal;
    private boolean persistentDelivery;
    private Map jndiProviderProperties;
    private Map connectionFactoryProperties;
    private Connection connection;
    private String specification = "1.0.2b";
    private JmsSupport jmsSupport;
    private Context jndiContext;
    private boolean jndiDestinations = false;
    private boolean forceJndiDestinations = false;
    public String username = null;
    public String password = null;
    private int maxRedelivery = 0;
    private String redeliveryHandler = (class$org$mule$providers$jms$DefaultRedeliveryHandler == null ? (class$org$mule$providers$jms$DefaultRedeliveryHandler = JmsConnector.class$("org.mule.providers.jms.DefaultRedeliveryHandler")) : class$org$mule$providers$jms$DefaultRedeliveryHandler).getName();
    static /* synthetic */ Class class$org$mule$providers$jms$DefaultRedeliveryHandler;

    public JmsConnector() {
        this.receivers = new ConcurrentHashMap();
    }

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        try {
            if (this.connectionFactory == null || this.connectionFactory != null && this.jndiInitialFactory != null) {
                this.initJndiContext();
            } else {
                this.jndiDestinations = false;
                this.forceJndiDestinations = false;
            }
            this.jmsSupport = JMS_SPECIFICATION_102B.equals(this.specification) ? new Jms102bSupport(this, this.jndiContext, this.jndiDestinations, this.forceJndiDestinations) : new Jms11Support(this, this.jndiContext, this.jndiDestinations, this.forceJndiDestinations);
            if (this.connectionFactory == null) {
                this.connectionFactory = this.createConnectionFactory();
            }
            if (this.connectionFactoryProperties != null && !this.connectionFactoryProperties.isEmpty()) {
                BeanUtils.populateWithoutFail((Object)this.connectionFactory, (Map)this.connectionFactoryProperties, (boolean)true);
            }
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(65, (Object)"Jms Connector"), (Throwable)e, (Object)this);
        }
    }

    protected void initJndiContext() throws NamingException, InitialisationException {
        if (this.jndiContext == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.jndiInitialFactory != null) {
                props.put("java.naming.factory.initial", this.jndiInitialFactory);
            } else if (this.jndiProviderProperties == null || !this.jndiProviderProperties.containsKey("java.naming.factory.initial")) {
                throw new InitialisationException(new Message(45, (Object)"jndiInitialFactory"), (Object)this);
            }
            if (this.jndiProviderUrl != null) {
                props.put("java.naming.provider.url", this.jndiProviderUrl);
            }
            if (this.jndiProviderProperties != null) {
                props.putAll(this.jndiProviderProperties);
            }
            this.jndiContext = new InitialContext(props);
        }
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected ConnectionFactory createConnectionFactory() throws InitialisationException, NamingException {
        Object temp = this.jndiContext.lookup(this.connectionFactoryJndiName);
        if (temp instanceof ConnectionFactory) {
            return (ConnectionFactory)temp;
        }
        throw new InitialisationException(new Message(121, (Object)this.connectionFactoryJndiName), (Object)this);
    }

    protected Connection createConnection() throws NamingException, JMSException, InitialisationException {
        Connection connection = null;
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        if (this.connectionFactory != null && this.connectionFactory instanceof XAConnectionFactory && MuleManager.getInstance().getTransactionManager() != null) {
            this.connectionFactory = new ConnectionFactoryWrapper(this.connectionFactory, MuleManager.getInstance().getTransactionManager());
        }
        connection = this.username != null ? this.jmsSupport.createConnection(this.connectionFactory, this.username, this.password) : this.jmsSupport.createConnection(this.connectionFactory);
        if (this.clientId != null) {
            connection.setClientID(this.getClientId());
        }
        return connection;
    }

    public void doConnect() throws ConnectException {
        try {
            this.connection = this.createConnection();
            if (this.started.get()) {
                this.connection.start();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws ConnectException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
        finally {
            this.connection = null;
        }
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return component.getDescriptor().getName() + "~" + endpoint.getEndpointURI().getAddress();
    }

    public Object getSessionFactory(UMOEndpoint endpoint) {
        if (endpoint.getTransactionConfig() != null && endpoint.getTransactionConfig().getFactory() instanceof JmsClientAcknowledgeTransactionFactory) {
            throw new MuleRuntimeException(new Message("jms", 9));
        }
        return this.connection;
    }

    public Session getCurrentSession() {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.connection)) {
            return (Session)tx.getResource((Object)this.connection);
        }
        return null;
    }

    public Session getSession(boolean transacted, boolean topic) throws JMSException {
        if (!this.isConnected()) {
            // empty if block
        }
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        Session session = this.getCurrentSession();
        if (session != null) {
            this.logger.debug((Object)"Retrieving jms session from current transaction");
            return session;
        }
        this.logger.debug((Object)"Retrieving new jms session from connection");
        session = this.jmsSupport.createSession(this.connection, topic, transacted || tx != null, this.acknowledgementMode, this.noLocal);
        if (tx != null) {
            this.logger.debug((Object)"Binding session to current transaction");
            try {
                tx.bindResource((Object)this.connection, (Object)session);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind session to current transaction", e);
            }
        }
        return session;
    }

    public void doStart() throws UMOException {
        if (this.connection != null) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                throw new LifecycleException(new Message(42, (Object)"Jms Connection"), (Object)e);
            }
        }
    }

    public String getProtocol() {
        return "jms";
    }

    protected void doDispose() {
        super.doDispose();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
            this.connection = null;
        }
        if (this.jndiContext != null) {
            try {
                this.jndiContext.close();
            }
            catch (NamingException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
        }
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public String getConnectionFactoryJndiName() {
        return this.connectionFactoryJndiName;
    }

    public void setConnectionFactoryJndiName(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isPersistentDelivery() {
        return this.persistentDelivery;
    }

    public void setPersistentDelivery(boolean persistentDelivery) {
        this.persistentDelivery = persistentDelivery;
    }

    public Map getProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setProviderProperties(Map providerProperties) {
        this.jndiProviderProperties = providerProperties;
    }

    public Map getJndiProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setJndiProviderProperties(Map jndiProviderProperties) {
        this.jndiProviderProperties = jndiProviderProperties;
    }

    public Map getConnectionFactoryProperties() {
        return this.connectionFactoryProperties;
    }

    public void setConnectionFactoryProperties(Map connectionFactoryProperties) {
        this.connectionFactoryProperties = connectionFactoryProperties;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public Session getSession(UMOEndpoint endpoint) throws Exception {
        String resourceInfo = endpoint.getEndpointURI().getResourceInfo();
        boolean topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
        return this.getSession(endpoint.getTransactionConfig().isTransacted(), topic);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    public void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public boolean isJndiDestinations() {
        return this.jndiDestinations;
    }

    public void setJndiDestinations(boolean jndiDestinations) {
        this.jndiDestinations = jndiDestinations;
    }

    public boolean isForceJndiDestinations() {
        return this.forceJndiDestinations;
    }

    public void setForceJndiDestinations(boolean forceJndiDestinations) {
        this.forceJndiDestinations = forceJndiDestinations;
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.jndiContext = jndiContext;
    }

    protected RedeliveryHandler createRedeliveryHandler() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        if (this.redeliveryHandler != null) {
            return (RedeliveryHandler)ClassHelper.instanciateClass((String)this.redeliveryHandler, (Object[])ClassHelper.NO_ARGS);
        }
        return new DefaultRedeliveryHandler();
    }

    public ReplyToHandler getReplyToHandler() {
        return new JmsReplyToHandler(this, this.defaultOutboundTransformer);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getMaxRedelivery() {
        return this.maxRedelivery;
    }

    public void setMaxRedelivery(int maxRedelivery) {
        this.maxRedelivery = maxRedelivery;
    }

    public String getRedeliveryHandler() {
        return this.redeliveryHandler;
    }

    public void setRedeliveryHandler(String redeliveryHandler) {
        this.redeliveryHandler = redeliveryHandler;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

