/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UniqueIdNotSupportedException;

public class JmsMessageAdapter
extends AbstractMessageAdapter {
    private static final transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$jms$JmsMessageAdapter == null ? (class$org$mule$providers$jms$JmsMessageAdapter = JmsMessageAdapter.class$("org.mule.providers.jms.JmsMessageAdapter")) : class$org$mule$providers$jms$JmsMessageAdapter));
    private Message message = null;
    static /* synthetic */ Class class$org$mule$providers$jms$JmsMessageAdapter;

    public JmsMessageAdapter(Object message) throws MessagingException {
        this.setMessage(message);
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.getPayloadAsBytes());
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return JmsMessageUtils.getBytesFromMessage(this.message);
    }

    public Object getPayload() {
        return this.message;
    }

    private void setMessage(Object message) throws MessagingException {
        if (!(message instanceof Message)) {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        this.message = (Message)message;
        try {
            this.properties.put("JMSCorrelationID", this.message.getJMSCorrelationID());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSDeliveryMode", new Integer(this.message.getJMSDeliveryMode()));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSDestination", this.message.getJMSDestination());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSExpiration", new Long(this.message.getJMSExpiration()));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSMessageID", this.message.getJMSMessageID());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSPriority", new Integer(this.message.getJMSPriority()));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSRedelivered", new Boolean(this.message.getJMSRedelivered()));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSReplyTo", this.message.getJMSReplyTo());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSTimestamp", new Long(this.message.getJMSTimestamp()));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            this.properties.put("JMSType", this.message.getJMSType());
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Enumeration e = this.message.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                try {
                    this.properties.put(key, this.message.getObjectProperty(key));
                }
                catch (JMSException e1) {}
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        return (String)this.properties.get("JMSMessageID");
    }

    public void setCorrelationId(String id) {
        this.properties.put("JMSCorrelationID", id);
    }

    public String getCorrelationId() {
        return (String)this.properties.get("JMSCorrelationID");
    }

    public Object getReplyTo() {
        Object replyTo = this.properties.remove("JMSReplyTo");
        if (replyTo == null) {
            replyTo = this.properties.get("MULE_REPLYTO");
        }
        return replyTo;
    }

    public void setProperty(Object key, Object value) {
        if ("JMSReplyTo".equals(key)) {
            this.setReplyTo(value);
        }
        super.setProperty(key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

