/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.providers.jms.JmsUtils;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;

public class JmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private Session delegateSession;

    public JmsMessageDispatcher(JmsConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.dispatchMessage(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UMOMessage dispatchMessage(UMOEvent event) throws Exception {
        MessageConsumer consumer;
        MessageProducer producer;
        Session session;
        Session txSession;
        block24: {
            javax.jms.Message result;
            block25: {
                UMOMessage priority2;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("dispatching on endpoint: " + event.getEndpoint().getEndpointURI() + ". Event id is: " + event.getId()));
                }
                txSession = null;
                session = null;
                producer = null;
                consumer = null;
                try {
                    session = this.connector.getSession(event.getEndpoint());
                    txSession = this.connector.getCurrentSession();
                    boolean remoteSync = this.useRemoteSync(event);
                    if (txSession != null && remoteSync) {
                        throw new IllegalTransactionStateException(new Message("jms", 2));
                    }
                    UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
                    boolean topic = false;
                    String resourceInfo = endpointUri.getResourceInfo();
                    topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
                    Destination dest = this.connector.getJmsSupport().createDestination(session, endpointUri.getAddress(), topic);
                    producer = this.connector.getJmsSupport().createProducer(session, dest);
                    Object message = event.getTransformedMessage();
                    if (!(message instanceof javax.jms.Message)) {
                        throw new DispatchException(new Message(125, (Object)"JMS message", (Object)message.getClass().getName(), (Object)this.connector.getName()), event.getMessage(), event.getEndpoint());
                    }
                    javax.jms.Message msg = (javax.jms.Message)message;
                    if (event.getMessage().getCorrelationId() != null) {
                        msg.setJMSCorrelationID(event.getMessage().getCorrelationId());
                    }
                    Destination replyTo = null;
                    Object tempReplyTo = event.removeProperty((Object)"JMSReplyTo");
                    if (tempReplyTo != null) {
                        if (tempReplyTo instanceof Destination) {
                            replyTo = (Destination)tempReplyTo;
                        } else {
                            boolean replyToTopic = false;
                            String reply = tempReplyTo.toString();
                            int i = reply.indexOf(":");
                            if (i > -1) {
                                String qtype = reply.substring(0, i);
                                replyToTopic = "topic".equalsIgnoreCase(qtype);
                                reply = reply.substring(i + 1);
                            }
                            replyTo = this.connector.getJmsSupport().createDestination(session, reply, replyToTopic);
                        }
                    }
                    if (remoteSync && replyTo == null) {
                        replyTo = this.connector.getJmsSupport().createTemporaryDestination(session, topic);
                    }
                    if (replyTo != null) {
                        msg.setJMSReplyTo(replyTo);
                    }
                    if (remoteSync) {
                        consumer = this.connector.getJmsSupport().createConsumer(session, replyTo);
                    }
                    String ttlString = (String)event.removeProperty((Object)"TimeToLive");
                    String priorityString = (String)event.removeProperty((Object)"Priority");
                    String persistentDeliveryString = (String)event.removeProperty((Object)"PersistentDelivery");
                    if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
                        this.connector.getJmsSupport().send(producer, msg);
                    } else {
                        long ttl = 0L;
                        int priority2 = 4;
                        boolean persistent = true;
                        if (ttlString != null) {
                            ttl = Long.parseLong(ttlString);
                        }
                        if (priorityString != null) {
                            priority2 = Integer.parseInt(priorityString);
                        }
                        if (persistentDeliveryString != null) {
                            persistent = Boolean.valueOf(persistentDeliveryString);
                        }
                        this.connector.getJmsSupport().send(producer, msg, persistent, priority2, ttl);
                    }
                    if (consumer == null) break block24;
                    int timeout = event.getEndpoint().getRemoteSyncTimeout();
                    this.logger.debug((Object)("Waiting for return event for: " + timeout + " ms on " + replyTo));
                    result = consumer.receive((long)timeout);
                    if (result != null) break block25;
                    this.logger.debug((Object)"No message was returned via replyTo destination");
                    priority2 = null;
                }
                catch (Throwable throwable) {
                    JmsUtils.closeQuietly(consumer);
                    JmsUtils.closeQuietly(producer);
                    if (session != null && session != txSession) {
                        JmsUtils.closeQuietly(session);
                    }
                    throw throwable;
                }
                JmsUtils.closeQuietly(consumer);
                JmsUtils.closeQuietly(producer);
                if (session != null && session != txSession) {
                    JmsUtils.closeQuietly(session);
                }
                return priority2;
            }
            Object resultObject = JmsMessageUtils.getObjectForMessage(result);
            MuleMessage muleMessage = new MuleMessage(resultObject, null);
            JmsUtils.closeQuietly(consumer);
            JmsUtils.closeQuietly(producer);
            if (session != null && session != txSession) {
                JmsUtils.closeQuietly(session);
            }
            return muleMessage;
        }
        UMOMessage uMOMessage = null;
        JmsUtils.closeQuietly(consumer);
        JmsUtils.closeQuietly(producer);
        if (session != null && session != txSession) {
            JmsUtils.closeQuietly(session);
        }
        return uMOMessage;
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        UMOMessage message = this.dispatchMessage(event);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        javax.jms.Message message;
        MessageConsumer consumer;
        Session session;
        block6: {
            session = null;
            Destination dest = null;
            consumer = null;
            boolean topic = false;
            String resourceInfo = endpointUri.getResourceInfo();
            topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
            session = this.connector.getSession(false, topic);
            dest = this.connector.getJmsSupport().createDestination(session, endpointUri.getAddress(), topic);
            consumer = this.connector.getJmsSupport().createConsumer(session, dest);
            message = null;
            message = timeout == -1L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
            if (message != null) break block6;
            UMOMessage uMOMessage = null;
            JmsUtils.closeQuietly(consumer);
            JmsUtils.closeQuietly(session);
            return uMOMessage;
        }
        MuleMessage muleMessage = new MuleMessage(this.connector.getMessageAdapter(message));
        JmsUtils.closeQuietly(consumer);
        JmsUtils.closeQuietly(session);
        return muleMessage;
        {
            catch (Exception e) {
                UMOMessage uMOMessage;
                try {
                    this.connector.handleException(e);
                    uMOMessage = null;
                }
                catch (Throwable throwable) {
                    JmsUtils.closeQuietly(consumer);
                    JmsUtils.closeQuietly(session);
                    throw throwable;
                }
                JmsUtils.closeQuietly(consumer);
                JmsUtils.closeQuietly(session);
                return uMOMessage;
            }
        }
    }

    public synchronized Object getDelegateSession() throws UMOException {
        try {
            Session session = this.connector.getCurrentSession();
            if (session != null) {
                return session;
            }
            if (this.delegateSession == null) {
                this.delegateSession = this.connector.getSession(false, false);
            }
            return this.delegateSession;
        }
        catch (Exception e) {
            throw new MuleException(new Message("jms", 3), (Throwable)e);
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() {
        this.logger.debug((Object)"Disposing");
        JmsUtils.closeQuietly(this.delegateSession);
    }
}

