/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.impl.MuleMessage;
import org.mule.providers.ConnectException;
import org.mule.providers.SingleAttemptConnectionStrategy;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.jms.JmsClientAcknowledgeTransaction;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.JmsUtils;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.PropertiesHelper;

public class JmsMessageReceiver
extends TransactedPollingMessageReceiver {
    protected JmsConnector connector;
    protected boolean reuseConsumer;
    protected boolean reuseSession;
    protected ThreadContextLocal context = new ThreadContextLocal();
    protected long frequency;
    protected RedeliveryHandler redeliveryHandler;

    public JmsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint, new Long(0L));
        boolean topic;
        this.connector = (JmsConnector)connector;
        this.frequency = PropertiesHelper.getLongProperty((Map)endpoint.getProperties(), (Object)"frequency", (long)10000L);
        if (this.connectionStrategy instanceof SingleAttemptConnectionStrategy) {
            this.reuseConsumer = true;
            this.reuseSession = true;
        }
        this.reuseConsumer = PropertiesHelper.getBooleanProperty((Map)endpoint.getProperties(), (Object)"reuseConsumer", (boolean)this.reuseConsumer);
        this.reuseSession = PropertiesHelper.getBooleanProperty((Map)endpoint.getProperties(), (Object)"reuseSession", (boolean)this.reuseSession);
        String resourceInfo = endpoint.getEndpointURI().getResourceInfo();
        boolean bl = topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
        if (!topic && endpoint.getTransactionConfig().getFactory() != null) {
            this.receiveMessagesInTransaction = true;
        }
        try {
            this.redeliveryHandler = this.connector.createRedeliveryHandler();
            this.redeliveryHandler.setConnector(this.connector);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    public void doConnect() throws Exception {
        this.connector.connect();
    }

    public void doDisconnect() throws Exception {
        this.connector.disconnect();
    }

    public void poll() throws Exception {
        try {
            JmsThreadContext ctx = this.context.getContext();
            if (ctx.consumer == null) {
                this.createConsumer();
            }
            super.poll();
        }
        catch (Exception e) {
            this.closeConsumer(true);
            throw e;
        }
        finally {
            this.closeConsumer(false);
        }
    }

    protected List getMessages() throws Exception {
        Message message;
        JmsThreadContext ctx = this.context.getContext();
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null) {
            tx.bindResource((Object)this.connector.getConnection(), (Object)ctx.session);
        }
        if ((message = ctx.consumer.receive(this.frequency)) == null) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message received it is of type: " + message.getClass().getName()));
            if (message.getJMSDestination() != null) {
                this.logger.debug((Object)("Message received on " + message.getJMSDestination() + " (" + message.getJMSDestination().getClass().getName() + ")"));
            } else {
                this.logger.debug((Object)"Message received on unknown destination");
            }
            this.logger.debug((Object)("Message CorrelationId is: " + message.getJMSCorrelationID()));
            this.logger.debug((Object)("Jms Message Id is: " + message.getJMSMessageID()));
        }
        if (message.getJMSRedelivered()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message with correlationId: " + message.getJMSCorrelationID() + " is redelivered. handing off to Exception Handler"));
            }
            this.redeliveryHandler.handleRedelivery(message);
        }
        if (tx instanceof JmsClientAcknowledgeTransaction) {
            tx.bindResource((Object)message, null);
        }
        UMOMessageAdapter adapter = this.connector.getMessageAdapter(message);
        this.routeMessage((UMOMessage)new MuleMessage(adapter));
        return null;
    }

    protected void processMessage(Object msg) throws Exception {
    }

    protected void closeConsumer(boolean force) {
        JmsThreadContext ctx = this.context.getContext();
        if (ctx == null) {
            return;
        }
        if (force || !this.reuseSession || !this.reuseConsumer) {
            JmsUtils.closeQuietly(ctx.consumer);
            ctx.consumer = null;
        }
        if (force || !this.reuseSession) {
            JmsUtils.closeQuietly(ctx.session);
            ctx.session = null;
        }
    }

    protected void createConsumer() throws Exception {
        try {
            String durableName;
            String resourceInfo;
            JmsSupport jmsSupport = this.connector.getJmsSupport();
            JmsThreadContext ctx = this.context.getContext();
            if (ctx.session == null) {
                ctx.session = this.connector.getSession(this.endpoint);
            }
            boolean topic = (resourceInfo = this.endpoint.getEndpointURI().getResourceInfo()) != null && "topic".equalsIgnoreCase(resourceInfo);
            Destination dest = jmsSupport.createDestination(ctx.session, this.endpoint.getEndpointURI().getAddress(), topic);
            String selector = null;
            if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && dest instanceof Topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
            }
            ctx.consumer = jmsSupport.createConsumer(ctx.session, dest, selector, this.connector.isNoLocal(), durableName);
        }
        catch (JMSException e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }

    protected static class ThreadContextLocal
    extends ThreadLocal {
        protected ThreadContextLocal() {
        }

        public JmsThreadContext getContext() {
            return (JmsThreadContext)this.get();
        }

        protected Object initialValue() {
            return new JmsThreadContext();
        }
    }

    protected static class JmsThreadContext {
        public Session session;
        public MessageConsumer consumer;

        protected JmsThreadContext() {
        }
    }
}

