/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.compression.CompressionHelper;

public class JmsMessageUtils {
    private static final transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$jms$JmsMessageUtils == null ? (class$org$mule$providers$jms$JmsMessageUtils = JmsMessageUtils.class$("org.mule.providers.jms.JmsMessageUtils")) : class$org$mule$providers$jms$JmsMessageUtils));
    static /* synthetic */ Class class$org$mule$providers$jms$JmsMessageUtils;

    public static Message getMessageForObject(Object object, Session session) throws JMSException {
        if (object instanceof Message) {
            return (Message)object;
        }
        if (object instanceof String) {
            TextMessage text = session.createTextMessage((String)object);
            return text;
        }
        if (object instanceof Map) {
            MapMessage map = session.createMapMessage();
            Map.Entry entry = null;
            Map temp = (Map)object;
            Iterator i = temp.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                map.setObject(entry.getKey().toString(), entry.getValue());
            }
            return map;
        }
        if (object instanceof InputStream) {
            StreamMessage stream = session.createStreamMessage();
            InputStream temp = (InputStream)object;
            byte[] buffer = new byte[4096];
            int len = 0;
            try {
                while ((len = temp.read(buffer)) != -1) {
                    stream.writeBytes(buffer, 0, len);
                }
            }
            catch (IOException e) {
                throw new JMSException("Failed to read input stream to create a stream message: " + e);
            }
            return stream;
        }
        if (object instanceof byte[]) {
            BytesMessage bytes = session.createBytesMessage();
            byte[] buf = (byte[])object;
            for (int i = 0; i < buf.length; ++i) {
                bytes.writeByte(buf[i]);
            }
            return bytes;
        }
        if (object instanceof Serializable) {
            ObjectMessage oMsg = session.createObjectMessage();
            oMsg.setObject((Serializable)object);
            return oMsg;
        }
        throw new JMSException("Source was not a supported type, data must be Serializable, String, byte[], Map or InputStream");
    }

    public static Object getObjectForMessage(Message source) throws JMSException {
        Object result;
        block15: {
            result = null;
            try {
                if (source instanceof ObjectMessage) {
                    result = ((ObjectMessage)source).getObject();
                    break block15;
                }
                if (source instanceof MapMessage) {
                    Hashtable<String, Object> map = new Hashtable<String, Object>();
                    MapMessage m = (MapMessage)source;
                    Enumeration e = m.getMapNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        Object obj = m.getObject(name);
                        map.put(name, obj);
                    }
                    result = map;
                    break block15;
                }
                if (source instanceof BytesMessage) {
                    BytesMessage bm = (BytesMessage)source;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    int len = 0;
                    bm.reset();
                    while ((len = bm.readBytes(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    baos.flush();
                    result = baos.toByteArray();
                    baos.close();
                    if (result != null && logger.isDebugEnabled()) {
                        logger.debug((Object)("JMSToObject: extracted " + ((byte[])result).length + " bytes from JMS BytesMessage"));
                    }
                    break block15;
                }
                if (source instanceof TextMessage) {
                    result = ((TextMessage)source).getText();
                    break block15;
                }
                if (source instanceof BytesMessage) {
                    byte[] bytes = JmsMessageUtils.getBytesFromMessage(source);
                    return CompressionHelper.uncompressByteArray((byte[])bytes);
                }
                if (source instanceof StreamMessage) {
                    StreamMessage sm = (StreamMessage)source;
                    result = new Vector();
                    try {
                        Object obj = null;
                        while ((obj = sm.readObject()) != null) {
                            ((Vector)result).addElement(obj);
                        }
                        break block15;
                    }
                    catch (MessageEOFException eof) {
                        break block15;
                    }
                    catch (Exception e) {
                        throw new JMSException("Failed to extract information from JMS Stream Message: " + e);
                    }
                }
                result = source;
            }
            catch (Exception e) {
                throw new JMSException("Failed to transform message: " + e.getMessage());
            }
        }
        return result;
    }

    public static byte[] getBytesFromMessage(Message message) throws JMSException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        if (message instanceof BytesMessage) {
            int len;
            BytesMessage bMsg = (BytesMessage)message;
            bMsg.reset();
            while ((len = bMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
        } else if (message instanceof StreamMessage) {
            int len;
            StreamMessage sMsg = (StreamMessage)message;
            sMsg.reset();
            while ((len = sMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
        } else if (message instanceof ObjectMessage) {
            ObjectMessage oMsg = (ObjectMessage)message;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bs);
            os.writeObject(oMsg.getObject());
            os.flush();
            baos.write(bs.toByteArray());
            os.close();
            bs.close();
        } else if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            baos.write(tMsg.getText().getBytes());
        } else {
            throw new JMSException("Cannot get bytes from Map Message");
        }
        baos.flush();
        byte[] bytes = baos.toByteArray();
        baos.close();
        return bytes;
    }

    public static String getNameForDestination(Destination dest) throws JMSException {
        if (dest instanceof Queue) {
            return ((Queue)dest).getQueueName();
        }
        if (dest instanceof Topic) {
            return ((Topic)dest).getTopicName();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

