/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleComponent;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.providers.jms.JmsUtils;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.UMOTransformer;

public class JmsReplyToHandler
extends DefaultReplyToHandler {
    private JmsConnector connector;

    public JmsReplyToHandler(JmsConnector connector, UMOTransformer transformer) {
        super(transformer);
        this.connector = connector;
    }

    public void processReplyTo(UMOEvent event, UMOMessage returnMessage, Object replyTo) throws UMOException {
        Destination replyToDestination = null;
        MessageProducer replyToProducer = null;
        Session session = null;
        try {
            if (replyTo instanceof Destination) {
                replyToDestination = (Destination)replyTo;
            }
            if (replyToDestination == null) {
                super.processReplyTo(event, returnMessage, replyTo);
                return;
            }
            Object payload = returnMessage.getPayload();
            if (this.getTransformer() != null) {
                this.getTransformer().setEndpoint((UMOImmutableEndpoint)this.getEndpoint(event, "jms://temporary"));
                payload = this.getTransformer().transform(payload);
            }
            session = this.connector.getSession(false, replyToDestination instanceof Topic);
            javax.jms.Message replyToMessage = JmsMessageUtils.getMessageForObject(payload, session);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending jms reply to: " + replyToDestination + "(" + replyToDestination.getClass().getName() + ")"));
            }
            replyToProducer = this.connector.getJmsSupport().createProducer(session, replyToDestination);
            String ttlString = (String)event.removeProperty((Object)"TimeToLive");
            String priorityString = (String)event.removeProperty((Object)"Priority");
            String persistentDeliveryString = (String)event.removeProperty((Object)"PersistentDelivery");
            if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage);
            } else {
                long ttl = 0L;
                int priority = 4;
                boolean persistent = true;
                if (ttlString != null) {
                    ttl = Long.parseLong(ttlString);
                }
                if (priorityString != null) {
                    priority = Integer.parseInt(priorityString);
                }
                if (persistentDeliveryString != null) {
                    persistent = Boolean.valueOf(persistentDeliveryString);
                }
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, persistent, priority, ttl);
            }
            logger.info((Object)("Reply Message sent to: " + replyToDestination));
            ((MuleComponent)event.getComponent()).getStatistics().incSentReplyToEvent();
            JmsUtils.closeQuietly(replyToProducer);
        }
        catch (Exception e) {
            throw new DispatchException(new Message("jms", 8, (Object)replyToDestination), returnMessage, null, (Throwable)e);
        }
        finally {
            JmsUtils.closeQuietly(replyToProducer);
            JmsUtils.closeQuietly(session);
        }
        JmsUtils.closeQuietly(session);
    }
}

