/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.transformers;

import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.impl.RequestContext;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.PropertiesHelper;
import org.mule.util.compression.CompressionHelper;

public abstract class AbstractJmsTransformer
extends AbstractTransformer {
    public static final char REPLACEMENT_CHAR = '_';
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$jms$transformers$AbstractJmsTransformer == null ? (class$org$mule$providers$jms$transformers$AbstractJmsTransformer = AbstractJmsTransformer.class$("org.mule.providers.jms.transformers.AbstractJmsTransformer")) : class$org$mule$providers$jms$transformers$AbstractJmsTransformer));
    private Session session = null;
    static /* synthetic */ Class class$org$mule$providers$jms$transformers$AbstractJmsTransformer;

    public Object transform(Object src, Session session) throws TransformerException {
        if (session == null && this.session == null) {
            throw new TransformerException(new Message("jms", 1), (UMOTransformer)this);
        }
        if (session != null) {
            this.session = session;
        }
        if (src == null) {
            throw new TransformerException(new Message(110, (Object)"null", (Object)"Object"), (UMOTransformer)this);
        }
        Object ret = this.transform(src);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformed message from type: " + src.getClass().getName() + " to type: " + ret.getClass().getName()));
        }
        return ret;
    }

    protected javax.jms.Message transformToMessage(Object src) throws TransformerException {
        try {
            if (this.session == null || this.getEndpoint() != null) {
                this.session = (Session)this.getEndpoint().getConnector().getDispatcher("transformerSession").getDelegateSession();
            }
            javax.jms.Message msg = null;
            if (src instanceof javax.jms.Message) {
                msg = (javax.jms.Message)src;
                msg.clearProperties();
            } else {
                msg = JmsMessageUtils.getMessageForObject(src, this.session);
            }
            UMOEventContext ctx = RequestContext.getEventContext();
            if (ctx == null) {
                logger.warn((Object)"There is no current event context");
                return msg;
            }
            Map props = ctx.getProperties();
            props = PropertiesHelper.getPropertiesWithoutPrefix((Map)props, (String)"JMS");
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = entry.getKey().toString();
                if ("MULE_CORRELATION_ID".equals(key)) {
                    msg.setJMSCorrelationID(entry.getValue().toString());
                }
                msg.setObjectProperty(AbstractJmsTransformer.encodeHeader(key), entry.getValue());
            }
            return msg;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    public static String encodeHeader(String name) {
        StringBuffer sb = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) {
                    c = '_';
                }
            } else if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected Object transformFromMessage(javax.jms.Message source) throws TransformerException {
        Object result = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message type received is: " + source.getClass().getName()));
            }
            if (source instanceof BytesMessage) {
                byte[] bytes = JmsMessageUtils.getBytesFromMessage(source);
                if (CompressionHelper.isCompressed((byte[])bytes)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Message recieved is compressed");
                    }
                    result = CompressionHelper.uncompressByteArray((byte[])bytes);
                } else {
                    result = JmsMessageUtils.getObjectForMessage(source);
                }
            } else {
                result = JmsMessageUtils.getObjectForMessage(source);
            }
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
        return result;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

