/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.routing.UMOOutboundRouter;

public class UniversalSender
extends BasicHandler {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Map endpointsCache = new ConcurrentHashMap();

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean sync = true;
        Call call = (Call)msgContext.getProperty("call_object");
        if (call == null) {
            throw new IllegalStateException("The call_object property must be set on the message context to the client Call object");
        }
        if (Boolean.TRUE.equals(call.getProperty("axis.one.way"))) {
            sync = false;
        }
        UMOEvent event = (UMOEvent)call.getProperty("MULE_EVENT");
        String uri = msgContext.getStrProp("transport.url");
        UMOEndpoint endpoint = null;
        try {
            endpoint = this.lookupEndpoint(uri);
        }
        catch (UMOException e) {
            if (event != null) {
                event.getEndpoint().getConnector().handleException((Exception)((Object)e));
            } else {
                this.logger.error((Object)("Failed to dispatch soap event from Axis Universal transport: " + e.toString()), (Throwable)e);
            }
            return;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msgContext.getRequestMessage().writeTo((OutputStream)baos);
            HashMap<String, Object> props = new HashMap<String, Object>();
            Iterator iterator = msgContext.getPropertyNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (name.equals("call_object") || name.equals("wsdl.service")) continue;
                props.put(name, msgContext.getProperty(name));
            }
            props.put("SOAPAction", uri);
            MuleSession session = new MuleSession();
            MuleEvent dispatchEvent = new MuleEvent((UMOMessage)new MuleMessage((Object)baos.toByteArray(), props), endpoint, (UMOSession)session, sync);
            this.logger.info((Object)("Making Axis soap request on: " + uri));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Soap request is:\n" + baos.toString()));
            }
            if (sync) {
                dispatchEvent.getEndpoint().setRemoteSync(true);
                UMOMessage result = session.sendEvent((UMOEvent)dispatchEvent);
                if (result != null) {
                    byte[] response = result.getPayloadAsBytes();
                    Message responseMessage = new Message((Object)response);
                    msgContext.setResponseMessage(responseMessage);
                } else {
                    this.logger.warn((Object)("No response message was returned from synchronous call to: " + uri));
                }
            } else {
                dispatchEvent.getSession().dispatchEvent((UMOEvent)dispatchEvent);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to dispatch soap event from Axis Universal transport: " + e.toString()));
            if (event != null) {
                event.getEndpoint().getConnector().handleException(e);
            }
            endpoint.getConnector().handleException(e);
        }
    }

    protected UMOEndpoint lookupEndpoint(String uri) throws UMOException {
        MuleEndpoint ep;
        UMODescriptor axis = MuleManager.getInstance().getModel().getDescriptor("_axisServiceComponent");
        MuleEndpointURI endpoint = new MuleEndpointURI(uri);
        if (axis != null) {
            ep = (UMOEndpoint)this.endpointsCache.get(endpoint.getAddress());
            if (ep == null) {
                this.updateEndpointCache(axis.getOutboundRouter());
                ep = (UMOEndpoint)this.endpointsCache.get(endpoint.getAddress());
                if (ep == null) {
                    this.logger.info((Object)("Dispatch Endpoint uri: " + uri + " not found on the AxisServiceComponent. Creating the endpoint instead."));
                    ep = new MuleEndpoint(uri, false);
                } else {
                    this.logger.info((Object)("Found endpoint: " + uri + " on the Axis service component"));
                }
            } else {
                this.logger.info((Object)("Found endpoint: " + uri + " on the Axis service component"));
            }
        } else {
            ep = new MuleEndpoint(uri, false);
        }
        return ep;
    }

    private void updateEndpointCache(UMOOutboundMessageRouter router) {
        this.endpointsCache.clear();
        Iterator iterator = router.getRouters().iterator();
        while (iterator.hasNext()) {
            UMOOutboundRouter r = (UMOOutboundRouter)iterator.next();
            Iterator iterator1 = r.getEndpoints().iterator();
            while (iterator1.hasNext()) {
                UMOEndpoint endpoint = (UMOEndpoint)iterator1.next();
                this.endpointsCache.put(endpoint.getEndpointURI().getAddress(), endpoint);
            }
        }
    }
}

