/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.glue;

import electric.glue.context.ApplicationContext;
import electric.glue.context.ServiceContext;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.http.HTTP;
import electric.service.IService;
import electric.service.virtual.VirtualService;
import electric.soap.ISOAPInterceptor;
import electric.util.Context;
import electric.util.interceptor.ReceiveThreadContext;
import electric.util.interceptor.SendThreadContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.InitialisationCallback;
import org.mule.impl.MuleDescriptor;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.glue.GlueInitialisationCallback;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class GlueMessageReceiver
extends AbstractMessageReceiver {
    private boolean createServer = false;

    public GlueMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Boolean createServer) throws InitialisationException {
        super(connector, component, endpoint);
        this.createServer = createServer;
    }

    public void doConnect() throws Exception {
        try {
            Class[] interfaces = ServiceProxy.getInterfacesForComponent(this.component);
            if (interfaces.length == 0) {
                throw new InitialisationException(new Message("soap", 2, (Object)this.component.getDescriptor().getName()), (Object)this);
            }
            if (this.endpoint instanceof ImmutableMuleEndpoint && !((ImmutableMuleEndpoint)this.endpoint).isSynchronousExplicitlySet() && !this.endpoint.isSynchronous()) {
                this.logger.debug((Object)"overriding endpoint synchronicity and setting it to true. Web service requests are executed in a single thread");
                this.endpoint.setSynchronous(true);
            }
            if (this.createServer) {
                HTTP.startup((String)(this.getEndpointURI().getScheme() + "://" + this.getEndpointURI().getHost() + ":" + this.getEndpointURI().getPort()));
                this.registerContextHeaders();
            }
            VirtualService.enable();
            VirtualService vService = new VirtualService(interfaces, ServiceProxy.createGlueServiceHandler(this, this.endpoint.isSynchronous()));
            MuleDescriptor desc = (MuleDescriptor)this.component.getDescriptor();
            String serviceName = this.getEndpointURI().getPath();
            if (!serviceName.endsWith("/")) {
                serviceName = serviceName + "/";
            }
            serviceName = serviceName + this.component.getDescriptor().getName();
            desc.addInitialisationCallback((InitialisationCallback)new GlueInitialisationCallback((IService)vService, serviceName, new ServiceContext()));
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(new Message(71, (Object)e.getMessage()), (Throwable)e, (Object)this);
        }
        catch (UMOException e) {
            throw new InitialisationException(new Message("soap", 3, (Object)this.component.getDescriptor().getName()), (Throwable)e, (Object)this);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(42, (Object)"Soap Server"), (Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws Exception {
        if (this.createServer) {
            try {
                HTTP.shutdown((String)(this.getEndpointURI().getScheme() + "://" + this.getEndpointURI().getHost() + ":" + this.getEndpointURI().getPort()));
            }
            catch (IOException e) {
                throw new ConnectException((Throwable)e, (Object)this);
            }
        }
    }

    protected void registerContextHeaders() {
        ApplicationContext.addOutboundSoapRequestInterceptor((ISOAPInterceptor)new SendThreadContext("MULE_CORRELATION_ID"));
        ApplicationContext.addOutboundSoapRequestInterceptor((ISOAPInterceptor)new SendThreadContext("MULE_CORRELATION_SEQUENCE"));
        ApplicationContext.addOutboundSoapRequestInterceptor((ISOAPInterceptor)new SendThreadContext("MULE_CORRELATION_GROUP_SIZE"));
        ApplicationContext.addOutboundSoapRequestInterceptor((ISOAPInterceptor)new SendThreadContext("MULE_REPLYTO", true));
        ApplicationContext.addInboundSoapRequestInterceptor((ISOAPInterceptor)new ReceiveThreadContext("MULE_CORRELATION_ID"));
        ApplicationContext.addInboundSoapRequestInterceptor((ISOAPInterceptor)new ReceiveThreadContext("MULE_CORRELATION_SEQUENCE"));
        ApplicationContext.addInboundSoapRequestInterceptor((ISOAPInterceptor)new ReceiveThreadContext("MULE_CORRELATION_GROUP_SIZE"));
        ApplicationContext.addInboundSoapRequestInterceptor((ISOAPInterceptor)new ReceiveThreadContext("MULE_REPLYTO", true));
    }

    protected void doDispose() {
        try {
            Registry.unpublish((String)this.component.getDescriptor().getName());
        }
        catch (RegistryException e) {
            this.logger.error((Object)new Message(48, (Object)this.component.getDescriptor().getName(), (Object)this.endpoint.getEndpointURI()), (Throwable)e);
        }
    }

    protected Context getContext() {
        Context c = null;
        if (this.endpoint.getProperties() != null && (c = (Context)this.endpoint.getProperties().get("glueContext")) == null && this.endpoint.getProperties().size() > 0) {
            c = new Context();
            Iterator iterator = this.endpoint.getProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                c.addProperty(entry.getKey().toString(), entry.getValue());
            }
        }
        return c;
    }
}

