/*
 * Decompiled with CFR 0.152.
 */
package name.bychkov.junit5;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import name.bychkov.junit5.CheckConstructor;
import name.bychkov.junit5.CheckField;
import name.bychkov.junit5.CheckFields;
import name.bychkov.junit5.CheckKey;
import name.bychkov.junit5.CheckKeys;
import name.bychkov.junit5.CheckMethod;
import name.bychkov.junit5.CheckResourceBundle;
import name.bychkov.junit5.CheckSerializable;

@SupportedAnnotationTypes(value={"name.bychkov.junit5.CheckConstructor", "name.bychkov.junit5.CheckConstructor.List", "name.bychkov.junit5.CheckField", "name.bychkov.junit5.CheckField.List", "name.bychkov.junit5.CheckFields", "name.bychkov.junit5.CheckFields.List", "name.bychkov.junit5.CheckKey", "name.bychkov.junit5.CheckKey.List", "name.bychkov.junit5.CheckKeys", "name.bychkov.junit5.CheckKeys.List", "name.bychkov.junit5.CheckMethod", "name.bychkov.junit5.CheckMethod.List", "name.bychkov.junit5.CheckResourceBundle", "name.bychkov.junit5.CheckResourceBundle.List", "name.bychkov.junit5.CheckSerializable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CheckAnnotationProcessor
extends AbstractProcessor {
    private static final Logger LOG = Logger.getLogger(CheckAnnotationProcessor.class.getSimpleName());
    static final String REFLECTIONS_DATA_FILE_LOCATION = "META-INF/maven/name.bychkov/junit5-extensions/reflections-data.dat";
    static final String RESOURCE_BUNDLES_DATA_FILE_LOCATION = "META-INF/maven/name.bychkov/junit5-extensions/resource-bundles-data.dat";
    static final String SERIALIZABLE_DATA_FILE_LOCATION = "META-INF/maven/name.bychkov/junit5-extensions/serializable-data.dat";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.isAlreadyProcessed(REFLECTIONS_DATA_FILE_LOCATION)) {
            try {
                HashSet<Serializable> reflectionsAnnotationItems = new HashSet<Serializable>();
                this.processCheckAnnotations(roundEnv, CheckConstructor.List.class, CheckConstructor.class, reflectionsAnnotationItems);
                this.processCheckAnnotations(roundEnv, CheckMethod.List.class, CheckMethod.class, reflectionsAnnotationItems);
                this.processCheckAnnotations(roundEnv, CheckField.List.class, CheckField.class, reflectionsAnnotationItems);
                this.processCheckAnnotations(roundEnv, CheckFields.List.class, CheckFields.class, reflectionsAnnotationItems);
                this.writeFile(REFLECTIONS_DATA_FILE_LOCATION, reflectionsAnnotationItems);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e, () -> "Error has acquired while reflections annotations processing");
            }
        }
        if (!this.isAlreadyProcessed(RESOURCE_BUNDLES_DATA_FILE_LOCATION)) {
            try {
                HashSet<Serializable> resourceBundlesAnnotationItems = new HashSet<Serializable>();
                this.processCheckAnnotations(roundEnv, CheckKey.List.class, CheckKey.class, resourceBundlesAnnotationItems);
                this.processCheckAnnotations(roundEnv, CheckKeys.List.class, CheckKeys.class, resourceBundlesAnnotationItems);
                this.processCheckAnnotations(roundEnv, CheckResourceBundle.List.class, CheckResourceBundle.class, resourceBundlesAnnotationItems);
                this.writeFile(RESOURCE_BUNDLES_DATA_FILE_LOCATION, resourceBundlesAnnotationItems);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e, () -> "Error has acquired while resource bundles annotations processing");
            }
        }
        if (!this.isAlreadyProcessed(SERIALIZABLE_DATA_FILE_LOCATION)) {
            try {
                HashSet<Serializable> serializableAnnotationItems = new HashSet<Serializable>();
                this.processCheckAnnotations(roundEnv, CheckSerializable.List.class, CheckSerializable.class, serializableAnnotationItems);
                this.writeFile(SERIALIZABLE_DATA_FILE_LOCATION, serializableAnnotationItems);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e, () -> "Error has acquired while serializable annotation processing");
            }
        }
        return true;
    }

    private boolean isAlreadyProcessed(String filename) {
        try {
            FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", filename);
            return file.getLastModified() > 0L;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void writeFile(String filename, Set<Serializable> annotationItems) {
        if (annotationItems == null || annotationItems.isEmpty()) {
            return;
        }
        try {
            FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, new Element[0]);
            try (OutputStream writer = fileObject.openOutputStream();
                 ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                ObjectOutputStream out = null;
                out = new ObjectOutputStream(bos);
                out.writeObject(annotationItems);
                out.flush();
                byte[] bytes = bos.toByteArray();
                writer.write(bytes);
            }
        }
        catch (FilerException e) {
            LOG.log(Level.FINER, e, () -> "File " + filename + " already exists. Rewriting file is impossible");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e, () -> "Error has acquired while File " + filename + " writing");
        }
    }

    private void processCheckAnnotations(RoundEnvironment roundEnv, Class<? extends Annotation> containerAnnotationClass, Class<? extends Annotation> annotationClass, Collection<Serializable> annotationItems) {
        Set<? extends Element> containerElements = roundEnv.getElementsAnnotatedWith(containerAnnotationClass);
        for (Element element : containerElements) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!containerAnnotationClass.getCanonicalName().equals(annotationMirror.getAnnotationType().toString())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> containerAnnotationEntry : annotationMirror.getElementValues().entrySet()) {
                    String key = containerAnnotationEntry.getKey().getSimpleName().toString();
                    if (!"value".equals(key) || !(containerAnnotationEntry.getValue().getValue() instanceof List)) continue;
                    List values = (List)containerAnnotationEntry.getValue().getValue();
                    values.stream().filter(AnnotationMirror.class::isInstance).map(AnnotationMirror.class::cast).forEach(annotation -> this.processCheckAnnotation((AnnotationMirror)annotation, element, annotationItems));
                }
            }
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(annotationClass);
        for (Element element : elements) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationClass.getCanonicalName().equals(annotationMirror.getAnnotationType().toString())) continue;
                this.processCheckAnnotation(annotationMirror, element, annotationItems);
            }
        }
    }

    private void processCheckAnnotation(AnnotationMirror annotation, Element element, Collection<Serializable> annotationItems) {
        Serializable object = null;
        if (CheckField.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinField(annotation, element);
        } else if (CheckFields.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinFields(annotation, element);
        } else if (CheckMethod.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinMethod(annotation, element);
        } else if (CheckConstructor.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinConstructor(annotation, element);
        } else if (CheckKey.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinKey(annotation, element);
        } else if (CheckKeys.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinKeys(annotation, element);
        } else if (CheckResourceBundle.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinResourceBundle(annotation, element);
        } else if (CheckSerializable.class.getCanonicalName().equals(annotation.getAnnotationType().toString())) {
            object = this.joinSerializable(annotation, element);
        }
        if (object != null) {
            annotationItems.add(object);
        }
    }

    private Map<String, Object> readAnnotationParameters(AnnotationMirror annotation) {
        HashMap<String, Object> annotationParameters = new HashMap<String, Object>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> annotationEntry : annotation.getElementValues().entrySet()) {
            annotationParameters.put(annotationEntry.getKey().getSimpleName().toString(), annotationEntry.getValue().getValue());
        }
        return annotationParameters;
    }

    private CheckConstructorObject joinConstructor(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckConstructorObject object = new CheckConstructorObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.targetClass = this.getAnnotationRequiredAttribute(CheckConstructor.class, annotationParameters, "targetClass");
        object.parameters = this.getAnnotationOptionalArrayAttribute(annotationParameters, "parameters", new String[0]);
        object.annotatedElement = this.getAnnotatedElement(element, object.parameters);
        return object;
    }

    private CheckKeyObject joinKey(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckKeyObject object = new CheckKeyObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.baseName = this.getAnnotationAttributeOrConstantValue(CheckKey.class, element, annotationParameters, "baseName");
        object.value = this.getAnnotationAttributeOrConstantValue(CheckKey.class, element, annotationParameters, "value");
        object.locale = this.getAnnotationOptionalAttribute(annotationParameters, "locale");
        object.annotatedElement = this.getAnnotatedElement(element, new String[0]);
        return object;
    }

    private String getAnnotationAttributeOrConstantValue(Class<? extends Annotation> annotationClass, Element element, Map<String, Object> annotationParameters, String attribute) {
        String constantValue = null;
        if (element instanceof Symbol.VarSymbol) {
            constantValue = Objects.toString(((Symbol.VarSymbol)element).getConstValue(), null);
        }
        if (constantValue != null) {
            String value = this.getAnnotationOptionalAttribute(annotationParameters, attribute);
            return value != null ? value : constantValue;
        }
        return this.getAnnotationRequiredAttribute(annotationClass, annotationParameters, attribute);
    }

    private CheckKeysObject joinKeys(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckKeysObject object = new CheckKeysObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.baseName = this.getAnnotationAttributeOrConstantValue(CheckKeys.class, element, annotationParameters, "baseName");
        object.values = this.getAnnotationRequiredArrayAttribute(CheckKeys.class, annotationParameters, "values");
        object.locale = this.getAnnotationOptionalAttribute(annotationParameters, "locale");
        object.annotatedElement = this.getAnnotatedElement(element, new String[0]);
        return object;
    }

    private CheckSerializableObject joinSerializable(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckSerializableObject object = new CheckSerializableObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.targetPackage = this.getAnnotationOptionalAttribute(annotationParameters, "targetPackage");
        object.excludes = this.getAnnotationOptionalArrayAttribute(annotationParameters, "excludes", new String[0]);
        object.annotatedElement = this.getAnnotatedElement(element, new String[0]);
        return object;
    }

    private CheckResourceBundleObject joinResourceBundle(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckResourceBundleObject object = new CheckResourceBundleObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.baseName = this.getAnnotationAttributeOrConstantValue(CheckResourceBundle.class, element, annotationParameters, "baseName");
        object.locales = this.getAnnotationRequiredArrayAttribute(CheckResourceBundle.class, annotationParameters, "locales");
        object.annotatedElement = this.getAnnotatedElement(element, new String[0]);
        return object;
    }

    private String[] getAnnotationOptionalArrayAttribute(Map<String, Object> annotationParameters, String attribute, String[] defaultValue) {
        List list = (List)annotationParameters.get(attribute);
        if (list == null) {
            return defaultValue;
        }
        return (String[])list.stream().map(AnnotationValue::getValue).map(Object::toString).toArray(String[]::new);
    }

    private String[] getAnnotationRequiredArrayAttribute(Class<? extends Annotation> annotationClass, Map<String, Object> annotationParameters, String attribute) {
        return (String[])Optional.ofNullable(annotationParameters.get(attribute)).map(o -> (List)o).map(Collection::stream).orElseThrow(() -> new RuntimeException(String.format("Annotation @%s must define the attribute %s", annotationClass.getSimpleName(), attribute))).map(AnnotationValue::getValue).map(Object::toString).toArray(String[]::new);
    }

    private String getAnnotationRequiredAttribute(Class<? extends Annotation> annotationClass, Map<String, Object> annotationParameters, String attribute) {
        Object attributeValue = Optional.ofNullable(annotationParameters.get(attribute)).orElseThrow(() -> new RuntimeException(String.format("Annotation @%s must define the attribute %s", annotationClass.getSimpleName(), attribute)));
        if (attributeValue instanceof Type.ClassType) {
            return this.getType((Type.ClassType)attributeValue);
        }
        return attributeValue.toString();
    }

    private String getType(Type.ClassType klass) {
        String type = klass.tsym.toString();
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(type);
        if (typeElement != null) {
            type = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
        }
        return type;
    }

    private String getAnnotationOptionalAttribute(Map<String, Object> annotationParameters, String attribute) {
        return Optional.ofNullable(annotationParameters.get(attribute)).map(Object::toString).orElse(null);
    }

    private CheckFieldObject joinField(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckFieldObject object = new CheckFieldObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.targetClass = this.getAnnotationRequiredAttribute(CheckField.class, annotationParameters, "targetClass");
        object.annotatedElement = this.getAnnotatedElement(element, new String[0]);
        object.value = this.getAnnotationAttributeOrConstantValue(CheckField.class, element, annotationParameters, "value");
        object.type = this.getAnnotationOptionalAttribute(annotationParameters, "type");
        return object;
    }

    private CheckFieldsObject joinFields(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckFieldsObject object = new CheckFieldsObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.targetClass = this.getAnnotationRequiredAttribute(CheckFields.class, annotationParameters, "targetClass");
        object.annotatedElement = this.getAnnotatedElement(element, new String[0]);
        object.values = this.getAnnotationRequiredArrayAttribute(CheckFields.class, annotationParameters, "values");
        return object;
    }

    private CheckMethodObject joinMethod(AnnotationMirror annotation, Element element) {
        Map<String, Object> annotationParameters = this.readAnnotationParameters(annotation);
        CheckMethodObject object = new CheckMethodObject();
        object.message = this.getAnnotationOptionalAttribute(annotationParameters, "message");
        object.targetClass = this.getAnnotationRequiredAttribute(CheckMethod.class, annotationParameters, "targetClass");
        object.returnType = this.getAnnotationOptionalAttribute(annotationParameters, "returnType");
        object.parameters = this.getAnnotationOptionalArrayAttribute(annotationParameters, "parameters", null);
        object.annotatedElement = this.getAnnotatedElement(element, object.parameters);
        object.value = this.getAnnotationAttributeOrConstantValue(CheckMethod.class, element, annotationParameters, "value");
        return object;
    }

    private String getAnnotatedElement(Element element, String[] parameterClassNames) {
        switch (element.getKind()) {
            case METHOD: {
                return element.getEnclosingElement().toString() + "." + element.toString();
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                return element.getEnclosingElement().toString() + "." + element.toString();
            }
            case CONSTRUCTOR: {
                return element.getEnclosingElement().toString() + "." + element.getEnclosingElement().getSimpleName() + (parameterClassNames != null ? "(" + String.join((CharSequence)", ", parameterClassNames) + ")" : "");
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case PACKAGE: {
                return element.toString();
            }
        }
        return element.toString();
    }

    static class CheckMethodObject
    implements Serializable {
        private static final long serialVersionUID = -7087204752344865404L;
        String annotatedElement;
        String targetClass;
        String returnType;
        String value;
        String[] parameters;
        String message;

        CheckMethodObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.parameters);
            result = 31 * result + Objects.hash(this.annotatedElement, this.message, this.returnType, this.targetClass, this.value);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckMethodObject other = (CheckMethodObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Objects.equals(this.message, other.message) && Arrays.equals(this.parameters, other.parameters) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.targetClass, other.targetClass) && Objects.equals(this.value, other.value);
        }
    }

    static class CheckFieldsObject
    implements Serializable {
        private static final long serialVersionUID = 1586354720019392961L;
        String annotatedElement;
        String targetClass;
        String[] values;
        String message;

        CheckFieldsObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.values);
            result = 31 * result + Objects.hash(this.annotatedElement, this.message, this.targetClass);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckFieldsObject other = (CheckFieldsObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Objects.equals(this.message, other.message) && Objects.equals(this.targetClass, other.targetClass) && Arrays.equals(this.values, other.values);
        }
    }

    static class CheckFieldObject
    implements Serializable {
        private static final long serialVersionUID = 223641553109037040L;
        String annotatedElement;
        String targetClass;
        String value;
        String type;
        String message;

        CheckFieldObject() {
        }

        public int hashCode() {
            return Objects.hash(this.annotatedElement, this.message, this.targetClass, this.type, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckFieldObject other = (CheckFieldObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Objects.equals(this.message, other.message) && Objects.equals(this.targetClass, other.targetClass) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }
    }

    static class CheckResourceBundleObject
    implements Serializable {
        private static final long serialVersionUID = -6200874311724044569L;
        String annotatedElement;
        String baseName;
        String[] locales;
        String message;

        CheckResourceBundleObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.locales);
            result = 31 * result + Objects.hash(this.annotatedElement, this.baseName, this.message);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckResourceBundleObject other = (CheckResourceBundleObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Objects.equals(this.baseName, other.baseName) && Arrays.equals(this.locales, other.locales) && Objects.equals(this.message, other.message);
        }
    }

    static class CheckSerializableObject
    implements Serializable {
        private static final long serialVersionUID = -6824914762264876265L;
        String annotatedElement;
        String targetPackage;
        String[] excludes;
        String message;

        CheckSerializableObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.excludes);
            result = 31 * result + Objects.hash(this.annotatedElement, this.message, this.targetPackage);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckSerializableObject other = (CheckSerializableObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Arrays.equals(this.excludes, other.excludes) && Objects.equals(this.message, other.message) && Objects.equals(this.targetPackage, other.targetPackage);
        }
    }

    static class CheckKeysObject
    implements Serializable {
        private static final long serialVersionUID = 8760310613081028956L;
        String annotatedElement;
        String baseName;
        String[] values;
        String locale;
        String message;

        CheckKeysObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.values);
            result = 31 * result + Objects.hash(this.annotatedElement, this.baseName, this.locale, this.message);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckKeysObject other = (CheckKeysObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Objects.equals(this.baseName, other.baseName) && Objects.equals(this.locale, other.locale) && Objects.equals(this.message, other.message) && Arrays.equals(this.values, other.values);
        }
    }

    static class CheckKeyObject
    implements Serializable {
        private static final long serialVersionUID = -4466248997083873233L;
        String annotatedElement;
        String baseName;
        String value;
        String locale;
        String message;

        CheckKeyObject() {
        }

        public int hashCode() {
            return Objects.hash(this.annotatedElement, this.baseName, this.locale, this.message, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckKeyObject other = (CheckKeyObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Objects.equals(this.baseName, other.baseName) && Objects.equals(this.locale, other.locale) && Objects.equals(this.message, other.message) && Objects.equals(this.value, other.value);
        }
    }

    static class CheckConstructorObject
    implements Serializable {
        private static final long serialVersionUID = 3827794109493518403L;
        String annotatedElement;
        String targetClass;
        String[] parameters;
        String message;

        CheckConstructorObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.parameters);
            result = 31 * result + Objects.hash(this.annotatedElement, this.message, this.targetClass);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckConstructorObject other = (CheckConstructorObject)obj;
            return Objects.equals(this.annotatedElement, other.annotatedElement) && Objects.equals(this.message, other.message) && Arrays.equals(this.parameters, other.parameters) && Objects.equals(this.targetClass, other.targetClass);
        }
    }
}

