package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.CheckDependencyUpdatesPlugin.Companion.CHECK_DEPENDENCY_UPDATES_TASK_NAME
import name.remal.building.gradle_plugins.CheckGradleUpdatesPlugin.Companion.CHECK_GRADLE_UPDATES_TASK_NAME
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.utils.applyPlugin
import name.remal.building.gradle_plugins.utils.get
import org.gradle.api.Project
import org.gradle.api.plugins.HelpTasksPlugin

@API
class CheckUpdatesPlugin : ProjectPlugin() {

    companion object {
        const val CHECK_UPDATES_TASK_NAME = "checkUpdates"
    }

    override fun apply(project: Project) {
        val checkUpdates = project.tasks.create(CHECK_UPDATES_TASK_NAME) {
            it.group = HelpTasksPlugin.HELP_GROUP
        }

        project.applyPlugin(CheckGradleUpdatesPlugin::class.java) { checkUpdates.dependsOn(project.tasks[CHECK_GRADLE_UPDATES_TASK_NAME]) }
        project.applyPlugin(CheckDependencyUpdatesPlugin::class.java) { checkUpdates.dependsOn(project.tasks[CHECK_DEPENDENCY_UPDATES_TASK_NAME]) }
    }

}
