package name.remal.building.gradle_plugins

import groovy.transform.CompileStatic
import name.remal.building.gradle_plugins.artifact.ArtifactsCacheCleanerPlugin
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import org.gradle.api.Project
import org.jetbrains.annotations.NotNull

import static name.remal.building.gradle_plugins.dsl.ProjectUtilsKt.isBuildSrcProject
import static name.remal.building.gradle_plugins.dsl.ProjectUtilsKt.isRootProject
import static name.remal.building.gradle_plugins.utils.PluginIds.ECLIPSE_PLUGIN_ID
import static name.remal.building.gradle_plugins.utils.PluginIds.IDEA_PLUGIN_ID

@CompileStatic
class DefaultPluginsPlugin extends ProjectPlugin {

    @Override
    void apply(@NotNull Project project) {
        project.pluginManager.with {
            if (isRootProject(project)) {
                apply(IDEA_PLUGIN_ID)
                apply(ECLIPSE_PLUGIN_ID)
                apply(ArtifactsCacheCleanerPlugin.class)
                apply(CheckUpdatesPlugin.class)

                if (isBuildSrcProject(project)) {
                    apply(MergedCoverageMetricsPlugin.class)
                }
            }

            apply(IdeaSettingsPlugin.class)
            apply(EclipseSettingsPlugin.class)

            apply(OSDetectorPlugin.class)
            apply(CommonSettingsPlugin.class)
            apply(DynamicDependenciesPlugin.class)
            apply(DownloadTaskSettingPlugin.class)
            apply(VersionSelectionsPlugin.class)

            apply(JavaSettingsPlugin.class)
            apply(AptPlugin.class)
            apply(KotlinSettingsPlugin.class)
            apply(GroovySettingsPlugin.class)

            apply(JUnitPlatformSettingsPlugin.class)

            apply(FindbugsSettingsPlugin.class)
            apply(QualitySettingsPlugin.class)

            apply(SigningSettingsPlugin.class)
            apply(PublishSettingsPlugin.class)
            apply(BintraySettingsPlugin.class)

            apply(ClassesRelocationPlugin.class)
            apply(MergeJavaResourcesPlugin.class)
            apply(AgentPlugin.class)
        }
    }

}
