package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.dsl.isZipFile
import name.remal.building.gradle_plugins.dsl.java
import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.FINDBUGS_PLUGIN_ID
import name.remal.building.gradle_plugins.utils.PluginIds.QUALITY_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.api.plugins.quality.FindBugs
import org.gradle.api.plugins.quality.FindBugsExtension
import org.gradle.api.tasks.SourceSet

@API
class FindbugsSettingsPlugin : ProjectPlugin() {

    companion object {
        const val FINDBUGS_VERSION_PROPERTY = "findbugs.version"
    }

    override fun apply(project: Project) {
        project.withPlugin(FINDBUGS_PLUGIN_ID) {
            project.afterEvaluateOrdered {
                val findbugs = project[FindBugsExtension::class.java]
                if (null == findbugs.toolVersion) {
                    if (project.hasProperty(FINDBUGS_VERSION_PROPERTY)) {
                        findbugs.toolVersion = project.property(FINDBUGS_VERSION_PROPERTY)?.toString()
                    }
                }
            }

            project.configureTasks(FindBugs::class.java) { task ->
                task.classpath = task.classpath?.run { filter { it.isDirectory || isZipFile(it) } }
                task.classes = task.classes?.run { filter { it.name.endsWith(".class") } }
            }

            project.java.sourceSets.configure { sourceSet ->
                project.tasks[FindBugs::class.java].configure(sourceSet.findbugsTaskName) { task ->
                    task.doFirst {
                        val classes = task.classes
                        if (null == classes || classes.isEmpty) {
                            task.classes = sourceSet.output.classesDirs
                        }
                    }
                }
            }

            project.applyPluginIfExists(QUALITY_PLUGIN_ID)
        }
    }

}


@Suppress("NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS")
val SourceSet.findbugsTaskName: String
    get() = this.getTaskName("findbugs", null)
