package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.gitlab_tools.GitlabCreateTagTask
import name.remal.building.gradle_plugins.gitlab_tools.GitlabToolsExtension
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import org.gradle.api.Project

@API
class GitlabToolsPlugin : ProjectPlugin() {

    companion object {
        const val GITLAB_TOOLS_EXTENSION_NAME = "gitlabTools"
        const val GITLAB_CREATE_TAG_TASK_NAME = "gitlabCreateTag"
    }

    override fun apply(project: Project) {
        project.extensions.create(GITLAB_TOOLS_EXTENSION_NAME, GitlabToolsExtension::class.java)
        project.tasks.create(GITLAB_CREATE_TAG_TASK_NAME, GitlabCreateTagTask::class.java)
    }

}
