package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.dsl.compileGroovyTaskName
import name.remal.building.gradle_plugins.dsl.compileKotlinTaskName
import name.remal.building.gradle_plugins.dsl.java
import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.GROOVY_PLUGIN_ID
import name.remal.building.gradle_plugins.utils.PluginIds.KOTLIN_PLUGIN_IDS
import org.gradle.api.Project
import org.gradle.api.tasks.compile.AbstractCompile
import org.gradle.api.tasks.compile.GroovyCompile

@API
class GroovySettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.withPlugins(GROOVY_PLUGIN_ID) {
            setupGroovyCompile(project)
        }

        project.withPlugins(GROOVY_PLUGIN_ID, KOTLIN_PLUGIN_IDS) {
            project.afterEvaluateOrdered {
                project.java.sourceSets.configure { sourceSet ->
                    val compileTasks = project.tasks[AbstractCompile::class.java]
                    val compileGroovy = compileTasks.findByName(sourceSet.compileGroovyTaskName) ?: return@configure
                    val compileKotlin = compileTasks.findByName(sourceSet.compileKotlinTaskName) ?: return@configure
                    compileGroovy.classpath = compileGroovy.classpath + project.files(compileKotlin.destinationDir)
                }
            }
        }
    }

    private fun setupGroovyCompile(project: Project) {
        project.configureTasks(GroovyCompile::class.java) {
            it.options.apply {
                isDebug = true
                debugOptions.debugLevel = "source,lines,vars"
                isDeprecation = true
                encoding = encoding ?: Constants.ENCODING
            }
        }
    }

}
