package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.PluginIds.IDEA_PLUGIN_ID
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.utils.get
import name.remal.building.gradle_plugins.utils.withPlugin
import org.gradle.api.Project
import org.gradle.plugins.ide.idea.model.IdeaModel

@API
class IdeaSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.withPlugin(IDEA_PLUGIN_ID) {
            setupDependenciesResolution(project)
        }
    }

    private fun setupDependenciesResolution(project: Project) {
        project[IdeaModel::class.java].module?.apply {
            isDownloadJavadoc = true
            isDownloadSources = true
        }
    }

}
