package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.*
import org.gradle.api.Project
import org.jetbrains.kotlin.gradle.plugin.KaptExtension
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

@API
class KotlinSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.withPlugin(KOTLIN_PLUGIN_IDS) { setupKotlinJvm(project) }
        project.withPlugin(KOTLIN2JS_PLUGIN_IDS) { setupKotlinJs(project) }
        project.withPlugin(KOTLIN_KAPT_PLUGIN_IDS) { setupKapt(project) }
    }

    private fun setupKotlinJvm(project: Project) {
        project.applyPluginIfExists(KOTLIN_ALL_OPEN_PLUGIN_IDS)
        project.applyPluginIfExists(KOTLIN_NOARG_PLUGIN_IDS)
        project.applyPluginIfExists(KOTLIN_SPRING_PLUGIN_IDS)
        project.applyPluginIfExists(KOTLIN_JPA_PLUGIN_IDS)

        project.tasks.configure(KotlinCompile::class.java) {
            val options = it.kotlinOptions
            options.jvmTarget = "1.8"
            options.javaParameters = true
        }
    }

    private fun setupKotlinJs(project: Project) {
        project.tasks.configure(Kotlin2JsCompile::class.java) {
            val options = it.kotlinOptions
            options.metaInfo = true
            options.sourceMap = true
            options.moduleKind = "umd"
            options.noStdlib = false
        }
    }

    private fun setupKapt(project: Project) {
        project[KaptExtension::class.java].let { kapt ->
            kapt.correctErrorTypes = true
        }
    }

}
