package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.utils.*
import name.remal.building.gradle_plugins.utils.PluginIds.SIGNING_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.api.artifacts.Dependency.ARCHIVES_CONFIGURATION
import org.gradle.api.plugins.ExtraPropertiesExtension
import org.gradle.plugins.signing.SigningExtension

@API
class SigningSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.withPlugin(SIGNING_PLUGIN_ID) {
            project.afterEvaluateOrdered(Int.MAX_VALUE) {
                if (!project.properties["signing.keyId"]?.toString().isNullOrEmpty()) return@afterEvaluateOrdered
                if (!project.properties["signing.secretKeyRingFile"]?.toString().isNullOrEmpty()) return@afterEvaluateOrdered

                project[ExtraPropertiesExtension::class.java].let { ext ->
                    val secretKeyRingResource = SigningSettingsPlugin::class.java.`package`.name.replace('.', '/') + "/signing_settings/name.remal.gradle-plugins.private.gpg"
                    val secretKeyRingFile = forResourceStream(secretKeyRingResource) { secretKeyRingStream ->
                        val secretKeyRingFile = createTempFile(secretKeyRingResource.substringAfterLast('/') + '.', ".tmp")
                        secretKeyRingFile.deleteOnExit()

                        secretKeyRingFile.outputStream().use {
                            secretKeyRingStream.copyTo(it)
                        }

                        return@forResourceStream secretKeyRingFile
                    }

                    ext["signing.keyId"] = "80B5C3C8"
                    ext["signing.password"] = "0123456789"
                    ext["signing.secretKeyRingFile"] = secretKeyRingFile.absolutePath
                }
            }

            project[SigningExtension::class.java].apply {
                sign(project.configurations[ARCHIVES_CONFIGURATION])
            }
        }
    }

}
