package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.dsl.isVersionSet
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.utils.getEnvOrNull
import name.remal.building.gradle_plugins.vcs.forVCSService
import org.gradle.api.Project
import org.slf4j.LoggerFactory

@API
class VCSAutoVersionPlugin : ProjectPlugin() {

    companion object {
        @JvmStatic private val logger = LoggerFactory.getLogger(VCSAutoVersionPlugin::class.java)
        const val VCS_AUTO_VERSION_EXTENSION_NAME = "vcsAutoVersion"
    }

    override fun apply(project: Project) {
        if (project.isVersionSet) {
            logger.warn("{}: Project version will be redefined", VCSAutoVersionPlugin::class.java.simpleName)
        }

        val vcsAutoVersion = project.extensions.create(VCS_AUTO_VERSION_EXTENSION_NAME, VCSAutoVersionExtension::class.java)

        project.forVCSService { vcsService ->
            val vcsVersion = vcsService.calculateVersion(vcsAutoVersion)
            vcsVersion.version.let { version ->
                project.version = buildString {
                    append(version.toString())
                    if (!version.suffix.isNullOrEmpty()) append("-SNAPSHOT")
                }

                logger.info("{}: Project version: {}", VCSAutoVersionPlugin::class.java.simpleName, project.version)
            }
        }
    }

}


@API
class VCSAutoVersionExtension {

    var mainBranchName: String = "master"

    var versionTagPrefixes: MutableSet<String> = mutableSetOf("version", "ver", "v")

    var overwriteBranchName: String? = if (getEnvOrNull("CI_COMMIT_TAG").isNullOrEmpty()) {
        getEnvOrNull("CI_COMMIT_REF_NAME")
    } else {
        null
    }

}
