package name.remal.building.gradle_plugins

import name.remal.building.gradle_plugins.dsl.Version
import name.remal.building.gradle_plugins.dsl.Version.Companion.ofLocalDateTime
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.vcs.getVCSService
import org.gradle.api.Project
import java.time.LocalDateTime

@API
class VCSInfoPlugin : ProjectPlugin() {

    companion object {
        const val VCS_AUTO_VERSION_EXTENSION_NAME = "vcsInfo"
    }

    override fun apply(project: Project) {
        project.extensions.create(VCS_AUTO_VERSION_EXTENSION_NAME, VCSInfo::class.java, project)
    }

}


@API
class VCSInfo(project: Project) {

    val currentCommitDateTime: LocalDateTime?
    val currentCommitUTCDateTimeAsVersion: Version?

    init {
        val vcsService = project.getVCSService()
        currentCommitDateTime = vcsService?.getCurrentCommitDateTime()
        currentCommitUTCDateTimeAsVersion = currentCommitDateTime?.let(::ofLocalDateTime)
    }

}
