package name.remal.building.gradle_plugins.artifact

import name.remal.building.gradle_plugins.API
import name.remal.building.gradle_plugins.utils.ProjectPlugin
import name.remal.building.gradle_plugins.utils.afterEvaluateOrdered
import name.remal.building.gradle_plugins.utils.applyPlugin
import name.remal.building.gradle_plugins.utils.doLastOrdered
import org.gradle.api.Project
import org.gradle.api.file.FileTree
import org.gradle.api.tasks.Copy
import org.gradle.api.tasks.bundling.AbstractArchiveTask
import org.gradle.api.tasks.compile.AbstractCompile

@API
class ArtifactsCacheCleanerPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        project.subprojects { it.applyPlugin(ArtifactsCacheCleanerPlugin::class.java) }

        project.afterEvaluateOrdered {
            project.tasks.all { task ->
                task.doLastOrdered {
                    when (task) {
                        is AbstractCompile -> ArtifactsCache.invalidate(task.destinationDir)
                        is AbstractArchiveTask -> ArtifactsCache.invalidate(task.archivePath)
                        is Copy -> ArtifactsCache.invalidate(task.destinationDir)
                        else -> task.outputs.files.let { outputFiles ->
                            if (outputFiles !is FileTree) {
                                outputFiles.files.forEach(ArtifactsCache::invalidate)
                            }
                        }
                    }
                }
            }
        }
    }

}
