package name.remal.building.gradle_plugins.dsl

import name.remal.building.gradle_plugins.utils.get
import name.remal.building.gradle_plugins.utils.getOrCreate
import org.gradle.api.Project
import org.gradle.api.tasks.SourceSet.MAIN_SOURCE_SET_NAME
import org.gradle.api.tasks.bundling.AbstractArchiveTask
import org.gradle.api.tasks.bundling.Jar

val SOURCES_JAR_TASK_NAME = "sourcesJar"

fun Project.getOrCreateSourcesJarTask(): AbstractArchiveTask {
    val task = project.tasks.getOrCreate(SOURCES_JAR_TASK_NAME, Jar::class.java) {
        it.classifier = "sources"
        it.from(project.java.sourceSets[MAIN_SOURCE_SET_NAME].allSource)
    }
    return task as AbstractArchiveTask
}
