package name.remal.building.gradle_plugins.dsl

import name.remal.building.gradle_plugins.utils.get
import org.gradle.api.internal.HasConvention
import org.gradle.api.tasks.SourceSet
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet

val SourceSet.kotlin: KotlinSourceSet get() = (this as HasConvention).convention["kotlin"]

val SourceSet.compileKotlinTaskName: String get() = this.getCompileTaskName("Kotlin")
val SourceSet.compileKotlin2JSTaskName: String get() = this.getCompileTaskName("Kotlin2Js")
val SourceSet.generateKotlinSourcesTaskName: String get() = this.getTaskName("generate", "KotlinSources")
