package name.remal.building.gradle_plugins.dsl

import org.gradle.api.Project
import org.gradle.initialization.DefaultSettings.DEFAULT_BUILD_SRC_DIR

val Project.isRootProject: Boolean get() = null == this.parent

private val Project.defaultGroup: String
    get() {
        val parent = this.parent ?: return ""
        return rootProject.name + if (parent === rootProject) "" else "." + parent.path.substring(1).replace(':', '.')
    }

val Project.isGroupSet: Boolean get() = !isGroupNotSet

val Project.isGroupNotSet: Boolean
    get() = group.toString().run {
        if (isEmpty()) return@run true
        if (defaultGroup == this) return true
        return@run false
    }

val Project.isVersionSet: Boolean get() = !isVersionNotSet

val Project.isVersionNotSet: Boolean
    get() = version.toString().run {
        if (isEmpty()) return@run true
        if (Project.DEFAULT_VERSION == this) return@run true
        return@run false
    }

val Project.isBuildSrcProject: Boolean get() = DEFAULT_BUILD_SRC_DIR == this.rootDir.name
