package name.remal.building.gradle_plugins.generate_sources.java

import groovy.lang.Closure
import groovy.lang.DelegatesTo
import name.remal.building.gradle_plugins.API
import name.remal.building.gradle_plugins.dsl.javaPackageName
import name.remal.building.gradle_plugins.generate_sources.GenerateSourcesTask
import name.remal.building.gradle_plugins.utils.delegateCall

@API
class GenerateJavaSourcesTask : GenerateSourcesTask<JavaClassSourceGenerator>() {

    init {
        classFileExtension = "java"
    }

    fun writeBuildInfo(configurer: (BuildInfoGenerator) -> Unit) {
        addSourceGeneration(BuildInfoGenerator()
            .apply { packageName = project.javaPackageName }
            .apply(configurer)
        )
    }

    fun writeBuildInfo(@DelegatesTo(value = BuildInfoGenerator::class, strategy = Closure.DELEGATE_FIRST) action: Closure<*>) = writeBuildInfo { action.delegateCall(it) }

    fun writeBuildInfo() = writeBuildInfo { }

}
