package name.remal.building.gradle_plugins.gitlab_tools

import name.remal.building.gradle_plugins.API
import name.remal.building.gradle_plugins.utils.getEnvOrNull

@API
abstract class AbstractGitlabRefTask : AbstractGitlabTask() {

    private var _gitRef: String? = getEnvOrNull("CI_COMMIT_SHA")

    var gitRef: String
        get() = _gitRef ?: throw IllegalStateException("gitRef is not set")
        set(value) {
            _gitRef = value
        }

}
